/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Route(path="/cert/basic_info", name="\u57fa\u672c\u4fe1\u606f")
public class BasicInfoActivity
extends BaseActivity {
    Button next;
    RadioGroup gender;
    EditText etName;
    EditText etId;
    String phone;
    Context context;
    CryptoDevType cardType;
    @Autowired(name="containerNum")
    public int containerNum;
    private static final String REGEX_NUMBER_IDCARD_FIRST = "[^0-9]";
    private static final String REGEX_NUMBER_IDCARD_SECOND = "[^[0-9Xx]$]";
    private String beforeStr;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_basic_info);
        this.context = this;
        this.etName = (EditText)this.findViewById(R.id.et_name);
        this.etName.setFilters(EditTextUtil.getDisableEmojFilter());
        this.gender = (RadioGroup)this.findViewById(R.id.gender);
        this.etId = (EditText)this.findViewById(R.id.et_id);
        this.etId.setFilters(EditTextUtil.getDisableEmojFilter());
        this.etId.setFilters(new InputFilter[]{new InputFilter.LengthFilter(18)});
        this.etId.setRawInputType(2);
        this.etId.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                BasicInfoActivity.this.beforeStr = s.toString();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                Pattern p;
                Matcher m;
                String str;
                String editable = BasicInfoActivity.this.etId.getText().toString();
                if (!editable.equals(str = (m = (p = BasicInfoActivity.this.beforeStr.length() <= 16 ? Pattern.compile(BasicInfoActivity.REGEX_NUMBER_IDCARD_FIRST) : Pattern.compile(BasicInfoActivity.REGEX_NUMBER_IDCARD_SECOND)).matcher(editable)).replaceAll("").trim())) {
                    BasicInfoActivity.this.etId.setText((CharSequence)str);
                    BasicInfoActivity.this.etId.setSelection(str.length());
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.phone = SharePreferencesUtil.getPhoneNum((Context)this);
        this.next = (Button)this.findViewById(R.id.next);
        int city = AppConfig.getInstance().getProject();
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
            this.next.setText(R.string.cert_creation_submit);
        }
        this.next.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!BasicInfoActivity.this.validContent()) {
                    return;
                }
                RequestCache.getInstance().setTime(System.currentTimeMillis());
                BasicInfoActivity.this.cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType((Context)BasicInfoActivity.this));
                String cardNum = SharePreferencesUtil.getDevCardID((Context)BasicInfoActivity.this);
                if (ValidUtil.cardType(BasicInfoActivity.this.cardType) && ValidUtil.cardNum(cardNum) && ValidUtil.name(BasicInfoActivity.this.etName.getText().toString()) && ValidUtil.idNum(BasicInfoActivity.this.etId.getText().toString())) {
                    BasicInfoActivity.this.saveValues();
                    ApplyCertUtil.start((Context)BasicInfoActivity.this, BasicInfoActivity.this.containerNum, new ApplyCertUtil.WhatHappen(){

                        @Override
                        public void showDialog() {
                            BasicInfoActivity.this.showLoading();
                        }

                        @Override
                        public void cancelDialog() {
                            BasicInfoActivity.this.dismissLoading();
                        }

                        @Override
                        public void IOError() {
                            BasicInfoActivity.this.dismissLoading();
                            BasicInfoActivity.this.showRequestError();
                        }

                        @Override
                        public void handleResult(CommonResponse response) {
                            ApplyCertUtil.handleSuccessResult((Context)BasicInfoActivity.this, response);
                        }

                        @Override
                        public void handleError(BaseErrorResponse baseErrorResponse) {
                            BasicInfoActivity.this.handleError(baseErrorResponse);
                        }
                    });
                }
            }
        });
    }

    private boolean validContent() {
        String name = this.etName.getText().toString();
        if (name.isEmpty() || name.length() <= 0) {
            ModuleToast.show(this.context, this.getResources().getString(R.string.cert_creation_error_name_not_null));
            return false;
        }
        String idNo = this.etId.getText().toString().toUpperCase();
        if (idNo.isEmpty() || idNo.length() <= 0) {
            ModuleToast.show(this.context, this.getResources().getString(R.string.cert_creation_error_id_not_null));
            return false;
        }
        if (!idNo.isEmpty() && idNo.length() < 18) {
            ModuleToast.show(this.context, this.getResources().getString(R.string.cert_creation_error_id_size));
            return false;
        }
        return true;
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(this.cardType, this.containerNum, SharePreferencesUtil.getDevCardID((Context)this), null, baseErrorResponse));
        OttoUtil.postFinishActivity();
    }

    private void saveValues() {
        SharePreferencesUtil.savePhone(this.context, this.phone);
        SharePreferencesUtil.saveIDCardNo((Context)this, this.cardType.getType(), this.etId.getText().toString().toUpperCase());
        SharePreferencesUtil.saveSex((Context)this, this.cardType.getType(), this.gender.getCheckedRadioButtonId() == R.id.male ? 1 : 2);
        SharePreferencesUtil.saveName((Context)this, this.etName.getText().toString());
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }

    protected int getTitleRes() {
        return R.string.cert_creation_activity_basic_info;
    }

    protected boolean isOCRActivity() {
        return true;
    }
}

