/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CertInfoUpdateRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.request.UpdateInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.RevokeResultEvent;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.Util;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import java.io.Serializable;
import okhttp3.Call;

@Route(name="\u8bc1\u4e66\u8be6\u60c5", path="/cert/cert_detail_info")
public class CertDetailInfoActivity
extends BaseActivity {
    private TextView sn;
    private TextView ver;
    private TextView signAlg;
    private TextView user;
    private TextView issuer;
    private TextView notBefore;
    private TextView notAfter;
    private ImageView ivInUse;
    @Autowired(name="chipBean")
    public ChipBean bean;
    private CertDetailInfo certDetailInfo;
    @Autowired(name="inUse")
    public boolean inUse;
    private FrameLayout certStatus;
    private CertService certService = new CertService();
    private Context context;
    private CryptoDevType chipBeanType;
    private String cardID;
    @Autowired(name="containerNum")
    public int containerNum;
    @Autowired(name="certType")
    public String certType;
    private PinDialog pinDialog;
    private final int REVOKE_CERT = 1;
    private final int DELETE_CERT = 2;
    private final int UPDATE_CERT_INFO = 3;
    private int operate_type = -1;
    private boolean isShowUpdate = true;
    private static Handler myHandler = new Handler();
    @Autowired(name="allowApplyCert")
    public boolean allowApplyCert;
    private BindIdentifyDialog bindIdentifyDialog = null;
    Button revoke;
    Button revoke_full;
    Button delete;
    Button update;
    Button refresh;
    RelativeLayout bottomButton;

    private void showInvalidPermissionDialog() {
        this.bindIdentifyDialog = new BindIdentifyDialog(this.context);
        this.bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        this.bindIdentifyDialog.setMessage(R.string.cert_creation_cert_have_expired);
        this.bindIdentifyDialog.setModel(2);
        this.bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_close);
        this.bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_update);
        this.bindIdentifyDialog.setCancelable(false);
        this.bindIdentifyDialog.setCanceledOnTouchOutside(false);
        this.bindIdentifyDialog.show();
        this.bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                CertDetailInfoActivity.this.bindIdentifyDialog.dismiss();
                CertDetailInfoActivity.this.operate_type = 3;
                CertDetailInfoActivity.this.showPinDialog();
            }

            public void doCancel() {
                CertDetailInfoActivity.this.bindIdentifyDialog.dismiss();
            }
        });
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_cert_detail);
        this.context = this;
        this.initView();
        this.bean = (ChipBean)this.getIntent().getSerializableExtra("chipBean");
        this.chipBeanType = CryptoDevTypeUtil.formatType(this.bean.getType());
        this.certDetailInfo = this.bean.getCertBean();
        this.cardID = DeviceWrapper.getInstance().getCardID(this.chipBeanType);
        this.showCertState();
        this.showData(this.certDetailInfo);
    }

    private void initView() {
        this.certStatus = (FrameLayout)this.findViewById(R.id.cert_detail_status);
        this.sn = (TextView)this.findViewById(R.id.sn_text);
        this.ver = (TextView)this.findViewById(R.id.ver_text);
        this.signAlg = (TextView)this.findViewById(R.id.signAlg_text);
        this.user = (TextView)this.findViewById(R.id.user_text);
        this.issuer = (TextView)this.findViewById(R.id.issuer_text);
        this.notBefore = (TextView)this.findViewById(R.id.indate_start);
        this.notAfter = (TextView)this.findViewById(R.id.indate_end);
        this.revoke = (Button)this.findViewById(R.id.revoked_btn);
        this.delete = (Button)this.findViewById(R.id.delete_cert_btn);
        this.update = (Button)this.findViewById(R.id.update_cert_btn);
        this.refresh = (Button)this.findViewById(R.id.refresh_cert_btn);
        this.revoke_full = (Button)this.findViewById(R.id.revoked_full_btn);
        this.bottomButton = (RelativeLayout)this.findViewById(R.id.bottom_button);
        this.ivInUse = (ImageView)this.findViewById(R.id.in_use);
        this.ivInUse.setVisibility(this.inUse ? 0 : 8);
    }

    private void showBtn(Button btn) {
        this.revoke.setVisibility(8);
        this.delete.setVisibility(8);
        this.update.setVisibility(8);
        this.refresh.setVisibility(8);
        this.revoke_full.setVisibility(8);
        boolean allowUpdate = AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f");
        if (!this.allowApplyCert) {
            this.bottomButton.setVisibility(8);
        }
        if (btn == this.revoke) {
            if (allowUpdate) {
                this.revoke.setVisibility(0);
            } else {
                this.revoke_full.setVisibility(0);
            }
        }
        if (btn == this.delete) {
            this.delete.setVisibility(0);
        }
        if (btn == this.update) {
            this.update.setVisibility(0);
        }
        if (btn == this.refresh) {
            this.refresh.setVisibility(0);
        }
    }

    private void showData(CertDetailInfo certDetailInfo) {
        this.sn.setText((CharSequence)certDetailInfo.sn);
        this.ver.setText((CharSequence)("" + certDetailInfo.ver));
        this.signAlg.setText((CharSequence)certDetailInfo.alg);
        String userStr = certDetailInfo.subjectCn;
        String userContent = userStr.replaceAll(",", "\n");
        this.user.setText((CharSequence)userContent);
        String issuerStr = certDetailInfo.issuerCn;
        String issuerContent = issuerStr.replaceAll(",", "\n");
        this.issuer.setText((CharSequence)issuerContent);
        this.notBefore.setText((CharSequence)certDetailInfo.getNotBefore());
        this.notAfter.setText((CharSequence)certDetailInfo.getNotAfter());
    }

    private void showCertNormal() {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_normal, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        if (AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f") && Util.certValidIsExpire(this.certDetailInfo) && this.isShowUpdate) {
            this.showNotifyDialog();
        }
        this.showBtn(this.revoke);
        if (!AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f")) {
            this.update.setVisibility(8);
        } else {
            this.update.setVisibility(0);
        }
        this.update.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertDetailInfoActivity.this.operate_type = 3;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.revoke.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 1;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.revoke_full.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 1;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
    }

    private void showWaitRevoke(@StringRes int strId) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_wait_agree_revoke, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        this.showBtn(this.refresh);
        this.refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.queryCertStateFromServer();
            }
        });
    }

    private void showNoCurrentPki(int strID) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_verify_fail, null);
        TextView revokeInfo1 = (TextView)view.findViewById(R.id.revokeInfo1);
        revokeInfo1.setText(strID);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        this.showBtn(this.delete);
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 2;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
    }

    private void showServerNoCert() {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_server_nocert, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        this.showBtn(this.delete);
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 2;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
    }

    private void showAgreeRevoke() {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_agree_revoke, null);
        TextView status = (TextView)view.findViewById(R.id.revoked);
        status.setText((CharSequence)this.getResources().getString(R.string.cert_creation_detail_revoke_success));
        this.showBtn(this.delete);
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 2;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
    }

    private void showException(String message) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_error, null);
        TextView reason = (TextView)view.findViewById(R.id.reason);
        reason.setText((CharSequence)message);
        this.showBtn(this.refresh);
        this.refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!CertDetailInfoActivity.this.bean.getIsVerify()) {
                    CertDetailInfoActivity.this.showNoCurrentPki();
                } else {
                    CertDetailInfoActivity.this.queryCertStateFromServer();
                }
            }
        });
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
    }

    private void showNoCurrentPki() {
        this.showNoCurrentPki(R.string.cert_creation_cert_not_in_system);
    }

    private void showNotifyDialog() {
        this.showInvalidPermissionDialog();
    }

    private void showPinDialog() {
        if (this.pinDialog == null) {
            this.pinDialog = new PinDialog(this.context, this.chipBeanType, this.containerNum, new PinDialog.HandlePinResult(){

                @Override
                public void onSuccess() {
                    if (CertDetailInfoActivity.this.operate_type == 1) {
                        CertDetailInfoActivity.this.startReasonActivity();
                    } else if (CertDetailInfoActivity.this.operate_type == 2) {
                        new ClearContainerTask().execute(new Object[0]);
                    } else {
                        ARouter.getInstance().build("/cert/update").withString("cardNum", CertDetailInfoActivity.this.cardID).withSerializable("chipBean", (Serializable)CertDetailInfoActivity.this.bean).withString("certType", CertDetailInfoActivity.this.certType).navigation(CertDetailInfoActivity.this.context);
                    }
                    CertDetailInfoActivity.this.operate_type = -1;
                    CertDetailInfoActivity.this.pinDialog = null;
                }

                @Override
                public void onFail(int pinResult) {
                    CertDetailInfoActivity.this.handleErrorResponse(CryptoDevManager.getInstance().getErrorText(pinResult));
                }
            });
        }
        this.pinDialog.show();
    }

    private void showCertState() {
        if (!this.bean.getIsVerify()) {
            this.showNoCurrentPki();
        } else {
            switch (this.bean.getState()) {
                case NET_ERROR: {
                    this.showException(this.getResources().getString(R.string.net_disconnected_text));
                    break;
                }
                case NET_TIMEOUT: {
                    this.showException(this.getResources().getString(R.string.net_timeout));
                    break;
                }
                case SUCCESS: {
                    this.showCertNormal();
                    break;
                }
                case WAITING_AGREE_REVOKE: {
                    this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    break;
                }
                case AGREE_REVOKE: {
                    this.showAgreeRevoke();
                    break;
                }
                case REJECT_REVOKE: {
                    this.showRejectRevoke(R.string.cert_creation_revoke_reject, this.bean.getReason());
                    break;
                }
                case SERVER_NOCERT: {
                    this.showNoCurrentPki(R.string.cert_creation_server_no_cert_local_has_cert);
                    break;
                }
                case CERT_OUT_OF_DATE: {
                    this.showNoCurrentPki(R.string.cert_creation_cert_out_of_date);
                }
            }
        }
    }

    private void startReasonActivity() {
        ARouter.getInstance().build("/cert/reason").withInt("type", 2).withSerializable("chipBean", (Serializable)this.bean).withString("cardId", this.cardID).withString("certType", this.certType).withInt("containerNum", this.containerNum).navigation((Activity)this, 2);
    }

    private void fixCommonPin(String code) {
        if (!AppConfig.getInstance().getDefaultConfig().getPin().equals(code)) {
            AppConfig.getInstance().getDefaultConfig().setPin(code);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 1) {
            String reason = data.getStringExtra("reason");
            this.recoveryCert(reason);
        }
    }

    @Subscribe
    public void handleRevokeResult(RevokeResultEvent event) {
        CertState state = event.getChipBean().getState();
        if (state == CertState.WAITING_AGREE_REVOKE) {
            this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
        } else if (state == CertState.AGREE_REVOKE) {
            this.showAgreeRevoke();
        } else if (state == CertState.REJECT_REVOKE) {
            this.showRejectRevoke(R.string.cert_creation_revoke_reject, event.getReason());
        }
    }

    private void showRejectRevoke(@StringRes int strId, String msg) {
        View view = LayoutInflater.from((Context)this).inflate(R.layout.cert_detail_reject_revoke, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        TextView revoke = (TextView)view.findViewById(R.id.revoked);
        revoke.setText(strId);
        TextView reason = (TextView)view.findViewById(R.id.reason);
        String text = this.getResources().getString(R.string.cert_creation_reason) + msg;
        reason.setText((CharSequence)text);
        this.refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.queryCertStateFromServer();
            }
        });
        this.refresh.setVisibility(0);
        this.delete.setVisibility(8);
    }

    protected int getTitleRes() {
        return R.string.cert_creation_cert_detail;
    }

    private void revokeCert(String revokeReason) {
        this.showLoading(R.string.cert_creation_is_revoking_cert);
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000L);
            return;
        }
        this.showException(this.getResources().getString(R.string.net_timeout));
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        if (this.certDetailInfo == null) {
            ModuleLog.e((Object)"sn\u4e3a\u7a7a");
            return;
        }
        String sn = this.certDetailInfo.sn;
        info.setSn(sn);
        info.setReason(revokeReason);
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, info.toString());
        if (sign != null) {
            if (sign.startsWith("errorCode")) {
                this.showPinDialog();
                return;
            }
            revokeRequest.setSign(sign);
        } else {
            ModuleToast.show(this.context, R.string.cert_creation_signFail);
        }
        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        this.certService.revokedCert(revokeRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.WAITING_AGREE_REVOKE);
                    CertDetailInfoActivity.this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("1")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.AGREE_REVOKE);
                    CertDetailInfoActivity.this.showAgreeRevoke();
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("2")) {
                    CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_revoke_reject, commonResponse.getMessage());
                } else if (result.equals("5") || result.equals("6")) {
                    // empty if block
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void recoveryCert(String revokeReason) {
        this.showLoading(R.string.cert_creation_is_recoverying_cert);
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000L);
            return;
        }
        this.showException(this.getResources().getString(R.string.net_timeout));
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        if (this.certDetailInfo == null) {
            ModuleLog.e((Object)"sn\u4e3a\u7a7a");
            return;
        }
        String sn = this.certDetailInfo.sn;
        info.setSn(sn);
        info.setReason(revokeReason);
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, info.toString());
        if (sign.startsWith("errorCode")) {
            this.showPinDialog();
            return;
        }
        revokeRequest.setSign(sign);
        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        this.certService.thawingCert(revokeRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.RECOVERY_PROGRESS);
                    CertDetailInfoActivity.this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("1")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.RECOVERY_SUCCESS);
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("2")) {
                    CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_recovery_fail, commonResponse.getMessage());
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void queryCertStateFromServer() {
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            ModuleToast.show(this.context, R.string.net_disconnected_text);
            myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
                    CertDetailInfoActivity.this.dismissLoading();
                }
            }, 1000L);
            return;
        }
        myHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CertDetailInfoActivity.this.dismissLoading();
            }
        }, 1000L);
        this.showLoading(R.string.cert_creation_is_checking_cert);
        CertStateRequest certStateRequest = new CertStateRequest();
        if (this.certDetailInfo != null) {
            certStateRequest.setSn(this.certDetailInfo.sn);
        } else {
            certStateRequest.setSn("");
        }
        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        this.certService.certStateQuery(certStateRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.cert_creation_device_not_exist));
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.WAITING_AGREE_REVOKE);
                    CertDetailInfoActivity.this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("1")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.AGREE_REVOKE);
                    CertDetailInfoActivity.this.showAgreeRevoke();
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("2")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.REJECT_REVOKE);
                    CertDetailInfoActivity.this.bean.setReason(commonResponse.getMessage());
                    CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_revoke_reject, commonResponse.getMessage());
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("3")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.SUCCESS);
                    CertDetailInfoActivity.this.showCertNormal();
                } else if (result.equals("4")) {
                    CertDetailInfoActivity.this.showServerNoCert();
                } else if (result.equals("5") || result.equals("6") || result.equals("7") || result.equals("8") || result.equals("9") || result.equals("10") || result.equals("11") || result.equals("12") || result.equals("13") || result.equals("14")) {
                    // empty if block
                }
                CertDetailInfoActivity.this.dismissLoading();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
                CertDetailInfoActivity.this.dismissLoading();
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void updateCert() {
        this.showLoading(R.string.cert_creation_is_update_cert);
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000L);
            return;
        }
        this.showException(this.getResources().getString(R.string.net_timeout));
        if (this.certDetailInfo == null) {
            return;
        }
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setSn(this.certDetailInfo.sn);
        updateInfo.setTime(System.currentTimeMillis());
        updateInfo.setType("1");
        updateInfo.setReason("");
        String p10 = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, this.certDetailInfo.subjectCn, false);
        updateInfo.setP10(p10);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, updateInfo.toString());
        CertInfoUpdateRequest certUpdateRequest = new CertInfoUpdateRequest();
        certUpdateRequest.setSign(sign);
        certUpdateRequest.setInfo(updateInfo);
        this.certService.updateOrDelayCert(certUpdateRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertDetailInfoActivity.this.showWaitRevoke(R.string.cert_creation_update_info_need_verify_please_wait);
                } else if (result.equals("1")) {
                    String certStr = commonResponse.getMessage();
                    CertDetailInfoActivity.this.writeCert(certStr);
                } else if (result.equals("2")) {
                    CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_update_info_reject, commonResponse.getMessage());
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void writeCert(final String cert2) {
        if (TextUtils.isEmpty((CharSequence)cert2)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final int result = DeviceWrapper.getInstance().writeCert(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, cert2);
                CertDetailInfoActivity.this.certDetailInfo = DeviceWrapper.getInstance().readCertFromContainer(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.certType);
                myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (result == 0) {
                            CertDetailInfoActivity.this.showData(CertDetailInfoActivity.this.certDetailInfo);
                            CertDetailInfoActivity.this.showCertNormal();
                            CertDetailInfoActivity.this.bean.setState(CertState.AGREE_UPDATE);
                            CertDetailInfoActivity.this.bean.setCertDetailInfo(CertDetailInfoActivity.this.certDetailInfo);
                            OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                        } else {
                            CertDetailInfoActivity.this.writeCertToServer(CertDetailInfoActivity.this.chipBeanType, DeviceWrapper.getInstance().getSn(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, cert2), "1");
                        }
                    }
                }, 10L);
            }
        };
        new ChipExecutorService().exe(runnable);
    }

    private void writeCertToServer(CryptoDevType type, String sn, String status) {
        WriteFailRequest request = new WriteFailRequest();
        WriteFailInfo info = new WriteFailInfo();
        info.setSn(sn);
        info.setStatus(status);
        info.setTime(System.currentTimeMillis());
        request.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(type, this.containerNum, info.toString());
        if (sign.startsWith("errorCode")) {
            this.showException(sign.substring(9));
            return;
        }
        request.setSign(sign);
        request.setCardType("" + CryptoDevTypeUtil.convertCardType(type.getType()));
        this.certService.uploadWriteCertResult(request, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)CertDetailInfoActivity.this.context) ? R.string.net_disconnected_text : R.string.net_timeout;
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.cert_creation_write_authentiation_fail));
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void handleErrorResponse(String errorCode) {
        String msg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
        this.showException(msg);
    }

    private class ClearContainerTask
    extends AsyncTask {
        int result;

        private ClearContainerTask() {
        }

        protected Object doInBackground(Object[] objects) {
            this.result = DeviceWrapper.getInstance().clearContainer(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum);
            return this.result;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            CertDetailInfoActivity.this.showLoading(R.string.cert_creation_is_deleting_cert);
        }

        protected void onPostExecute(Object o) {
            super.onPostExecute(o);
            if (this.result == 0) {
                CertDetailInfoActivity.this.bean.setState(CertState.DELETE_SUCCESS);
                OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                CertDetailInfoActivity.this.dismissLoading();
                CertDetailInfoActivity.this.finish();
            } else {
                ModuleToast.show(CertDetailInfoActivity.this.context, CertDetailInfoActivity.this.getResources().getString(R.string.cert_creation_delete_cert_fail));
                CertDetailInfoActivity.this.dismissLoading();
            }
        }
    }
}

