/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.xdja.aspectjmodule.advise.AdvisePermission;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.ConfigStep1Activity$AjcClosure1;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Route(path="/cert/config_step1", name="\u7b2c\u4e00\u4e2a\u914d\u7f6e\u754c\u9762")
public class ConfigStep1Activity
extends BaseActivity
implements View.OnClickListener {
    private View next;
    private EditText etProjectName;
    private EditText etAirCertIP;
    private EditText etAirCertPort;
    private Button connect;
    private EditText etVHSMIP;
    private EditText etVHSMPort;
    private Button connectVHSM;
    ConfigHandler handler = new ConfigHandler();
    public static final int CONNECT_SUCCESS = 0;
    public static final int CONNECT_FAILED = 1;
    public static final int SET_CONNECT_TEST = 2;
    public static final int SET_CONNECTING = 3;
    public static final int DISABLE_PIN = 4;
    public static final int ENABLE_PIN = 5;
    public static final int SERVER_SUCCESS = 6;
    public static final int SERVER_FAILED = 7;
    private String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_config_step1);
        if (!this.checkValidPermission(this.permissions)) {
            this.showInvalidPermissionDialog();
        }
        this.initView();
        this.initViewByData();
    }

    private void initView() {
        this.etProjectName = (EditText)this.findViewById(R.id.project_name);
        this.etProjectName.setFilters(EditTextUtil.getDisableEmojFilter(20));
        this.etAirCertIP = (EditText)this.findViewById(R.id.nfc_ip_result);
        this.etAirCertIP.setFilters(EditTextUtil.getDisableEmojFilter());
        this.etAirCertPort = (EditText)this.findViewById(R.id.port);
        this.etAirCertPort.setFilters(EditTextUtil.getDisableEmojFilter());
        this.etVHSMIP = (EditText)this.findViewById(R.id.vhsm_ip_result);
        this.etVHSMIP.setFilters(EditTextUtil.getDisableEmojFilter());
        this.etVHSMPort = (EditText)this.findViewById(R.id.vhsm_port);
        this.etVHSMPort.setFilters(EditTextUtil.getDisableEmojFilter());
        this.next = this.findViewById(R.id.next);
        this.next.setOnClickListener((View.OnClickListener)this);
        this.connect = (Button)this.findViewById(R.id.connect);
        this.connect.setOnClickListener((View.OnClickListener)this);
        this.connectVHSM = (Button)this.findViewById(R.id.vhsm_connect);
        this.connectVHSM.setOnClickListener((View.OnClickListener)this);
    }

    private void initViewByData() {
        String vhsm_port;
        String vhsm_ip;
        String port;
        String ip;
        ServerSettingConfig serverSettingConfig = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
        if (serverSettingConfig == null) {
            return;
        }
        String projectName = serverSettingConfig.getProjectName();
        if (!TextUtils.isEmpty((CharSequence)projectName)) {
            this.etProjectName.setText((CharSequence)projectName);
        }
        if (!TextUtils.isEmpty((CharSequence)(ip = serverSettingConfig.getIp()))) {
            this.etAirCertIP.setText((CharSequence)ip);
        }
        if (!TextUtils.isEmpty((CharSequence)(port = serverSettingConfig.getPort()))) {
            this.etAirCertPort.setText((CharSequence)port);
        }
        if (!TextUtils.isEmpty((CharSequence)(vhsm_ip = serverSettingConfig.getVhsm_ip()))) {
            this.etAirCertIP.setText((CharSequence)vhsm_ip);
        }
        if (!TextUtils.isEmpty((CharSequence)(vhsm_port = serverSettingConfig.getVhsm_port()))) {
            this.etAirCertPort.setText((CharSequence)vhsm_port);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.next) {
            this.next();
        } else if (id2 == R.id.connect) {
            this.ping(this.etAirCertIP.getText().toString());
        } else if (id2 == R.id.vhsm_connect) {
            this.ping(this.etVHSMIP.getText().toString());
        }
    }

    @Override
    public boolean valid() {
        boolean success = false;
        if (this.validProjectName() && this.validIP(this.etVHSMIP.getText().toString()) && this.validPort(this.etVHSMPort.getText().toString()) && this.validIP(this.etAirCertIP.getText().toString()) && this.validPort(this.etAirCertPort.getText().toString())) {
            success = true;
        }
        return success;
    }

    private boolean validProjectName() {
        String projectName = this.etProjectName.getText().toString();
        if (TextUtils.isEmpty((CharSequence)projectName)) {
            ModuleToast.show(this.context, R.string.cert_creation_please_input_project_name);
            return false;
        }
        if (projectName.length() > 20) {
            ModuleToast.show(this.context, R.string.cert_creation_err_length_project_name);
            return false;
        }
        return true;
    }

    private boolean validIP(String ip) {
        boolean success = AddressUtil.validIP(ip);
        if (!success) {
            ModuleToast.show(this.context, R.string.cert_creation_config_error_server_address);
        }
        return success;
    }

    private boolean validPort(String port) {
        boolean success = AddressUtil.validPort(port);
        if (!success) {
            ModuleToast.show(this.context, R.string.cert_creation_config_error_server_port);
        }
        return success;
    }

    @Override
    public void saveValue() {
        super.saveValue();
    }

    @Override
    public String nextActivity() {
        return "/cert/config_step2";
    }

    @Override
    public void route() {
        super.route();
        ARouter.getInstance().build(this.nextActivity()).withString("projectName", this.etProjectName.getText().toString()).withString("serverIP", this.etAirCertIP.getText().toString()).withString("vhsmServerIP", this.etVHSMIP.getText().toString()).withString("vhsmServerPort", this.etVHSMPort.getText().toString()).withString("serverPort", this.etAirCertPort.getText().toString()).navigation(this.context);
    }

    private void ping(String ip) {
        this.setConnecting();
        this.disablePing();
        this.pingServer(ip);
    }

    private void setConnecting() {
        this.handler.sendEmptyMessage(3);
    }

    private void disablePing() {
        this.handler.sendEmptyMessage(4);
    }

    private void pingServer(String ip) {
        this.pingIP(ip);
    }

    private void pingIP(final String ip) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec("ping -c 1 -w 2 " + ip);
                    int status = p.waitFor();
                    if (status == 0) {
                        ConfigStep1Activity.this.handler.sendEmptyMessage(6);
                    } else {
                        ConfigStep1Activity.this.handler.sendEmptyMessage(7);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ConfigStep1Activity.this.handler.sendEmptyMessage(7);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ConfigStep1Activity.this.handler.sendEmptyMessage(7);
                }
            }
        }).start();
    }

    private void showResult(boolean success) {
        this.handler.sendEmptyMessage(success ? 0 : 1);
        this.setConnectText();
        this.enablePing();
    }

    private void setConnectText() {
        this.handler.sendEmptyMessage(2);
    }

    private void enablePing() {
        this.handler.sendEmptyMessage(5);
    }

    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                ConfigStep1Activity.this.checkoutPermission();
            }

            public void doCancel() {
                bindIdentifyDialog.dismiss();
                ConfigStep1Activity.this.finish();
            }
        });
    }

    @XdjaPermission(permissions={"android.permission.WRITE_EXTERNAL_STORAGE"})
    private void checkoutPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new ConfigStep1Activity$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ConfigStep1Activity.class.getDeclaredMethod("checkoutPermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ModuleLog.d((Object)"\u6743\u9650\u56de\u8c03");
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            }
            isGrant = true;
        }
        this.onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(final boolean isGrant) {
        this.getWindow().getDecorView().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!isGrant) {
                    ConfigStep1Activity.this.showNoPhonePermissionDialog();
                }
            }
        }, 10L);
    }

    public void showNoPhonePermissionDialog() {
        if (this.dialog == null) {
            this.initNoPermissionDialog();
        }
        this.dialog.show();
    }

    private void initNoPermissionDialog() {
        SinglePermissionDialog dialog = new SinglePermissionDialog();
        dialog.build((Context)this, 0);
    }

    static {
        ConfigStep1Activity.ajc$preClinit();
    }

    static final /* synthetic */ void checkoutPermission_aroundBody0(ConfigStep1Activity ajc$this, JoinPoint joinPoint) {
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigStep1Activity.java", ConfigStep1Activity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkoutPermission", "com.xdja.safeclient.certcreation.activity.ConfigStep1Activity", "", "", "", "void"), 472);
    }

    class ConfigHandler
    extends Handler {
        ConfigHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 0) {
                ModuleToast.showNoRepeat(ConfigStep1Activity.this.context, R.string.cert_creation_connect_success);
            } else if (msg.what == 1) {
                ModuleToast.showNoRepeat(ConfigStep1Activity.this.context, R.string.cert_creation_connect_failed);
            } else if (msg.what == 2) {
                ConfigStep1Activity.this.connect.setText(R.string.cert_creation_config_test);
            } else if (msg.what == 3) {
                ConfigStep1Activity.this.connect.setText(R.string.cert_creation_config_connecting);
            } else if (msg.what == 4) {
                ConfigStep1Activity.this.connect.setClickable(false);
            } else if (msg.what == 5) {
                ConfigStep1Activity.this.connect.setClickable(true);
            } else if (msg.what == 6) {
                ConfigStep1Activity.this.showResult(true);
            } else if (msg.what == 7) {
                ConfigStep1Activity.this.showResult(false);
            }
        }
    }
}

