/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.a3rdplugin.demo.NFCCompany;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.aspectjmodule.advise.AdvisePermission;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.ConfigStep3Activity$AjcClosure1;
import com.xdja.safeclient.certcreation.adapter.CertConfigAdapter;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.event.ChooseConfigEvent;
import com.xdja.safeclient.certcreation.event.DeleteCertConfigEvent;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.ConfigDialog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Route(path="/cert/config_step3", name="\u7b2c\u4e09\u4e2a\u914d\u7f6e\u754c\u9762")
public class ConfigStep3Activity
extends BaseActivity
implements View.OnClickListener {
    public static final String DEFAULT_CARD_TYPE_TEXT = "\u8bf7\u9009\u62e9";
    @Autowired
    public String projectName;
    @Autowired
    public String serverIP;
    @Autowired
    public String serverPort;
    @Autowired
    public String vhsmServerIP;
    @Autowired
    public String vhsmServerPort;
    @Autowired(name="procedure")
    public String procedure;
    RecyclerView recyclerView;
    List<TableCertConfig> list;
    CertConfigAdapter adapter;
    Button addNewCard;
    Button export;
    private View liveCompanyView;
    private TextView liveCompanyResult;
    private View ocrView;
    private TextView ocrResult;
    private View nfcView;
    private TextView nfcResult;
    private View nfcIPView;
    private EditText nfcIPResult;
    private View nfcPortView;
    private EditText nfcPortResult;
    private TextView exportHint;
    private CheckBox sAllowUpdate;
    private Button connect;
    private View layout3rdNServer;
    private View dividerLive;
    ConfigHandler handler = new ConfigHandler();
    private ServerSettingConfig serverSettingConfig;
    public static final String path;
    private boolean exportSuccess;
    public static final int CONNECT_SUCCESS = 0;
    public static final int CONNECT_FAILED = 1;
    public static final int SET_CONNECT_TEST = 2;
    public static final int SET_CONNECTING = 3;
    public static final int DISABLE_PIN = 4;
    public static final int ENABLE_PIN = 5;
    public static final int SERVER_SUCCESS = 6;
    public static final int SERVER_FAILED = 7;
    private String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_config_step3);
        ARouter.getInstance().inject((Object)this);
        this.initData();
        this.initView();
        this.initViewByData();
        if (this.list.size() == 0 || this.list == null) {
            this.list = new ArrayList<TableCertConfig>();
            this.list.add(this.defaultCertConfig());
        }
        this.recyclerView = (RecyclerView)this.findViewById(R.id.list_device_detail);
        this.adapter = new CertConfigAdapter(this.context, this.list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.context){

            public boolean canScrollVertically() {
                return false;
            }
        };
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.resize();
    }

    private void initData() {
        this.serverSettingConfig = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
        this.list = SQLite.select((IProperty[])new IProperty[0]).from(TableCertConfig.class).queryList();
        ModuleLog.d((Object)this.serverSettingConfig);
        ModuleLog.d(this.list);
        Log.e((String)"jff", (String)("194 ConfigStep3Activity initData : " + this.list));
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.connect) {
            this.ping();
        } else if (id2 == R.id.add_new_card) {
            this.list.add(this.defaultCertConfig());
            this.adapter.notifyDataSetChanged();
            this.resize();
        } else if (id2 == R.id.export) {
            boolean success = this.validBeforeExport();
            if (!success) {
                return;
            }
            this.showExportDialog();
        }
    }

    private void ping() {
        this.setConnecting();
        this.disablePing();
        this.pingServer();
    }

    private void setConnecting() {
        this.handler.sendEmptyMessage(3);
    }

    private void disablePing() {
        this.handler.sendEmptyMessage(4);
    }

    private void pingServer() {
        this.ping(this.nfcIPResult.getText().toString());
    }

    private void ping(final String ip) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec("ping -c 1 -w 2 " + ip);
                    int status = p.waitFor();
                    if (status == 0) {
                        ConfigStep3Activity.this.handler.sendEmptyMessage(6);
                    } else {
                        ConfigStep3Activity.this.handler.sendEmptyMessage(7);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ConfigStep3Activity.this.handler.sendEmptyMessage(7);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ConfigStep3Activity.this.handler.sendEmptyMessage(7);
                }
            }
        }).start();
    }

    private void showResult(boolean success) {
        this.handler.sendEmptyMessage(success ? 0 : 1);
        this.setConnectText();
        this.enablePing();
    }

    private void setConnectText() {
        this.handler.sendEmptyMessage(2);
    }

    private void enablePing() {
        this.handler.sendEmptyMessage(5);
    }

    private void resize() {
        this.recyclerView.setMinimumHeight(ScreenUtil.dip2px(this.context, 317.0f) * this.list.size());
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Subscribe
    public void handleConfig(ChooseConfigEvent event) {
        ConfigBean value = event.getConfig();
        String text = value.getContent();
        int position = event.getPosition();
        if (position == -1) {
            if (LiveCompany.list.contains(value)) {
                this.liveCompanyResult.setText((CharSequence)text);
            } else if (NFCCompany.list.contains(value)) {
                this.nfcResult.setText((CharSequence)text);
            } else if (OCRCompany.list.contains(value)) {
                this.ocrResult.setText((CharSequence)text);
            }
        } else {
            TableCertConfig item = this.list.get(position);
            if (CardType.list.contains(value)) {
                item.setCardType(text);
            } else if (ContainerNum.list.contains(value)) {
                item.setContainerNum(Integer.parseInt(text));
            } else if (AlgType.list.contains(value)) {
                item.setAlgType(text);
            } else if (CertRule.list.contains(value)) {
                item.setCertRule(text);
            } else if (CertType.list.contains(value)) {
                item.setCertType(text);
            } else if (CertPermission.list.contains(value)) {
                item.setCertPermission(text);
            }
            this.list.set(position, item);
            this.adapter.notifyDataSetChanged();
        }
    }

    public TableCertConfig defaultCertConfig() {
        TableCertConfig certConfig = new TableCertConfig();
        certConfig.setPosition(this.list.size());
        certConfig.setCardType(DEFAULT_CARD_TYPE_TEXT);
        certConfig.setContainerNum(ContainerNum.getDefault());
        certConfig.setAlgType(AlgType.getDefaule());
        certConfig.setCertType(CertType.getDefault());
        certConfig.setCertRule(CertRule.getDefault());
        certConfig.setCertPermission(CertPermission.getDefault());
        return certConfig;
    }

    @Subscribe
    public void handleDeleteConfigDetail(DeleteCertConfigEvent event) {
        this.list.remove(event.getPosition());
        this.adapter.notifyDataSetChanged();
        this.resize();
    }

    private void initView() {
        this.dividerLive = this.findViewById(R.id.divider_live);
        this.connect = (Button)this.findViewById(R.id.connect);
        this.connect.setOnClickListener((View.OnClickListener)this);
        this.sAllowUpdate = (CheckBox)this.findViewById(R.id.switch_allow_update);
        this.exportHint = (TextView)this.findViewById(R.id.export_hint);
        this.exportSuccess = SharePreferencesUtil.getExportState(this.context);
        if (this.exportSuccess) {
            this.exportHint.setVisibility(0);
            this.exportHint.setText(R.string.cert_creation_save_success);
        }
        this.addNewCard = (Button)this.findViewById(R.id.add_new_card);
        this.addNewCard.setOnClickListener((View.OnClickListener)this);
        this.export = (Button)this.findViewById(R.id.export);
        this.export.setOnClickListener((View.OnClickListener)this);
        this.liveCompanyView = this.findViewById(R.id.live_company);
        this.liveCompanyView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(ConfigStep3Activity.this.context, LiveCompany.list);
            }
        });
        this.liveCompanyResult = (TextView)this.findViewById(R.id.live_company_result);
        this.ocrView = this.findViewById(R.id.ocr);
        this.ocrView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(ConfigStep3Activity.this.context, OCRCompany.list);
            }
        });
        this.ocrResult = (TextView)this.findViewById(R.id.ocr_result);
        this.nfcView = this.findViewById(R.id.nfc);
        this.nfcView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(ConfigStep3Activity.this.context, NFCCompany.list);
            }
        });
        this.nfcResult = (TextView)this.findViewById(R.id.nfc_result);
        this.nfcPortView = this.findViewById(R.id.nfc_port_view);
        this.nfcPortResult = (EditText)this.findViewById(R.id.nfc_port);
        this.nfcIPView = this.findViewById(R.id.nfc_ip_view);
        this.nfcIPResult = (EditText)this.findViewById(R.id.nfc_ip_result);
        this.layout3rdNServer = this.findViewById(R.id.layout_3rd_n_server);
        this.initDefault3rdConfig();
    }

    private void initViewByData() {
        if (this.serverSettingConfig == null) {
            return;
        }
        this.liveCompanyResult.setText((CharSequence)this.serverSettingConfig.getLiveCompany());
        this.ocrResult.setText((CharSequence)this.serverSettingConfig.getOcrCompany());
        this.nfcResult.setText((CharSequence)this.serverSettingConfig.getNfcCompany());
        this.nfcIPResult.setText((CharSequence)this.serverSettingConfig.getNfcServerIP());
        this.nfcPortResult.setText((CharSequence)this.serverSettingConfig.getNfcServerPort());
        this.sAllowUpdate.setChecked(this.serverSettingConfig.getAllowUpdate().equals("\u662f"));
    }

    private void initDefault3rdConfig() {
        if (!this.procedure.equals("\u6807\u51c6\u6d41\u7a0b")) {
            if (this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
                this.ocrView.setVisibility(8);
            } else if (this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0NFC\uff09")) {
                this.connect.setVisibility(8);
                this.ocrView.setVisibility(8);
                this.nfcView.setVisibility(8);
                this.nfcIPView.setVisibility(8);
                this.nfcPortView.setVisibility(8);
                this.dividerLive.setVisibility(8);
            } else if (this.procedure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
                this.layout3rdNServer.setVisibility(8);
            } else if (this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
                this.layout3rdNServer.setVisibility(8);
            }
        }
        if (this.layout3rdNServer.getVisibility() == 0 && this.liveCompanyView.getVisibility() == 0) {
            this.liveCompanyResult.setText((CharSequence)"\u4e91\u4ece");
        }
        if (this.layout3rdNServer.getVisibility() == 0 && this.ocrView.getVisibility() == 0) {
            this.ocrResult.setText((CharSequence)"\u4e91\u4ece");
        }
        if (this.layout3rdNServer.getVisibility() == 0 && this.nfcView.getVisibility() == 0) {
            this.nfcResult.setText((CharSequence)"\u4fe1\u5927\u6377\u5b89");
        }
    }

    private boolean validBeforeExport() {
        if (this.procedure.equals("\u6807\u51c6\u6d41\u7a0b") || this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
            String ip = this.nfcIPResult.getText().toString();
            if (TextUtils.isEmpty((CharSequence)ip)) {
                ModuleToast.show(this.context, R.string.cert_creation_config_please_input_nfc_address);
                return false;
            }
            boolean success = AddressUtil.validIP(ip);
            if (!success) {
                ModuleToast.show(this.context, R.string.cert_creation_config_error_nfc_address);
                return false;
            }
            String port = this.nfcPortResult.getText().toString();
            if (TextUtils.isEmpty((CharSequence)port)) {
                ModuleToast.show(this.context, R.string.cert_creation_config_please_input_server_port);
                return false;
            }
            success = AddressUtil.validPort(port);
            if (!success) {
                ModuleToast.show(this.context, R.string.cert_creation_config_error_server_port);
                return false;
            }
        }
        boolean success = this.validCertConfig();
        return success;
    }

    private boolean validCertConfig() {
        boolean success = true;
        for (TableCertConfig config : this.list) {
            int last;
            if (config.cardType.equals(DEFAULT_CARD_TYPE_TEXT)) {
                success = false;
                ModuleToast.show(this.context, R.string.cert_creation_config_please_choose_card_type);
                break;
            }
            int first = this.list.indexOf(config);
            if (first == (last = this.list.lastIndexOf(config))) continue;
            success = false;
            TableCertConfig config1 = this.list.get(first);
            TableCertConfig config2 = this.list.get(last);
            String cardType1 = config1.getCardType();
            String cardType2 = config2.getCardType();
            if (cardType1.equals("\u8054\u7f51VHSM") && cardType2.equals("\u79bb\u7ebfVHSM")) {
                ModuleToast.show(this.context, "\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\u79bb\u7ebfVHSM\u548c\u8054\u7f51VHSM");
                break;
            }
            if (cardType1.equals("\u79bb\u7ebfVHSM") && cardType2.equals("\u8054\u7f51VHSM")) {
                ModuleToast.show(this.context, "\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\u79bb\u7ebfVHSM\u548c\u8054\u7f51VHSM");
                break;
            }
            if (!config1.cardType.equals(config2.cardType)) break;
            if (config1.containerNum == config2.containerNum) {
                ModuleToast.show(this.context, R.string.cert_creation_repeat_container_num);
                break;
            }
            if (!config1.certPermission.equals("\u7533\u8bf7\u8bc1\u4e66") || !config2.certPermission.equals("\u7533\u8bf7\u8bc1\u4e66")) break;
            ModuleToast.show(this.context, R.string.cert_creation_repeat_cert_permission);
            break;
        }
        return success;
    }

    private void showExportDialog() {
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle("\u5bfc\u51fa\u914d\u7f6e\u6587\u4ef6");
        bindIdentifyDialog.setMessage("\u5bfc\u51fa\u524d\u8bf7\u786e\u8ba4\u6240\u6709\u4fe1\u606f\u5df2\u51c6\u786e\u914d\u7f6e");
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText("\u53d6\u6d88");
        bindIdentifyDialog.setPositiveButtonText("\u5bfc\u51fa");
        bindIdentifyDialog.setCancelable(true);
        bindIdentifyDialog.setCanceledOnTouchOutside(true);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                boolean hasPermission = ConfigStep3Activity.this.checkValidPermission(ConfigStep3Activity.this.permissions);
                if (!hasPermission) {
                    ConfigStep3Activity.this.showInvalidPermissionDialog();
                    return;
                }
                ConfigStep3Activity.this.deleteDatabase();
                ConfigStep3Activity.this.exportToSDCard();
                bindIdentifyDialog.cancel();
            }

            public void doCancel() {
                bindIdentifyDialog.cancel();
            }
        });
    }

    private void clearTableValue() {
        Delete.table(ServerSettingConfig.class, (SQLCondition[])new SQLCondition[0]);
        Delete.table(TableCertConfig.class, (SQLCondition[])new SQLCondition[0]);
    }

    private void exportToSDCard() {
        this.clearTableValue();
        ServerSettingConfig table = new ServerSettingConfig();
        table.liveCompany = this.liveCompanyResult.getText().toString();
        table.ocrCompany = this.ocrResult.getText().toString();
        table.nfcCompany = this.nfcResult.getText().toString();
        table.ip = this.serverIP;
        table.port = this.serverPort;
        table.setVhsm_ip(this.vhsmServerIP);
        table.setVhsm_port(this.vhsmServerPort);
        table.nfcServerIP = this.nfcIPResult.getText().toString();
        table.nfcServerPort = this.nfcPortResult.getText().toString();
        table.allowUpdate = this.sAllowUpdate.isChecked() ? "\u662f" : "\u5426";
        table.procedure = this.procedure;
        table.projectName = this.projectName;
        table.save();
        for (TableCertConfig config : this.list) {
            config.save();
        }
        this.exportHint.setTextColor(this.context.getResources().getColor(R.color.config_hint));
        this.exportHint.setVisibility(0);
        this.exportHint.setText(R.string.cert_creation_save_success);
        SharePreferencesUtil.saveExportState(this.context, true);
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                ConfigStep3Activity.this.checkoutPermission();
            }

            public void doCancel() {
                ConfigStep3Activity.this.finish();
            }
        });
    }

    @XdjaPermission(permissions={"android.permission.WRITE_EXTERNAL_STORAGE"})
    private void checkoutPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new ConfigStep3Activity$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ConfigStep3Activity.class.getDeclaredMethod("checkoutPermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void deleteDatabase() {
        File file = new File(path);
        if (file.exists()) {
            ModuleLog.e((Object)"db\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5c1d\u8bd5\u5220\u9664");
            boolean success = file.delete();
            ModuleLog.e((Object)(success ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u662f\u6ca1\u6709\u6388\u4e88\u5b58\u50a8\u6743\u9650"));
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

    static {
        ConfigStep3Activity.ajc$preClinit();
        path = Environment.getExternalStorageDirectory() + "/" + "certDataBase" + ".db";
    }

    static final /* synthetic */ void checkoutPermission_aroundBody0(ConfigStep3Activity ajc$this, JoinPoint joinPoint) {
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigStep3Activity.java", ConfigStep3Activity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkoutPermission", "com.xdja.safeclient.certcreation.activity.ConfigStep3Activity", "", "", "", "void"), 867);
    }

    class ConfigHandler
    extends Handler {
        ConfigHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 0) {
                ModuleToast.showNoRepeat(ConfigStep3Activity.this.context, R.string.cert_creation_connect_success);
            } else if (msg.what == 1) {
                ModuleToast.showNoRepeat(ConfigStep3Activity.this.context, R.string.cert_creation_connect_failed);
            } else if (msg.what == 2) {
                ConfigStep3Activity.this.connect.setText(R.string.cert_creation_config_test);
            } else if (msg.what == 3) {
                ConfigStep3Activity.this.connect.setText(R.string.cert_creation_config_connecting);
            } else if (msg.what == 4) {
                ConfigStep3Activity.this.connect.setClickable(false);
            } else if (msg.what == 5) {
                ConfigStep3Activity.this.connect.setClickable(true);
            } else if (msg.what == 6) {
                ConfigStep3Activity.this.showResult(true);
            } else if (msg.what == 7) {
                ConfigStep3Activity.this.showResult(false);
            }
        }
    }
}

