/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import com.xdja.safeclient.certcreation.bean.request.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.RegistIdCardInfo;
import com.xdja.safeclient.certcreation.bean.request.RegisterRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.RegisterResult;
import com.xdja.safeclient.certcreation.callback.HttpArrayResponseCallBack;
import com.xdja.safeclient.certcreation.event.DepartmentEvent;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.ProfessionDepartment;
import com.xdja.safeclient.certcreation.event.ProfessionJobTitle;
import com.xdja.safeclient.certcreation.event.ProfessionPerson;
import com.xdja.safeclient.certcreation.event.ProfessionRank;
import com.xdja.safeclient.certcreation.event.ProfessionType;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.DialogUtil;
import com.xdja.safeclient.certcreation.util.IntentUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OperatorUtil;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.ProChooseView;
import com.xdja.safeclient.certcreation.view.ProEditView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

@Route(path="/cert/profession", name="\u5b8c\u5584\u804c\u4e1a\u4fe1\u606f")
public class ProfessionActivity
extends BaseActivity
implements View.OnClickListener {
    private ProEditView pePoliceNum;
    private ProChooseView pcPerson;
    private ProChooseView pcType;
    private ProChooseView pcJobTitle;
    private ProChooseView pcDepartment;
    private ProChooseView pcRank;
    private ProEditView peRuwangPhone;
    private String cardNum;
    private CryptoDevType cardType;
    private String phoneNum;
    private String id;
    private int sex;
    private String name;
    private Button submit;
    private ArrayList<ProfessionBean> personList = new ArrayList();
    private ArrayList<ProfessionBean> typeList = new ArrayList();
    private ArrayList<ProfessionBean> rankList = new ArrayList();
    private ArrayList<ProfessionBean> jobTitleList = new ArrayList();
    private ArrayList<ProfessionDepartment> departmentList = new ArrayList();
    Context context;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setContentView(R.layout.activity_profession);
        super.onCreate(savedInstanceState);
        this.context = this;
        OttoUtil.register((Object)((Object)this));
        Intent intent = this.getIntent();
        this.cardNum = IntentUtil.getCardNum(intent);
        this.cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType((Context)this));
        this.phoneNum = IntentUtil.getPhone(intent);
        if (TextUtils.isEmpty((CharSequence)this.phoneNum)) {
            return;
        }
        this.id = IntentUtil.getID(intent);
        this.name = IntentUtil.getName(intent);
        this.sex = IntentUtil.getSex(intent);
        this.pePoliceNum = (ProEditView)this.findViewById(R.id.pe_police_num);
        this.pePoliceNum.setOnClickListener(this);
        this.pcPerson = (ProChooseView)this.findViewById(R.id.pc_person);
        this.pcPerson.setOnClickListener(this);
        this.pcType = (ProChooseView)this.findViewById(R.id.pc_type);
        this.pcType.setOnClickListener(this);
        this.pcJobTitle = (ProChooseView)this.findViewById(R.id.pc_job_title);
        this.pcJobTitle.setOnClickListener(this);
        this.pcDepartment = (ProChooseView)this.findViewById(R.id.pc_department);
        this.pcDepartment.setOnClickListener(this);
        this.pcRank = (ProChooseView)this.findViewById(R.id.pc_rank);
        this.pcRank.setOnClickListener(this);
        this.peRuwangPhone = (ProEditView)this.findViewById(R.id.pe_ruwang_phone);
        this.peRuwangPhone.setOnClickListener(this);
        this.submit = (Button)this.findViewById(R.id.submit);
        this.submit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ProfessionActivity.this.submit();
            }
        });
        this.initList();
    }

    private void initList() {
        this.service.getPersonType(this.cardNum, new HttpArrayResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptiopnFailure(Call call, IOException e) {
                ModuleLog.e((Object)"\u83b7\u53d6\u4eba\u5458\u7c7b\u578b\u5f02\u5e38");
                ProfessionActivity.this.showRequestError();
            }

            @Override
            public void onsuccessfullresponse(Call call, String response) {
                ProfessionActivity.this.personList = ProfessionActivity.this.parseArray(response, new ProfessionBean());
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e((Object)("\u83b7\u53d6\u4eba\u5458\u7c7b\u578b\u5931\u8d25\uff1a" + baseErrorResponse.toString()));
            }

            @Override
            public void dismissDialog() {
                ProfessionActivity.this.dismissLoading();
            }
        });
        try {
            this.service.getPoliceClass(this.cardNum, new HttpArrayResponseCallBack<CommonResponse>(){

                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }

                @Override
                public void onIoExceptiopnFailure(Call call, IOException e) {
                    ModuleLog.e((Object)"\u83b7\u53d6\u8b66\u79cd\u7c7b\u578b\u5f02\u5e38");
                    ProfessionActivity.this.showRequestError();
                }

                @Override
                public void onsuccessfullresponse(Call call, String response) {
                    ProfessionActivity.this.typeList = ProfessionActivity.this.parseArray(response, new ProfessionBean());
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.e((Object)"\u83b7\u53d6\u8b66\u79cd\u4fe1\u606f\u5931\u8d25");
                }

                @Override
                public void dismissDialog() {
                    ProfessionActivity.this.dismissLoading();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.service.getPosition(this.cardNum, new HttpArrayResponseCallBack<CommonResponse>(){

                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }

                @Override
                public void onIoExceptiopnFailure(Call call, IOException e) {
                    ModuleLog.e((Object)"\u83b7\u53d6\u804c\u52a1\u4fe1\u606f\u5f02\u5e38");
                    ProfessionActivity.this.showRequestError();
                }

                @Override
                public void onsuccessfullresponse(Call call, String response) {
                    ProfessionActivity.this.jobTitleList = ProfessionActivity.this.parseArray(response, new ProfessionBean());
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.e((Object)("\u83b7\u53d6\u804c\u52a1\u4fe1\u606f\u5931\u8d25\uff1a" + baseErrorResponse.toString()));
                }

                @Override
                public void dismissDialog() {
                    ProfessionActivity.this.dismissLoading();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.service.getLevel(this.cardNum, new HttpArrayResponseCallBack<CommonResponse>(){

                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }

                @Override
                public void onIoExceptiopnFailure(Call call, IOException e) {
                    ModuleLog.e((Object)"\u83b7\u53d6\u7ea7\u522b\u4fe1\u606f\u5f02\u5e38");
                    ProfessionActivity.this.showRequestError();
                }

                @Override
                public void onsuccessfullresponse(Call call, String response) {
                    ProfessionActivity.this.rankList = ProfessionActivity.this.parseArray(response, new ProfessionBean());
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.d((Object)("\u83b7\u53d6\u7ea7\u522b\u4fe1\u606f\u5931\u8d25\uff1a" + baseErrorResponse.toString()));
                }

                @Override
                public void dismissDialog() {
                    ProfessionActivity.this.dismissLoading();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.service.getDepartment(this.cardNum, new HttpArrayResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptiopnFailure(Call call, IOException e) {
                ModuleLog.e((Object)"\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5f02\u5e38");
                ProfessionActivity.this.showRequestError();
            }

            @Override
            public void onsuccessfullresponse(Call call, String response) {
                ProfessionActivity.this.departmentList = ProfessionActivity.this.parseArray(response, new ProfessionDepartment());
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e((Object)("\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\uff1a" + baseErrorResponse.toString()));
            }

            @Override
            public void dismissDialog() {
                ProfessionActivity.this.dismissLoading();
            }
        });
    }

    private void submit() {
        RegisterRequest request = this.buildRegisterRequest();
        if (request == null) {
            return;
        }
        this.showLoading();
        try {
            this.service.register(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }

                @Override
                public void onIoExceptionFailure(Call call, IOException e) {
                    ProfessionActivity.this.showRequestError();
                    ProfessionActivity.this.dismissLoading();
                }

                @Override
                public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                    ModuleLog.d((Object)commonResponse);
                    if (!commonResponse.equals("0")) {
                        ProfessionActivity.this.dismissLoading();
                    }
                    ProfessionActivity.this.handleResult(commonResponse);
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.e((Object)("\u6ce8\u518c\u5931\u8d25" + baseErrorResponse.toString()));
                    if (baseErrorResponse.getMessage().equals("user_register_failed")) {
                        ModuleToast.show(ProfessionActivity.this.context, R.string.cert_creation_register_failed);
                    }
                    ProfessionActivity.this.dismissLoading();
                }

                @Override
                public void dismissDialog() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RegisterRequest buildRegisterRequest() {
        boolean valid;
        Intent intent = this.getIntent();
        RegisterRequest request = new RegisterRequest();
        RegistIdCardInfo id2 = new RegistIdCardInfo();
        id2.setName(IntentUtil.getName(intent));
        id2.setSex(IntentUtil.getSex(intent));
        id2.setIdNum(IntentUtil.getID(intent));
        String alarmNo = this.pePoliceNum.getText();
        if (TextUtils.isEmpty((CharSequence)alarmNo)) {
            ModuleToast.show(this.context, R.string.cert_creation_not_null_police_num);
            return null;
        }
        id2.setAlarmNo(alarmNo);
        ProfessionBean person = (ProfessionBean)this.pcPerson.getTag();
        if (person == null) {
            ModuleToast.show(this.context, R.string.cert_creation_not_null_profession_person);
            return null;
        }
        id2.setPersonType(person.getCode());
        ProfessionBean type = (ProfessionBean)this.pcType.getTag();
        if (type == null) {
            ModuleToast.show(this.context, R.string.cert_creation_not_null_profession_type);
            return null;
        }
        id2.setPoliceClass(type.getCode());
        ProfessionBean jobTitle = (ProfessionBean)this.pcJobTitle.getTag();
        if (jobTitle == null) {
            ModuleToast.show(this.context, R.string.cert_creation_not_null_profession_job_title);
            return null;
        }
        id2.setPosition(jobTitle.getCode());
        ProfessionDepartment department = (ProfessionDepartment)this.pcDepartment.getTag();
        if (department == null) {
            ModuleToast.show(this.context, R.string.cert_creation_not_null_profession_department);
            return null;
        }
        id2.setDepartment(department.getCode());
        ProfessionBean rank = (ProfessionBean)this.pcRank.getTag();
        if (rank == null) {
            ModuleToast.show(this.context, R.string.cert_creation_not_null_profession_rank);
            return null;
        }
        id2.setLevel(rank.getCode());
        id2.setPersonState("1");
        id2.setFlag("0");
        request.setIdCardInfo(id2);
        ChipInfo chip = new ChipInfo();
        chip.setCommType(OperatorUtil.getType(this.context));
        chip.setPhone(this.phoneNum);
        request.setChipInfo(chip);
        String phone = this.peRuwangPhone.getText();
        boolean bl = valid = !TextUtils.isEmpty((CharSequence)phone);
        if (!valid) {
            ModuleToast.show(this.context, R.string.cert_creation_not_null_ruwang_phone);
            return null;
        }
        chip.setOfficePhone(phone);
        request.setBasic("");
        return request;
    }

    private ArrayList parseArray(String json, Object object) {
        JSONArray array = JSON.parseArray((String)json);
        if (TextUtils.isEmpty((CharSequence)json) || array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            list.add(JSON.parseObject((String)array.get(i).toString(), object.getClass()));
        }
        return list;
    }

    private List<ProfessionDepartment> findSubDepartment(List<ProfessionDepartment> original, String id2) {
        ArrayList<ProfessionDepartment> list = new ArrayList<ProfessionDepartment>();
        for (ProfessionDepartment department : original) {
            if (id2 == null) {
                if (department.getPId() != null) continue;
                list.add(department);
                continue;
            }
            String pid = department.getPId();
            if (!id2.equals(pid)) continue;
            list.add(department);
        }
        return list;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        OttoUtil.unRegister((Object)((Object)this));
    }

    @Subscribe
    public void handleProfessionType(ProfessionType type) {
        ProfessionBean value = this.typeList.get(type.getPosition());
        this.pcType.setRightText(value.getName());
        this.pcType.setTag(value);
    }

    @Subscribe
    public void handleProfessionPerson(ProfessionPerson person) {
        ProfessionBean value = this.personList.get(person.getPosition());
        this.pcPerson.setRightText(value.getName());
        this.pcPerson.setTag(value);
    }

    @Subscribe
    public void handleProfessionRank(ProfessionRank rank) {
        ProfessionBean value = this.rankList.get(rank.getPosition());
        this.pcRank.setRightText(value.getName());
        this.pcRank.setTag(value);
    }

    @Subscribe
    public void handleJobTitle(ProfessionJobTitle jobTitle) {
        ProfessionBean value = this.jobTitleList.get(jobTitle.getPosition());
        this.pcJobTitle.setRightText(value.getName());
        this.pcJobTitle.setTag(value);
    }

    @Subscribe
    public void handleDepartment(DepartmentEvent event) {
        ProfessionDepartment current;
        List<ProfessionDepartment> all = event.getRest();
        List<ProfessionDepartment> rest = this.findSubDepartment(all, (current = event.getCurrent()).getId());
        if (rest.size() != 0) {
            DialogUtil.popSpinnerList((Context)this, all, rest);
        } else {
            this.pcDepartment.setRightText(current.getName());
            this.pcDepartment.setTag(current);
        }
    }

    private void handleResult(CommonResponse response) {
        String result = response.getResult();
        if (!result.equals("0")) {
            ModuleToast.show(this.context, new RegisterResult().getErrText(result));
        }
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.pc_person) {
            DialogUtil.popSpinnerList((Context)this, this.personList, 0);
        } else if (id2 == R.id.pc_type) {
            DialogUtil.popSpinnerList((Context)this, this.typeList, 2);
        } else if (id2 == R.id.pc_rank) {
            DialogUtil.popSpinnerList((Context)this, this.rankList, 1);
        } else if (id2 == R.id.pc_job_title) {
            DialogUtil.popSpinnerList((Context)this, this.jobTitleList, 3);
        } else if (id2 == R.id.pc_department) {
            DialogUtil.popSpinnerList((Context)this, this.departmentList, this.findSubDepartment(this.departmentList, null));
        }
    }
}

