/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.Unregister;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.view.CertItemView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RecyclerViewAdapter
extends RecyclerView.Adapter<ViewHold>
implements Unregister,
View.OnClickListener {
    private Context context;
    private List<CertItemBean> certItemBeans = new ArrayList<CertItemBean>();
    private ViewHold hold;
    public String object;
    private boolean isRefresh = true;
    private HashMap<String, Integer> cards = new HashMap();

    public RecyclerViewAdapter(Context context, String object) {
        this.context = context;
        this.object = object;
    }

    public ViewHold onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_list_layout, null);
        this.hold = new ViewHold(view);
        return this.hold;
    }

    public void onBindViewHolder(ViewHold holder, int position) {
        boolean isFirst;
        String cardType = this.certItemBeans.get(position).getCertConfig().getCardType();
        int current = this.certItemBeans.get(position).getCertConfig().getContainerNum();
        if (this.cards.get(cardType) == null) {
            isFirst = true;
            this.cards.put(cardType, current);
        } else {
            int min = this.cards.get(cardType);
            boolean bl = isFirst = current == min;
            if (current < min) {
                this.cards.put(cardType, current);
            }
        }
        holder.certItemView.setData(this.context, this, this.certItemBeans.get(position), this.object, isFirst);
        holder.certItemView.setTag(position);
        holder.certItemView.setOnClickListener(this);
    }

    public int getItemCount() {
        return this.certItemBeans == null ? 0 : this.certItemBeans.size();
    }

    @Override
    public void destroy() {
        if (this.hold != null) {
            this.hold.destroy();
        }
    }

    public void onClick(View view) {
        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            return;
        }
        CertItemView certItemView = (CertItemView)view;
        if (certItemView.isCertOK()) {
            this.setIsRefresh(false);
            ARouter.getInstance().build("/cert/cert_detail_info").withSerializable("chipBean", (Serializable)certItemView.getChipBean()).withInt("containerNum", certItemView.getContainerNum()).withString("certType", certItemView.getCertType()).withBoolean("inUse", certItemView.inUse()).withBoolean("allowApplyCert", certItemView.getAllowApplyCert()).navigation(this.context);
        }
    }

    public void setIsRefresh(boolean isRefresh) {
        this.isRefresh = isRefresh;
    }

    public boolean getIsRefresh() {
        return this.isRefresh;
    }

    public void addAll(List<CertItemBean> certItemBeans) {
        if (certItemBeans == null || certItemBeans.size() == 0) {
            return;
        }
        this.certItemBeans.clear();
        this.certItemBeans.addAll(certItemBeans);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.certItemBeans.clear();
        this.cards.clear();
        this.notifyDataSetChanged();
    }

    public void refresh() {
        this.cards.clear();
        this.notifyDataSetChanged();
    }

    public String getFirstCard() {
        return this.certItemBeans.get(0).getCertConfig().getCardType();
    }

    public static class ViewHold
    extends RecyclerView.ViewHolder
    implements Unregister {
        CertItemView certItemView;

        public ViewHold(View itemView) {
            super(itemView);
            this.certItemView = (CertItemView)itemView.findViewById(R.id.cert_item_view);
        }

        @Override
        public void destroy() {
            this.certItemView.onDestory();
        }
    }
}

