/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import android.text.TextUtils;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.devapi.SM2Pubkey;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.util.FidUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;

public class PKCS10ForSM2Utils
extends PKCS10Utils {
    public static PKCS10ForSM2Utils pkcs10ForSM2Utils = new PKCS10ForSM2Utils();

    public static PKCS10ForSM2Utils getInstance() {
        if (pkcs10ForSM2Utils == null) {
            pkcs10ForSM2Utils = new PKCS10ForSM2Utils();
        }
        return pkcs10ForSM2Utils;
    }

    @Override
    public String getP10RequestBC(CryptoDevType type, int containerNum, String dn, boolean isApplyCert) {
        int keyResult;
        ModuleLog.e((Object)"PKCS10ForSM2Utils getP10RequestBC");
        if (TextUtils.isEmpty((CharSequence)dn)) {
            return "";
        }
        if (isApplyCert && (keyResult = this.generateSM2Keys(type, containerNum)) != 0 && keyResult != -1) {
            return "errorCode" + CryptoDevManager.getInstance().getErrorText(keyResult);
        }
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return "";
        }
        byte[] pub = this.SM2PubKey2PubKey(type, containerNum);
        ASN1ObjectIdentifier eccOID = new ASN1ObjectIdentifier("1.2.840.10045.2.1");
        ASN1ObjectIdentifier sm2OID = new ASN1ObjectIdentifier("1.2.156.10197.1.301");
        SubjectPublicKeyInfo spi = new SubjectPublicKeyInfo(new AlgorithmIdentifier(eccOID, (ASN1Encodable)sm2OID), pub);
        X500Name x500Name = new X500Name(dn);
        CertificationRequestInfo cf1 = new CertificationRequestInfo(x500Name, spi, null);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
        try {
            derOutStream.writeObject((ASN1Encodable)cf1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] certInfoBytes = outStream.toByteArray();
        byte[] signData = new byte[64];
        int[] signDataLen = new int[1];
        byte[][] keyPair = FidUtil.getKeyPairFid(type, containerNum);
        byte[] pubFid = keyPair[0];
        byte[] priFid = keyPair[1];
        int encodeRequestInfo = cryptoInstance.SM2Sign(pubFid, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        if (encodeRequestInfo != 0) {
            return null;
        }
        DERBitString dbs = new DERBitString(signData);
        AlgorithmIdentifier signIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3WITHSM2");
        CertificationRequest cr = new CertificationRequest(cf1, signIdentifier, dbs);
        PKCS10CertificationRequest request = new PKCS10CertificationRequest(cr);
        try {
            byte[] buffer = request.getEncoded();
            String p10 = new String(Base64.encode((byte[])buffer));
            return p10;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private int generateSM2Keys(CryptoDevType type, int containerNum) {
        ModuleLog.e((Object)"PKCS10ForSM2Utils generateSM2Keys");
        int genSm2KeysPairResult = -1;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return genSm2KeysPairResult;
        }
        AppConfig module = AppConfig.getInstance();
        int pinResult = DeviceWrapper.verifyPin(type, containerNum, "");
        if (pinResult != 0) {
            return pinResult;
        }
        genSm2KeysPairResult = this.genSM2KeyPair(cryptoInstance, type, containerNum);
        if (genSm2KeysPairResult == 2030 || genSm2KeysPairResult == 2041) {
            if (cryptoInstance.createContainer(module.getRole(type, containerNum), module.getDefaultConfig().getPin(), containerNum, "") == 0) {
                genSm2KeysPairResult = this.genSM2KeyPair(cryptoInstance, type, containerNum);
            } else {
                return genSm2KeysPairResult;
            }
        }
        cryptoInstance.close();
        return genSm2KeysPairResult;
    }

    private int genSM2KeyPair(CryptoInstance cryptoInstance, CryptoDevType type, int containerNum) {
        ModuleLog.e((Object)"PKCS10ForSM2Utils genSM2KeyPair");
        int genSm2KeysPairResult = AppConfig.getInstance().getCertConfig().getCertRule(type, containerNum).equals("\u5355\u8bc1") ? (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AppConfig.getInstance().getCertConfig().getCertType(type, containerNum)) ? cryptoInstance.genSignSM2KeyPair(containerNum) : cryptoInstance.genExchangeSM2KeyPair(containerNum)) : cryptoInstance.genSignSM2KeyPair(containerNum);
        return genSm2KeysPairResult;
    }

    private byte[] SM2PubKey2PubKey(CryptoDevType type, int containerNum) {
        SM2Pubkey pubKey = new SM2Pubkey();
        byte[][] pubFid = FidUtil.getKeyPairFid(type, containerNum);
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = cryptoInstance.readSM2Pubkey(pubFid[0], pubKey);
        if (result != 0) {
            return null;
        }
        byte[] pub = new byte[65];
        pub[0] = 4;
        System.arraycopy(pubKey.getX(), 0, pub, 1, pubKey.getX().length);
        System.arraycopy(pubKey.getY(), 0, pub, pubKey.getX().length + 1, pubKey.getY().length);
        return pub;
    }

    private void checkP10(CryptoDevType type, String p10) {
        if (p10 == null || p10.equals("")) {
            return;
        }
        try {
            byte[] bs = Base64.decode((String)p10);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(bs);
            CertificationRequest request = re.toASN1Structure();
            CertificationRequestInfo cerReqInfo = request.getCertificationRequestInfo();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            try {
                derOutStream.writeObject((ASN1Encodable)cerReqInfo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] certInfoBytes = outStream.toByteArray();
            byte[] signature = re.getSignature();
            SubjectPublicKeyInfo info = re.getSubjectPublicKeyInfo();
            DERBitString keyInfo = info.getPublicKeyData();
            byte[] bytes = keyInfo.getBytes();
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            System.arraycopy(bytes, 1, x, 0, x.length);
            System.arraycopy(bytes, x.length + 1, y, 0, y.length);
            SM2Pubkey pubkey = new SM2Pubkey();
            pubkey.setX(x);
            pubkey.setY(y);
            byte[] pubFid = new byte[]{0, 0};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.SM2SignVerify(pubFid, 1, pubkey, certInfoBytes, certInfoBytes.length, signature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

