/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.view;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.aircert.util.WeakReferenceHandler;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.util.AnimUtil;

public class LoadingDialog
extends Dialog {
    private Context context;
    private TextView tv_content;
    private ImageView progressBar;
    int contentResID;
    private String content;
    private MyHandler myHandler = new MyHandler(this);
    private static final int MSG_DISMISS = 0;

    public LoadingDialog(Context context) {
        super(context, R.style.Theme_AppCompat_Dialog);
        this.context = context;
    }

    public LoadingDialog(Context context, @StringRes int contentResID) {
        super(context, R.style.Theme_AppCompat_Dialog);
        this.context = context;
        this.contentResID = contentResID;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.loading_dialog);
        this.tv_content = (TextView)this.findViewById(R.id.tv_content);
        this.progressBar = (ImageView)this.findViewById(R.id.progressBar2);
        AnimUtil.rotate(this.context, (View)this.progressBar);
        this.setContent(this.content);
        if (this.contentResID != 0) {
            this.tv_content.setText(this.contentResID);
        }
        this.setCanceledOnTouchOutside(false);
    }

    public void setContent(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        this.content = content;
        if (this.tv_content == null) {
            return;
        }
        this.tv_content.setText((CharSequence)this.content);
    }

    public void setContent(@StringRes int strRes) {
        if (strRes == 0) {
            return;
        }
        this.content = this.getContext().getString(strRes);
        if (this.tv_content == null) {
            return;
        }
        this.tv_content.setText((CharSequence)this.content);
    }

    public void showLoading() {
        if (this.isShowing()) {
            return;
        }
        this.show();
    }

    public void dismissLoading() {
        if (this.isShowing()) {
            this.dismiss();
        }
    }

    static class MyHandler
    extends WeakReferenceHandler<LoadingDialog> {
        public MyHandler(LoadingDialog reference) {
            super((Object)reference);
        }

        protected void handleMessage(LoadingDialog reference, Message msg) {
            if (reference != null && reference.isShowing()) {
                try {
                    reference.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

