/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.baidu.aip.fp.utils.FileUtil;
import com.baidu.ocr.sdk.OCR;
import com.baidu.ocr.sdk.OnResultListener;
import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.model.AccessToken;
import com.baidu.ocr.sdk.model.IDCardParams;
import com.baidu.ocr.sdk.model.IDCardResult;
import com.baidu.ocr.ui.camera.CameraActivity;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.a3rdplugin.demo.activity.ANRONGOCRActivity;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.a3rdplugin.demo.event.IDCardTailResult;
import com.xdja.a3rdplugin.demo.event.OCREvent;
import com.xdja.a3rdplugin.demo.event.XDJAIDTailResult;
import com.xdja.a3rdplugin.demo.ocr.XDJAOCR;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.BasicInfoActivity;
import com.xdja.safeclient.certcreation.event.ChooseBindwayEvent;
import com.xdja.safeclient.certcreation.event.ClearIDEvent;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.FinishChooseEvent;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.DialogUtil;
import com.xdja.safeclient.certcreation.util.IntentUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import java.io.File;
import ocr.activity.AnrongOCRIDActivity;
import ocr.activity.XDJANFCActivity;
import ocr.activity.XDJAOCRIDCardActivity;
import ocr.bean.IDCardInfo;

@Route(name="\u9009\u62e9\u8eab\u4efd\u8ba4\u8bc1\u65b9\u5f0f", path="/cert/choose_bind_way")
public class ChooseBindWayActivity
extends BaseActivity {
    private String name;
    private String sex;
    private String birthDay;
    private String nation;
    private String address;
    private String idNum;
    private String procedure = AppConfig.getInstance().getServerSettingConfig().getProcedure();
    private String ocrCompany = AppConfig.getInstance().getServerSettingConfig().getOcrCompany();
    @Autowired(name="containerNum")
    public int containerNum;
    private CryptoDevType cardType;
    private String cardNo;
    private String phone;
    @Autowired(name="faceImg")
    public String faceImg = "";
    private IDCardInfo id = new IDCardInfo();

    protected boolean hasActionBar() {
        return true;
    }

    protected int getToolbarType() {
        return 0;
    }

    protected int getTitleRes() {
        return R.string.cert_creation_choose_way;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.choose_idenfity_way);
        ARouter.getInstance().inject((Object)this);
        this.cardType = IntentUtil.getCardType(this.getIntent());
        this.cardNo = IntentUtil.getCardNum(this.getIntent());
        this.phone = IntentUtil.getPhone(this.getIntent());
        this.onBindView();
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0NFC\uff09")) {
            this.gotoBasicInfoActivity();
        }
        this.init();
    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (((Object)((Object)this)).getClass().getName().equals(activity.getTag())) {
            this.finish();
        }
    }

    private void init() {
        RelativeLayout iv_nfc = (RelativeLayout)this.findViewById(R.id.layout_nfc);
        RelativeLayout iv_ocr = (RelativeLayout)this.findViewById(R.id.layout_ocr);
        RelativeLayout iv_manual_input = (RelativeLayout)this.findViewById(R.id.layout_manual_input);
        iv_nfc.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoNFC();
            }
        });
        iv_ocr.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoOCR();
            }
        });
        iv_manual_input.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBindWayActivity.this.gotoBasicInfoActivity();
            }
        });
        iv_ocr.setVisibility(8);
        iv_nfc.setVisibility(8);
        iv_manual_input.setVisibility(8);
        if (!this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
            iv_ocr.setVisibility(0);
        }
        if (!this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0NFC\uff09")) {
            iv_nfc.setVisibility(0);
        }
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
            iv_manual_input.setVisibility(0);
        }
        if (this.ocrCompany.equals("\u767e\u5ea6")) {
            this.initBaiduOCRSDK();
        }
    }

    private void gotoBasicInfoActivity() {
        Intent intent = new Intent((Context)this, BasicInfoActivity.class);
        intent = IntentUtil.putInfo(intent, this.cardType, this.cardNo);
        intent = IntentUtil.putPhone(intent, this.phone);
        Bundle bundle = new Bundle();
        bundle.putString("faceImg", this.faceImg);
        bundle.putInt("containerNum", this.containerNum);
        intent.putExtras(bundle);
        this.startActivity(intent);
        this.finish();
    }

    private void gotoOCR() {
        this.doIdentify(false);
    }

    private void onBindView() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null && bundle.containsKey("faceImg")) {
            this.faceImg = bundle.getString("faceImg");
        }
    }

    private void gotoNFC() {
        this.doIdentify(true);
    }

    @SuppressLint(value={"StringFormatMatches"})
    private void doIdentify(boolean isNFC) {
        if (isNFC) {
            String nfcCompany;
            switch (nfcCompany = AppConfig.getInstance().getServerSettingConfig().getNfcCompany()) {
                case "\u4fe1\u5927\u6377\u5b89": {
                    Intent intentXdja = new Intent((Context)this, XDJANFCActivity.class);
                    Bundle othersXdja = new Bundle();
                    othersXdja.putString("faceImg", this.faceImg);
                    othersXdja.putInt("containerNum", this.containerNum);
                    intentXdja.putExtras(othersXdja);
                    this.startActivity(intentXdja);
                    break;
                }
                case "\u4ebf\u6570": {
                    Intent intent = new Intent("com.xdja.yishunfc");
                    Bundle bundle = new Bundle();
                    bundle.putString("faceImg", this.faceImg);
                    intent.putExtras(bundle);
                    this.sendBroadcast(intent);
                }
            }
        } else {
            String ocrCompany;
            switch (ocrCompany = AppConfig.getInstance().getServerSettingConfig().getOcrCompany()) {
                case "\u5b89\u8363": {
                    if (!ANRONGOCRActivity.isApplicationInstalled((Context)this.context, (String)"com.anrongtec.ocr")) {
                        this.showAnrongDialog(this.getString(R.string.not_install_anrong_ocr));
                        return;
                    }
                    if (!ANRONGOCRActivity.isVersionOK((Context)this.context)) {
                        String targetVersion = "1.8";
                        String currentVersion = ANRONGOCRActivity.getVersion((Context)this.context, (String)"com.anrongtec.ocr");
                        this.showAnrongDialog(String.format(this.getString(R.string.wrong_ocr_version_1), targetVersion, currentVersion));
                        return;
                    }
                    OCRCompany.ANRONG((Context)this, (int)1);
                    break;
                }
                case "\u4fe1\u5927\u6377\u5b89": {
                    if (XDJAOCR.isInstall((Context)this.context)) {
                        OCRCompany.XDJA((Context)this, (int)0);
                        break;
                    }
                    XDJAOCR.copyXDJAOCRAPK((Context)this.context);
                    break;
                }
                case "\u4e91\u4ece": {
                    ARouter.getInstance().build("/cert/yuncong_ocr").withString("faceImg", this.faceImg).withInt("containerNum", this.containerNum).navigation(this.context);
                    break;
                }
                case "\u767e\u5ea6": {
                    this.baiduOCR();
                }
            }
        }
    }

    @Subscribe
    public void handleOCREvent(OCREvent event) {
        if (event instanceof XDJAOCR) {
            XDJAOCR.install((Context)this, (boolean)true);
        }
    }

    private void baiduOCR() {
        AccessToken accessToken = OCR.getInstance().getAccessToken();
        if (accessToken == null || TextUtils.isEmpty((CharSequence)accessToken.getAccessToken())) {
            this.initBaiduOCRSDK();
            Toast.makeText((Context)this, (CharSequence)"OCR token \u6b63\u5728\u62c9\u53d6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 ", (int)0).show();
            return;
        }
        Intent intent = new Intent((Context)this, CameraActivity.class);
        intent.putExtra("outputFilePath", FileUtil.getSaveFile((Context)this.getApplication()).getAbsolutePath());
        intent.putExtra("contentType", "IDCardFront");
        intent.putExtra("nativeToken", OCR.getInstance().getLicense());
        intent.putExtra("nativeEnable", true);
        this.startActivityForResult(intent, 102);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 102 && resultCode == -1 && data != null) {
            String contentType = data.getStringExtra("contentType");
            String filePath = FileUtil.getSaveFile((Context)this.getApplicationContext()).getAbsolutePath();
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                if ("IDCardFront".equals(contentType)) {
                    this.recIDCard("front", filePath);
                } else if ("IDCardBack".equals(contentType)) {
                    this.recIDCard("back", filePath);
                }
            }
        }
    }

    private void recIDCard(final String idCardSide, final String filePath) {
        IDCardParams param = new IDCardParams();
        param.setImageFile(new File(filePath));
        param.setIdCardSide(idCardSide);
        param.setDetectDirection(true);
        OCR.getInstance().recognizeIDCard(param, (OnResultListener)new OnResultListener<IDCardResult>(){

            public void onResult(IDCardResult result) {
                if (result != null) {
                    Log.d((String)"idcard", (String)filePath);
                    File file = new File(filePath);
                    file.delete();
                    if (idCardSide.equals("front")) {
                        ChooseBindWayActivity.this.name = result.getName().getWords();
                        ChooseBindWayActivity.this.sex = result.getGender().getWords();
                        ChooseBindWayActivity.this.birthDay = result.getBirthday().getWords();
                        ChooseBindWayActivity.this.nation = result.getEthnic().getWords();
                        ChooseBindWayActivity.this.address = result.getAddress().getWords();
                        ChooseBindWayActivity.this.idNum = result.getIdNumber().getWords();
                        ChooseBindWayActivity.this.toBackSide();
                    } else if (idCardSide.equals("back")) {
                        Intent intent = new Intent();
                        intent.putExtra("name", ChooseBindWayActivity.this.name);
                        intent.putExtra("sex", ChooseBindWayActivity.this.sex);
                        intent.putExtra("birthDay", ChooseBindWayActivity.this.birthDay);
                        intent.putExtra("nation", ChooseBindWayActivity.this.nation);
                        intent.putExtra("address", ChooseBindWayActivity.this.address);
                        intent.putExtra("idNum", ChooseBindWayActivity.this.idNum);
                        intent.putExtra("issue", result.getIssueAuthority().getWords());
                        intent.putExtra("validDate", result.getExpiryDate().getWords());
                        intent.setAction("com.xdja.baidu_ocr");
                        intent.putExtra("filePath", filePath);
                        Bundle other = new Bundle();
                        other.putString("faceImg", ChooseBindWayActivity.this.faceImg);
                        intent.putExtras(other);
                        ChooseBindWayActivity.this.sendBroadcast(intent);
                    }
                }
            }

            public void onError(OCRError error) {
                if (error.getErrorCode() == 283504) {
                    ChooseBindWayActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ModuleToast.show(ChooseBindWayActivity.this.context, R.string.cert_creation_network_err);
                        }
                    });
                }
            }
        });
    }

    private void toBackSide() {
        AccessToken accessToken = OCR.getInstance().getAccessToken();
        if (accessToken == null || TextUtils.isEmpty((CharSequence)accessToken.getAccessToken())) {
            this.initBaiduOCRSDK();
            Toast.makeText((Context)this, (CharSequence)"OCR token \u6b63\u5728\u62c9\u53d6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 ", (int)0).show();
            return;
        }
        Intent intent = new Intent((Context)this, CameraActivity.class);
        intent.putExtra("outputFilePath", FileUtil.getSaveFile((Context)this.getApplication()).getAbsolutePath());
        intent.putExtra("contentType", "IDCardBack");
        intent.putExtra("nativeToken", OCR.getInstance().getLicense());
        intent.putExtra("nativeEnable", true);
        this.startActivityForResult(intent, 102);
    }

    private void initBaiduOCRSDK() {
        OCR.getInstance().initAccessToken((OnResultListener)new OnResultListener<AccessToken>(){

            public void onResult(AccessToken result) {
                String token = result.getAccessToken();
            }

            public void onError(OCRError error) {
                if (error.getErrorCode() == 283504) {
                    ChooseBindWayActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ModuleToast.show(ChooseBindWayActivity.this.context, R.string.cert_creation_network_err);
                        }
                    });
                }
            }
        }, this.getApplicationContext());
    }

    private void showAnrongDialog(String text) {
        DialogUtil.install((Context)this, text, new DialogUtil.DialogInterface(){

            @Override
            public void onSuccess(Object ... objects) {
                ANRONGOCRActivity.goToAppStore((Context)ChooseBindWayActivity.this.context);
            }
        });
    }

    public static Intent buildIntent(Context context, int containerNum, String faceImg) {
        Intent intent = new Intent(context, ChooseBindWayActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("faceImg", faceImg);
        bundle.putInt("containerNum", containerNum);
        intent.putExtras(bundle);
        return intent;
    }

    @Override
    protected boolean setDialogCancelable() {
        return false;
    }

    @Subscribe
    public void handleIDCardHeadResult(IDCardHeadResult result) {
        if (this.id == null) {
            this.id = new IDCardInfo();
        }
        this.id.setName(result.getXm());
        this.id.setSex(result.getXb().equals("\u7537") ? 1 : 2);
        this.id.setBirthDate(result.getCsrq());
        this.id.setNation(result.getMz());
        this.id.setAddr(result.getCsdz());
        this.id.setIdNum(result.getSfzh());
        this.id.setPhoto("");
        this.next();
    }

    @Subscribe
    public void handleIDCardTailResult(IDCardTailResult result) {
        this.id.setIssueOffice(result.getDepartment());
        this.id.setValidDate(result.getValidDate());
        this.next();
    }

    @Subscribe
    public void handleXDJAIDTailResult(XDJAIDTailResult result) {
        this.id.setIssueOffice(result.getQfjg());
        String value = result.getYxqx();
        value = XDJAOCR.formatValidDate((String)value);
        if (this.id == null) {
            this.id = new IDCardInfo();
        }
        this.id.setValidDate(value);
        if (!TextUtils.isEmpty((CharSequence)this.id.getName())) {
            this.next();
        } else {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    OCRCompany.XDJA((Context)ChooseBindWayActivity.this, (int)0);
                }
            }, 3000L);
        }
    }

    @Subscribe
    public void handleFinishChooseEvent(FinishChooseEvent event) {
        this.finish();
    }

    private void scan(final int side) {
        this.showLoading();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ChooseBindWayActivity.this.dismissLoading();
                OCRCompany.ANRONG((Context)ChooseBindWayActivity.this.context, (int)side);
            }
        }, 2000L);
    }

    @Override
    public void next() {
        if (!TextUtils.isEmpty((CharSequence)this.faceImg) && this.id != null) {
            if (TextUtils.isEmpty((CharSequence)this.id.getName()) && this.ocrCompany.equals("\u5b89\u8363")) {
                this.scan(1);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.id.getIssueOffice())) {
                if (this.ocrCompany.equals("\u5b89\u8363")) {
                    this.scan(2);
                } else if (this.ocrCompany.equals("\u4fe1\u5927\u6377\u5b89")) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            OCRCompany.XDJA((Context)ChooseBindWayActivity.this, (int)1);
                        }
                    }, 3000L);
                }
                return;
            }
            if (this.ocrCompany.equals("\u5b89\u8363")) {
                Bundle others = new Bundle();
                others.putString("faceImg", this.faceImg);
                others.putParcelable("identify_info", (Parcelable)this.id);
                Intent intent = new Intent((Context)this, AnrongOCRIDActivity.class);
                intent.putExtras(others);
                this.startActivity(intent);
            } else if (this.ocrCompany.equals("\u4fe1\u5927\u6377\u5b89")) {
                Bundle others = new Bundle();
                others.putString("faceImg", this.faceImg);
                others.putParcelable("identify_info", (Parcelable)this.id);
                Intent intent = new Intent((Context)this, XDJAOCRIDCardActivity.class);
                others.putInt("containerNum", this.containerNum);
                intent.putExtras(others);
                this.startActivity(intent);
            }
        }
    }

    @Subscribe
    public void handleClearID(ClearIDEvent event) {
        this.id = null;
        this.id = new IDCardInfo();
    }

    protected boolean isOCRActivity() {
        return true;
    }

    @Subscribe
    public void handleChooseBindway(ChooseBindwayEvent event) {
        this.finish();
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }
}

