package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.Util;

import org.joor.Reflect;


/**
 * Created by jff on 2018/7/7.
 */
@Route(path = ActivityPath.ACTIVITY_SETTING, name = ActivityPath.NAME_SETTING)
public class AboutActivity extends BaseActivity {


    private LinearLayout update;

    private Context context;

    private TextView version;

    private RelativeLayout about;

    int count = 0;

    boolean exist;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_about);

        context = this;


        exist = Util.assetFileIsExist(context, "certDataBase.db");

        about = (RelativeLayout) findViewById(R.id.about);

        about.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                // TODO: 2019/6/11 0011 测试包注释掉这三行，正式版本取消注释
                if (exist) {
                    return;
                }

                count++;
                if (count % 5 == 0) {


                }
            }
        });

        version = (TextView) findViewById(R.id.app_ver);
        PackageManager packageManager = getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(getPackageName(), 0);
            version.setText(getResources().getString(R.string.cert_creation_ver_about) + packageInfo.versionName);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }


        update = (LinearLayout) findViewById(R.id.update);
        update.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                {
//                    使用反射前

//                    XDJAUpdateExecutor.getInstance().onCheckIsNeedUpdate(context);
                }

//                    使用反射后
                if (BuildConfig.compileUpdate) {
                    Reflect.on("com.xdja.updatelibrary.XDJAUpdateExecutor")
                            .call("getInstance")
                            .call("onCheckIsNeedUpdate", context);
                }


            }
        });

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }


}
