package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.BusProvider;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CertInfoUpdateRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.request.UpdateInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.config.AllowUpdate;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.RevokeResultEvent;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.Util;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;

import okhttp3.Call;

/**
 * Created by jff on 2018/6/27.
 */

@Route(name = ActivityPath.NAME_CERT_DETAIL_INFO, path = ActivityPath.ACTIVITY_CERT_DETAIL_INFO)
public class CertDetailInfoActivity extends BaseActivity {

    private TextView sn;
    private TextView ver;
    private TextView signAlg;
    private TextView user;
    private TextView issuer;
    private TextView notBefore;
    private TextView notAfter;
    private ImageView ivInUse;

    @Autowired(name = "chipBean")
    public ChipBean bean;

    private CertDetailInfo certDetailInfo;

    @Autowired(name = "inUse")
    public boolean inUse;

    private FrameLayout certStatus;
    private CertService certService = new CertService();
    private Context context;
    private CryptoDevType chipBeanType;
    private String cardID;

    @Autowired(name = ActivityParam.CONTAINER_NUM)
    public int containerNum;

    @Autowired(name = ActivityParam.CERT_TYPE)
    public String certType;

    private PinDialog pinDialog;

    private final int REVOKE_CERT = 1;
    private final int DELETE_CERT = 2;
    private final int UPDATE_CERT_INFO = 3;

    private int operate_type = -1; //操作类型  1 撤销证书；2 删除证书 ；3 更新证书 ；-1 默认值，表示不进行任何操作

    private boolean isShowUpdate = true;//是否展示更新弹框

    private static Handler myHandler = new Handler();

    @Autowired(name = ActivityParam.ALLOW_APPLY_CERT)
    public boolean allowApplyCert;

    /**
     * 弹窗提示用户用户开启权限
     */
    private BindIdentifyDialog bindIdentifyDialog = null;

    private void showInvalidPermissionDialog() {

        bindIdentifyDialog = new BindIdentifyDialog(context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(R.string.cert_creation_cert_have_expired);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_close);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_update);


        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {

                bindIdentifyDialog.dismiss();

                //更新证书
                operate_type = UPDATE_CERT_INFO;
                showPinDialog();


            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.dismiss();
            }
        });

    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_cert_detail);
        context = this;

        initView();

        bean = (ChipBean) getIntent().getSerializableExtra("chipBean");
        chipBeanType = CryptoDevTypeUtil.formatType(bean.getType());
        certDetailInfo = bean.getCertBean();
        cardID = DeviceWrapper.getInstance().getCardID(chipBeanType);

        showCertState();
        showData(this.certDetailInfo);

    }

    Button revoke;
    Button revoke_full;
    Button delete;
    Button update;
    Button refresh;

    RelativeLayout bottomButton;

    private void initView() {
        certStatus = (FrameLayout) findViewById(R.id.cert_detail_status);
        sn = (TextView) findViewById(R.id.sn_text);
        ver = (TextView) findViewById(R.id.ver_text);
        signAlg = (TextView) findViewById(R.id.signAlg_text);
        user = (TextView) findViewById(R.id.user_text);
        issuer = (TextView) findViewById(R.id.issuer_text);
        notBefore = (TextView) findViewById(R.id.indate_start);
        notAfter = (TextView) findViewById(R.id.indate_end);


        revoke = (Button) findViewById(R.id.revoked_btn);
        delete = (Button) findViewById(R.id.delete_cert_btn);
        update = (Button) findViewById(R.id.update_cert_btn);
        refresh = (Button) findViewById(R.id.refresh_cert_btn);
        revoke_full = (Button) findViewById(R.id.revoked_full_btn);

        bottomButton = (RelativeLayout) findViewById(R.id.bottom_button);
        ivInUse = (ImageView) findViewById(R.id.in_use);
        ivInUse.setVisibility(inUse ? View.VISIBLE : View.GONE);
    }

    private void showBtn(Button btn) {
        revoke.setVisibility(View.GONE);
        delete.setVisibility(View.GONE);
        update.setVisibility(View.GONE);
        refresh.setVisibility(View.GONE);
        revoke_full.setVisibility(View.GONE);

        boolean allowUpdate = AppConfig.getInstance().getServerSettingConfig().getAllowUpdate()
                .equals(AllowUpdate.AYE);

        // 如果该容器只具备展示证书的权限（不能发证）
        // 那么同样不能进行撤销、删除、更新证书等操作
        if (!allowApplyCert) {
            bottomButton.setVisibility(View.GONE);
        }

        if (btn == revoke) {
            if (allowUpdate) {
                revoke.setVisibility(View.VISIBLE);
            } else {
                revoke_full.setVisibility(View.VISIBLE);
            }
        }
        if (btn == delete) {
            delete.setVisibility(View.VISIBLE);
        }
        if (btn == update) {
            update.setVisibility(View.VISIBLE);
        }
        if (btn == refresh) {
            refresh.setVisibility(View.VISIBLE);
        }

    }


    private void showData(CertDetailInfo certDetailInfo) {
        sn.setText(certDetailInfo.sn);
        ver.setText("" + certDetailInfo.ver);
        signAlg.setText(certDetailInfo.alg);

        String userStr = certDetailInfo.subjectCn;
        String userContent = userStr.replaceAll(",", "\n");
        user.setText(userContent);

        String issuerStr = certDetailInfo.issuerCn;
        String issuerContent = issuerStr.replaceAll(",", "\n");
        issuer.setText(issuerContent);

        notBefore.setText(certDetailInfo.getNotBefore());
        notAfter.setText(certDetailInfo.getNotAfter());
    }

    private void showCertNormal() {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_normal, null);
        certStatus.removeAllViews();
        certStatus.addView(view);

        if (AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals(AllowUpdate.AYE) && Util.certValidIsExpire(certDetailInfo)) {
            //展示更新的弹窗
            if (isShowUpdate) {
                showNotifyDialog();
            }
        }

        showBtn(revoke);

        if (!AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals(AllowUpdate.AYE)) {
            update.setVisibility(View.GONE);
        } else {
            update.setVisibility(View.VISIBLE);
        }
        update.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                //更新证书
                operate_type = UPDATE_CERT_INFO;
                showPinDialog();
            }
        });


        revoke.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                //撤销证书
                operate_type = REVOKE_CERT;
                showPinDialog();
            }
        });
        revoke_full.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //撤销证书
                operate_type = REVOKE_CERT;
                showPinDialog();
            }
        });

    }

    private void showWaitRevoke(@StringRes int strId) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_wait_agree_revoke, null);
        certStatus.removeAllViews();
        certStatus.addView(view);
        showBtn(refresh);
        refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //查询证书状态
                queryCertStateFromServer();
            }
        });

    }


    private void showNoCurrentPki(final int strID) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_verify_fail, null);
        TextView revokeInfo1 = (TextView) view.findViewById(R.id.revokeInfo1);
        revokeInfo1.setText(strID);

        certStatus.removeAllViews();
        certStatus.addView(view);

        showBtn(delete);
        delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                operate_type = DELETE_CERT;
                showPinDialog();
            }
        });
    }

    /**
     * 本地有证书，服务端无证书引导用户删除本地证书
     */
    private void showServerNoCert() {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_server_nocert, null);
        certStatus.removeAllViews();
        certStatus.addView(view);
        showBtn(delete);
        delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                operate_type = DELETE_CERT;
                showPinDialog();
            }
        });

    }


    private void showAgreeRevoke() {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_agree_revoke, null);

        TextView status = (TextView) view.findViewById(R.id.revoked);
        status.setText(getResources().getString(R.string.cert_creation_detail_revoke_success));
        showBtn(delete);
        delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                operate_type = DELETE_CERT;
                showPinDialog();
            }
        });
        certStatus.removeAllViews();
        certStatus.addView(view);
    }


    private void showException(final String message) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_error, null);
        TextView reason = (TextView) view.findViewById(R.id.reason);
        reason.setText(message);


        showBtn(refresh);
        refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!bean.getIsVerify()) {
                    showNoCurrentPki();
                } else {
                    queryCertStateFromServer();
                }
            }
        });

        certStatus.removeAllViews();
        certStatus.addView(view);

    }

    private void showNoCurrentPki() {
        showNoCurrentPki(R.string.cert_creation_cert_not_in_system);
    }

    private void showNotifyDialog() {
        showInvalidPermissionDialog();
    }

    /**
     * 显示输入pin码对话框
     */
    private void showPinDialog() {

        if (pinDialog == null) {
            pinDialog = new PinDialog(context, chipBeanType, containerNum, new PinDialog.HandlePinResult() {
                @Override
                public void onSuccess() {
                    if (operate_type == REVOKE_CERT) {
                        //撤销证书
                        startReasonActivity();
                    } else if (operate_type == DELETE_CERT) {
                        //删除证书
                        new ClearContainerTask().execute();
                    } else {

                        //启动更新证书选择界面

                        ARouter.getInstance().
                                build(ActivityPath.ACTIVITY_UPDATE_CERT)
                                .withString("cardNum", cardID)
                                .withSerializable("chipBean", bean)
                                .withString(ActivityParam.CERT_TYPE, certType)
                                .navigation(context);


//                //更新证书
//                updateCert();
                    }
                    operate_type = -1;
                    pinDialog = null;
                }

                @Override
                public void onFail(int pinResult) {
                    handleErrorResponse(CryptoDevManager.getInstance().getErrorText(pinResult));
                }
            });
        }
        pinDialog.show();
    }


    private void showCertState() {
        if (!bean.getIsVerify()) {
            showNoCurrentPki();
        } else {
            switch (bean.getState()) {
                case NET_ERROR:
                    showException(getResources().getString(R.string.net_disconnected_text));
                    break;
                case NET_TIMEOUT:
                    showException(getResources().getString(R.string.net_timeout));
                    break;
                case SUCCESS:
                    showCertNormal();
                    break;
                case WAITING_AGREE_REVOKE:
                    //撤销等待中
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    break;
                case AGREE_REVOKE:
                    //已撤销
                    showAgreeRevoke();
                    break;
                case REJECT_REVOKE:
                    showRejectRevoke(R.string.cert_creation_revoke_reject, bean.getReason());
                    break;
                case SERVER_NOCERT:
                    showNoCurrentPki(R.string.cert_creation_server_no_cert_local_has_cert);
                    break;
                case CERT_OUT_OF_DATE:
                    showNoCurrentPki(R.string.cert_creation_cert_out_of_date);
                    break;
            }
        }
    }

    private void startReasonActivity() {
        ARouter.getInstance()
                .build(ActivityPath.ACTIVITY_REASON)
                .withInt("type", ReasonActivity.REVOKE)
                .withSerializable("chipBean", bean)
                .withString("cardId", cardID)
                .withString(ActivityParam.CERT_TYPE, certType)
                .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                .navigation(this, ReasonActivity.REVOKE);
    }

    private void fixCommonPin(String code) {
        if (!AppConfig.getInstance().getDefaultConfig().getPin().equals(code)) {
            AppConfig.getInstance().getDefaultConfig().setPin(code);
        }
    }

    private class ClearContainerTask extends AsyncTask {
        int result;

        @Override
        protected Object doInBackground(Object[] objects) {
            result = DeviceWrapper.getInstance().clearContainer(chipBeanType, containerNum);
            return result;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            showLoading(R.string.cert_creation_is_deleting_cert);

        }

        @Override
        protected void onPostExecute(Object o) {
            super.onPostExecute(o);

            if (result == 0) {
                //通知主页面更新对应状态
                bean.setState(CertState.DELETE_SUCCESS);

                OttoUtil.postCertOperate(containerNum, bean);
                
                dismissLoading();
                finish();
            } else {
                ModuleToast.show(context, getResources().getString(R.string.cert_creation_delete_cert_fail));
                dismissLoading();
            }
        }
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == ReasonActivity.RECOVERY) {
            // 解冻证书
            String reason = data.getStringExtra("reason");
            recoveryCert(reason);
        }
    }

    @Subscribe
    public void handleRevokeResult(RevokeResultEvent event) {

        CertState state = event.getChipBean().getState();

        if (state == CertState.WAITING_AGREE_REVOKE) {
            showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
        } else if (state == CertState.AGREE_REVOKE) {
            showAgreeRevoke();
        } else if (state == CertState.REJECT_REVOKE) {
            showRejectRevoke(R.string.cert_creation_revoke_reject, event.getReason());
        }

    }


    private void showRejectRevoke(@StringRes int strId, String msg) {

        View view = LayoutInflater.from(this).inflate(R.layout.cert_detail_reject_revoke, null);
        certStatus.removeAllViews();
        certStatus.addView(view);

        TextView revoke = (TextView) view.findViewById(R.id.revoked);
        revoke.setText(strId);

        TextView reason = (TextView) view.findViewById(R.id.reason);
        String text = getResources().getString(R.string.cert_creation_reason) + msg;
        reason.setText(text);


        refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                queryCertStateFromServer();
            }
        });

        refresh.setVisibility(View.VISIBLE);

        delete.setVisibility(View.GONE);

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_cert_detail;
    }


    /**
     * 2.5.【I-airIssue-api-006】证书撤销
     */
    private void revokeCert(String revokeReason) {
        showLoading(R.string.cert_creation_is_revoking_cert);
        //todo 此处应该加上进度
        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(context)) {
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    showException(getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000);
            return;
        } else {
            showException(getResources().getString(R.string.net_timeout));
        }
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        String sn;
        if (certDetailInfo != null) {
            sn = certDetailInfo.sn;
        } else {
            ModuleLog.e("sn为空");
            return;
        }
        info.setSn(sn);
        info.setReason(revokeReason);
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, info.toString());
        if (sign != null) {
            if (sign.startsWith("errorCode")) {
                showPinDialog();
                return;
            } else {
                revokeRequest.setSign(sign);
            }
        } else {
            ModuleToast.show(context, R.string.cert_creation_signFail);
        }

        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));
        certService.revokedCert(revokeRequest, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
//                ModuleLog.e("注销异常： " + e);
                //网络异常，请重试
                showException(getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
//                    ModuleLog.e("证书撤销成功result = " + result);
                if (result.equals("0")) {
                    bean.setState(CertState.WAITING_AGREE_REVOKE);
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    //通知证书列表页更新证书展示状态
                    OttoUtil.postCertOperate(containerNum, bean);
                } else if (result.equals("1")) {//撤销申请成功
                    bean.setState(CertState.AGREE_REVOKE);
                    showAgreeRevoke();
                    OttoUtil.postCertOperate(containerNum, bean); //通知证书列表页更新证书展示状态
                } else if (result.equals("2")) {//撤销被拒绝
                    showRejectRevoke(R.string.cert_creation_revoke_reject, commonResponse.getMessage());
                } else if (result.equals("5")) {
                    // todo 证书被冻结

                } else if (result.equals("6")) {
                    //todo 证书过期
                }


            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                String message = baseErrorResponse.getMessage();
//                    ModuleLog.e("注销失败： " + baseErrorResponse.getErrCode());
                handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {

            }
        });
    }

    /**
     * 2.8.【I-airIssue-api-009】证书解冻申请
     */
    private void recoveryCert(String revokeReason) {
        showLoading(R.string.cert_creation_is_recoverying_cert);
        //todo 此处应该加上进度
        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(context)) {
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    showException(getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000);
            return;
        } else {
            showException(getResources().getString(R.string.net_timeout));
        }
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        String sn;
        if (certDetailInfo != null) {
            sn = certDetailInfo.sn;
        } else {
            ModuleLog.e("sn为空");
            return;
        }
        info.setSn(sn);
        info.setReason(revokeReason);
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, info.toString());
        if (sign.startsWith("errorCode")) {
            showPinDialog();
            return;
        } else {
            revokeRequest.setSign(sign);
        }
        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));


        certService.thawingCert(revokeRequest, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                showException(getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();

                if (result.equals("0")) {
                    // 正在审核
                    bean.setState(CertState.RECOVERY_PROGRESS);
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    OttoUtil.postCertOperate(containerNum, bean);  //通知证书列表页更新证书展示状态
                } else if (result.equals("1")) {
                    // 解冻成功
                    bean.setState(CertState.RECOVERY_SUCCESS);
                    OttoUtil.postCertOperate(containerNum, bean); //通知证书列表页更新证书展示状态
                } else if (result.equals("2")) {
                    // 解冻申请拒绝
                    showRejectRevoke(R.string.cert_creation_recovery_fail, commonResponse.getMessage());
                }

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    /**
     * 2.6【I-airIssue-api-007】查询证书状态
     * 查询证书状态
     */
    private void queryCertStateFromServer() {
        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/

        if (!CommonUtil.isNetworkConnected(context)) {

            ModuleToast.show(context, R.string.net_disconnected_text);

            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {

                    showException(getResources().getString(R.string.net_disconnected_text));
                    // 不要把dismissLoading放在外层，否则会立即消失，看上去像dialog没有显示过一样
                    dismissLoading();
                }
            }, 1000);
            return;
        } else {
            //当有网络，但是网络不可用时，弹出dialog框并在1s后关闭，避免造成没执行的假象
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    dismissLoading();
                }
            }, 1000);
        }

        showLoading(R.string.cert_creation_is_checking_cert);

        CertStateRequest certStateRequest = new CertStateRequest();
        if (certDetailInfo != null) {
            //本地有证书，用本地证书的sn查询证书状态
            certStateRequest.setSn(certDetailInfo.sn);
        } else {
            certStateRequest.setSn("");
        }
        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));

        certService.certStateQuery(certStateRequest, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    // 提示卡设备不存在
//                    ModuleToast.show(CertDetailInfoActivity.this, R.string.device_not_exist);
                    showException(getResources().getString(R.string.cert_creation_device_not_exist));
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
//                    ModuleLog.e("IOException:  " + e);
                //网络异常，请重试
                showException(getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                //0表示等待撤销审核，1-证书已经被注销，2，证书注销申请被拒绝，3-证书状态正常，4-证书不存在
                String result = commonResponse.getResult();
//                    ModuleLog.e("查询证书状态成功result = " + result);
                if (result.equals("0")) {
                    //0表示等待撤销审核，显示撤销信息已提交，等待审核
                    bean.setState(CertState.WAITING_AGREE_REVOKE);
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    OttoUtil.postCertOperate(containerNum, bean);  //通知证书列表页更新证书展示状态
                } else if (result.equals("1")) {
                    //1-证书已经被注销
                    bean.setState(CertState.AGREE_REVOKE);
                    showAgreeRevoke();
                    OttoUtil.postCertOperate(containerNum, bean); //通知证书列表页更新证书展示状态
                } else if (result.equals("2")) {
                    //2，证书注销申请被拒绝
                    bean.setState(CertState.REJECT_REVOKE);
                    bean.setReason(commonResponse.getMessage());
                    showRejectRevoke(R.string.cert_creation_revoke_reject, commonResponse.getMessage());
                    OttoUtil.postCertOperate(containerNum, bean); //通知证书列表页更新证书展示状态
                } else if (result.equals("3")) {
                    //3-证书状态正常,本地没有找到证书，则再次写卡。
                    bean.setState(CertState.SUCCESS);
                    showCertNormal();
                } else if (result.equals("4")) {
                    //4-证书不存在查询实体认证结果
                    showServerNoCert();
                } else if (result.equals("5")) {
                    //5-证书被冻结

                } else if (result.equals("6")) {
                    //6-证书处于解冻申请中

                } else if (result.equals("7")) {
                    //7-证书解冻申请被拒绝

                } else if (result.equals("8")) {
                    //8-证书处于延期申请中

                } else if (result.equals("9")) {
                    //9-证书延期申请成功

                } else if (result.equals("10")) {
                    //10-证书延期申请被拒绝

                } else if (result.equals("11")) {
                    // 11-证书处于更新申请中

                } else if (result.equals("12")) {
                    //12-证书更新成功

                } else if (result.equals("13")) {
                    //13 –证书更新申请被拒绝

                } else if (result.equals("14")) {
                    //14-证书已过期

                }
                dismissLoading();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                    404	0x10a4	cert_status_other 	证书状态异常
//                    400	0x10a3	cert_revoke_fail	证书注销失败
//                String message = baseErrorResponse.getMessage();
//                    ModuleLog.e("查询证书状态失败message: " + message);
                handleErrorResponse(baseErrorResponse.getErrCode());
                dismissLoading();
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    /**
     * 2.9.【I-airIssue-api-010】证书更新
     */
    private void updateCert() {
        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        showLoading(R.string.cert_creation_is_update_cert);
        if (!CommonUtil.isNetworkConnected(context)) {
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    showException(getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000);
            return;
        } else {
            showException(getResources().getString(R.string.net_timeout));
        }

        if (certDetailInfo == null) {
            return;
        }
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setSn(certDetailInfo.sn);
        updateInfo.setTime(System.currentTimeMillis());
        updateInfo.setType("1");
        updateInfo.setReason("");


        String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, certDetailInfo.subjectCn, false);
        updateInfo.setP10(p10);

        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, updateInfo.toString());
        CertInfoUpdateRequest certUpdateRequest = new CertInfoUpdateRequest();
        certUpdateRequest.setSign(sign);
        certUpdateRequest.setInfo(updateInfo);


        certService.updateOrDelayCert(certUpdateRequest, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
//                    ModuleLog.e("证书更新IO " + e.getMessage());
                showException(getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
//                    ModuleLog.e("证书更新Success " + result);
                if (result.equals("0")) {//正在审核
                    showWaitRevoke(R.string.cert_creation_update_info_need_verify_please_wait);
                } else if (result.equals("1")) {//更新成功
                    String certStr = commonResponse.getMessage();
                    writeCert(certStr);
                } else if (result.equals("2")) {//更新拒绝
                    showRejectRevoke(R.string.cert_creation_update_info_reject, commonResponse.getMessage());
                } else {
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                String message = baseErrorResponse.getMessage();
//                    ModuleLog.e("证书更新fail " + message);
                handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
//                    ModuleLog.e("证书更新dismissDialog " );
            }
        });
    }


    /**
     * 拿到服务器返回的cert，开始写卡，并展示
     *
     * @param cert
     */
    private void writeCert(final String cert) {

        if (TextUtils.isEmpty(cert)) {
            return;
        }

        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                final int result = DeviceWrapper.getInstance().writeCert(chipBeanType, containerNum, cert);
                certDetailInfo = DeviceWrapper.getInstance().readCertFromContainer(chipBeanType, containerNum,
                        certType);

                myHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (result == 0) {
                            showData(certDetailInfo);
                            showCertNormal();

                            //通知列表页面更新证书状态
                            bean.setState(CertState.AGREE_UPDATE);
                            bean.setCertDetailInfo(certDetailInfo);
                            OttoUtil.postCertOperate(containerNum, bean);

//                            notifySafeAccess(CertDetailInfoActivity.this);

                        } else {
                            // ModuleLog.e("写卡失败上报" );
                            writeCertToServer(chipBeanType, DeviceWrapper.getInstance().getSn(chipBeanType, containerNum, cert), "1");
                        }
                    }
                }, 10);
            }
        };
        new ChipExecutorService().exe(runnable);
    }


    //写卡状态上报
    private void writeCertToServer(CryptoDevType type, String sn, String status) {
        WriteFailRequest request = new WriteFailRequest();

        WriteFailInfo info = new WriteFailInfo();


        info.setSn(sn);
        info.setStatus(status);
        info.setTime(System.currentTimeMillis());
        request.setInfo(info);
//        ModuleLog.e("写卡上报 sn " + sn);
        String sign = DeviceWrapper.getInstance().signData(type, containerNum, info.toString());
//        ModuleLog.e("sign " + sign);
        if (sign.startsWith("errorCode")) {
            showException(sign.substring(9));
            return;
        } else {
            request.setSign(sign);
        }

        request.setCardType("" + CryptoDevTypeUtil.convertCardType(type.getType()));

        certService.uploadWriteCertResult(request, cardID, new HttpResponseCallBack<CommonResponse>() {
                    @Override
                    public void onOtherException(Exception e) {
                        e.printStackTrace();
                    }

                    @Override
                    public void onIoExceptionFailure(Call call, IOException e) {
                        //网络异常，请重试
                        int netRes;
                        if (!CommonUtil.isNetworkConnected(context)) {
                            netRes = R.string.net_disconnected_text;
                        } else {
                            netRes = R.string.net_timeout;

                        }
//                            ModuleLog.e("onIoExceptionFailure " + e.getMessage());
                        showException(getResources().getString(netRes));
                    }

                    @Override
                    public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {

//                            ModuleLog.e("onSuccessfulResponse " + commonResponse.getResult());
                        showException(getResources().getString(R.string.cert_creation_write_authentiation_fail));
                    }

                    @Override
                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                    404	0x10a4	cert_status_other 	证书状态异常
//                    400	0x10a3	cert_revoke_fail	证书注销失败
//                        String message = baseErrorResponse.getMessage();
//                            ModuleLog.e("onFailResponse " + message);
                        handleErrorResponse(baseErrorResponse.getErrCode());
                    }

                    @Override
                    public void dismissDialog() {

                    }
                }
        );
    }


    /**
     * 处理服务器返回的错误码
     *
     * @param errorCode
     */
    private void handleErrorResponse(String errorCode) {
        String msg = OkNetError.handleErrorCodeToMsg(this, errorCode);
        showException(msg);

    }

}
