package com.xdja.safeclient.certcreation.activity;

import android.Manifest;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;

import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.a3rdplugin.demo.ocr.XDJAOCR;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.AppController;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.config.CertConfig;
import com.xdja.safeclient.certcreation.databases.DatabaseManager;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RequestPhonePermission;
import com.xdja.safeclient.certcreation.event.SwipeEnableEvent;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.CommonService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;

import org.joor.Reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import static com.aircert.CommonActivity.ToolBarActivity.ToolBarDef.NAVIGATE_BACK;
import static com.aircert.CommonActivity.ToolBarActivity.ToolBarDef.NAVIGATE_DEFAULT;


public class CertViewActivity extends BaseActivity implements View.OnClickListener {

    public static final String TAG = "CertViewActivity";

    private RecyclerView recyclerView;
    private RecyclerViewAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout noChip;

    private SwipeRefreshLayout swipe;

    private boolean isFirstStart = true;//是否是第一次启动

    private int navigateType;
    private int titleRes;

    private int type = -1;  //申请权限的芯片类型

    private String cardID;
    private boolean isResumeExe = true;  // onResume 中的方法是否执行

    private List<CertItemBean> certItemBeans = null;

    private SinglePermissionDialog dialog;

    public static long lastClickTime;

    private boolean isOnlineVHSM = AppConfig.getInstance().getCertConfig().getVHSMType()
            .equals(CardType.ONLINE_VHSM);

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        initConfigView();
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_cert_view);
        setRightImage(R.drawable.settings, this);
        initView();
        if (!BuildConfig.isAAR) {
            // TODO: 2019/7/20 独立版进入详情页如果需要检测升级怎么处理
            updateApp();
        }

    }

    private void initConfigView() {
        // AAR显示左上角的返回列表，独立版隐藏
        if (BuildConfig.isAAR) {
            navigateType = NAVIGATE_BACK;
            titleRes = R.string.cert_creation_cert_view;
        } else {
            navigateType = NAVIGATE_DEFAULT;
            titleRes = R.string.cert_creation_air_cert;
        }


        //是否屏蔽软卡 true屏蔽    false不屏蔽
        if (FeatureConfig.getInstance().isDisableVHSM() ||
                !AppConfig.getInstance().getCertConfig().hasVHSM()) {
            CryptoDevManager.getInstance().setDisableSoft(true);
        } else {
            CryptoDevManager.getInstance().setDisableSoft(false);
        }

//        //如果卡类型是联网版VHSM，则从服务端获取初始化需要的ip和port
//        if (isOnlineVHSM
//                && SharePreferencesUtil.getVHSMUrl(getApplicationContext()).equals("")) {
//            CommonService.getVhsmServerURL(getApplicationContext());
//        }

    }

    /**
     * 检测升级
     */
    private void updateApp() {
        {
            //使用反射前
            //XDJAUpdateExecutor.getInstance().onForceShowUpdateDialog(context);
        }

        {
            //使用反射后
            if (BuildConfig.compileUpdate) {
                Reflect.on("com.xdja.updatelibrary.XDJAUpdateExecutor")
                        .call("getInstance")
                        .call("onForceShowUpdateDialog", context);
            }
        }
    }


    @Override
    protected int getToolbarType() {
        return navigateType;
    }

    @Override
    protected int getTitleRes() {
        return titleRes;
    }


    private String[] permissions = new String[]{Manifest.permission.CAMERA,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_PHONE_STATE,};

    @Override
    protected void onResume() {
        super.onResume();

        if (!isResumeExe) {
            return;
        }

        if (isFirstStart) {
            isFirstStart = false;
            //第一次启动时，如果所有权限都可以获取，则直接展示证书列表；否则弹框提示用户申请权限
            if (checkValidPermission(permissions)) {
                getCertAndShow();
            } else {
                showInvalidPermissionDialog();
            }
        } else {
            getCertAndShow();
        }

        String ocrCompany = AppConfig.getInstance().getServerSettingConfig().getOcrCompany();
        if (ocrCompany.equals(OCRCompany.XDJA)) {
            if (!XDJAOCR.isInstall(context)) {
                XDJAOCR.copyXDJAOCRAPK(context);
            }
        }

    }


    /**
     * 判断是否所有权限都开启
     *
     * @param permissions
     * @return
     */
    private boolean checkValidPermission(String... permissions) {
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }


    /**
     * 获取证书并展示
     */
    private void getCertAndShow() {
        //是否需要刷新
        if (this.recyclerViewAdapter != null && !this.recyclerViewAdapter.getIsRefresh()) {
            this.recyclerViewAdapter.setIsRefresh(true);
            return;
        }
        noChip = (LinearLayout) findViewById(R.id.no_chip);
        recyclerViewAdapter.clear();

        //        this.certItemBeans = getCertItemBeans();

        this.certItemBeans = initList(getCurrentCardTypeList());

        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            swipe.setVisibility(View.GONE);
            noChip.setVisibility(View.VISIBLE);
        } else {
            swipe.setVisibility(View.VISIBLE);
            noChip.setVisibility(View.GONE);

            recyclerViewAdapter.addAll(this.certItemBeans);
        }

    }


    /**
     * 权限检测（只检测敏感权限即可，其他权限只要在manifest里写入，系统自动赋予）
     */
    @XdjaPermission(permissions = {
            Manifest.permission.CAMERA,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_PHONE_STATE,
    })
    private void checkoutPermission() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            getCertAndShow();
        }
    }

    /**
     * 弹窗提示用户用户开启权限
     */
    private void showInvalidPermissionDialog() {

        ArrayList<String> list = new ArrayList<>();

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item1));
        }

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item2));
        }


        if (ContextCompat.checkSelfPermission(this, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item3));
        }

        String permission = HTMLText.formatPermissionText(this, list);

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(context);

        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                checkoutPermission();
            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.finish();
            }
        });
    }

    /**
     * 申请证书之前先进行权限检测
     *
     * @param requestPhonePermission
     */
    @Subscribe
    public void requestPhonePermission(RequestPhonePermission requestPhonePermission) {
        ModuleLog.d("3收到请求准备申请电话权限：" + this.toString());
        this.type = requestPhonePermission.type;
        this.cardID = requestPhonePermission.cardID;
        requestPhonePermission();
    }


    @XdjaPermission(permissions = {
            Manifest.permission.READ_PHONE_STATE
    })
    private void requestPhonePermission() {
        //android版本低于23时，不进行权限检测，执行当前方法 gyx 2018.8.29
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            sendPhonePermissionResult();
        }
    }

    private void sendPhonePermissionResult() {
        ModuleLog.d("5电话权限允许结果发送：" + this.toString());
        OttoUtil.postPhonePermissionResult(CertViewActivity.this.type);
        CertViewActivity.this.type = -1;


    }

    @Subscribe
    public void onPhonePermission(PhonePermissionResult phonePermissionResult) {
        applyCert(phonePermissionResult.type);
    }

    private void applyCert(int cardType) {
        //为了防止PhoneInputActivity出现多次，一个是两次启动时间在1秒内不再启动
        //        另外一个是判断下栈顶Activity，如果是则不再启动
        //        getTopActivity(context)值如下
        //ComponentInfo {com.xdja.aircert/com.xdja.safeclient.certcreation.activity.PhoneInputActivity}
        if (getTopActivity(context).contains("PhoneInputActivity")) {
            ModuleLog.d("界面已存在，放弃");
            return;
        } else {
            ModuleLog.d("7可以启动新界面：" + this.toString());
        }

//        String imsi = DeviceWrapper.getInstance().getIMSI();
//        if (imsi == null || imsi.equals("")) {
//            //ModuleToast.show(context, R.string.get_imsi_failed);
//            //这个地方本来应该是请安装SIM卡，但是因为权限问题，暂时使用这个提示
//
//            SinglePermissionDialog dialog = new SinglePermissionDialog();
//            dialog.build(context, context.getString(R.string.cert_creation_get_imsi_failed));
//            dialog.show();
//
//            return;
//        }

        SharePreferencesUtil.saveCurrentDevType(context, cardType);
        SharePreferencesUtil.saveDevCardID(context, cardID);
        if (recyclerViewAdapter != null) {
            recyclerViewAdapter.setIsRefresh(false);
        }

        // 注意applyCert方法中用的都是cardType，不是type

        ARouter.getInstance()
                .build(ActivityPath.ACTIVITY_PHONE_INFO)
                .withSerializable("cardType", CryptoDevTypeUtil.formatType(cardType))
                .withString("cardNum", cardID)
                .navigation(context);

        com.aircert.util.ModuleLog.time("准备启动");

    }

    /**
     * 获得栈中最顶层的Activity
     *
     * @param context
     * @return
     */
    public static String getTopActivity(Context context) {
        android.app.ActivityManager manager = (android.app.ActivityManager) context.getSystemService(context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> runningTaskInfos = manager.getRunningTasks(1);

        if (runningTaskInfos != null) {
            return (runningTaskInfos.get(0).topActivity).toString();
        } else
            return null;
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (recyclerViewAdapter != null) {
            recyclerViewAdapter.destroy();
        }
    }

    /**
     * 读取当前设备实际上存在的设备类型
     *
     * @return
     */
    private List<String> getCurrentCardTypeList() {

        List<String> cardTypeList = new ArrayList<>();

        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();

        if (devInfoMap != null) {
            for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {

                if (cryptoDevInfoEntry != null) {
                    cardTypeList.add(CardType.toString(cryptoDevInfoEntry.getValue().getType()));
                }

            }
        }

        return cardTypeList;
    }


    private List<CertItemBean> initList(List<String> currentCardTypeList) {

        // 已有设备
        Map<Integer, CryptoDevInfo> currentCardMaps = DeviceWrapper.getInstance().getDevInfo();

        List<CertItemBean> all = new ArrayList<>();

        // 先读配置好的数据库中所有的数据
        List<TableCertConfig> tableValue = SQLite.select().from(TableCertConfig.class).queryList();

        HashSet<String> tableCardSet = new HashSet();

        // 如果当前设备列表中的设备在数据库中存在，则加入该条（配置）数据
        for (TableCertConfig config : tableValue) {

            String cardType = config.getCardType();

            tableCardSet.add(cardType);

            // 在线VHSM和离线VHSM，也就是软卡，不属于硬件设备（卡），都要展示的
            if (cardType.equals(CardType.OFFLINE_VHSM)
                    || cardType.equals(CardType.ONLINE_VHSM)
                    ) {

                CryptoDevInfo netVhsm = new CryptoDevInfo();
                netVhsm.setCardId(NetVHSMHandle.getNetVhsmCardId());
                netVhsm.setDriver(ChipManagerDriver.DRIVER_NAME);
                netVhsm.setType(CryptoDevType.DEV_TYPE_Soft);

                XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
                netVhsm.setPrivateData((Object) extraInfo.setType(JniApiParam.TYPE_VHSM_NET));

                CertItemBean bean = new CertItemBean();
                bean.setCertConfig(config);
                bean.setCryptoDevInfo(netVhsm);
                all.add(bean);

            } else {
                if (currentCardTypeList.contains(cardType)) {

                    CertItemBean bean = new CertItemBean();
                    bean.setCertConfig(config);
                    bean.setCryptoDevInfo(currentCardMaps.get(CardType.toType(cardType).getType()));

                    all.add(bean);

                }
            }

        }

        // 如果当前已获取的设备未在数据库中配置，
        // 则用默认容器号、证书类型、算法类型、证书机制加入该条（配置）数据
        for (String currentCardType : currentCardTypeList) {
            if (!tableCardSet.contains(currentCardType)) {

                TableCertConfig tableCertConfig = TableCertConfig.initDefaultOne();

                tableCertConfig.cardType = currentCardType;


                CertItemBean bean = new CertItemBean();
                bean.setCryptoDevInfo(
                        currentCardMaps.get(CardType.toType(currentCardType).getType()));
                bean.setCertConfig(tableCertConfig);
                all.add(bean);

            }
        }

        ModuleLog.d(all);

        Collections.sort(all);


        return all;
    }

    /**
     * 展示没有进行初始化的NET_VHSM,以供实体认证使用
     *
     * @param certItemBeans
     */
    private void showNOInitVhsm(List<CertItemBean> certItemBeans) {
        //如果需要显示联网版VHSM,前提假设是单机版和联网版不同时存在
        if (isOnlineVHSM
                && !NetVHSMHandle.isNetVHSMCanUse()) {
            CryptoDevInfo netVhsm = new CryptoDevInfo();
            netVhsm.setCardId(NetVHSMHandle.getNetVhsmCardId());
            netVhsm.setDriver(ChipManagerDriver.DRIVER_NAME);
            netVhsm.setType(CryptoDevType.DEV_TYPE_Soft);

            XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
            netVhsm.setPrivateData((Object) extraInfo.setType(JniApiParam.TYPE_VHSM_NET));

            CertItemBean certItemBean = new CertItemBean();
            certItemBean.setCryptoDevInfo(netVhsm);
            certItemBeans.add(certItemBean);
        }
    }

    private void initView() {
        swipe = (SwipeRefreshLayout) findViewById(R.id.swipe);
        swipe.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                pullToRefresh();
            }
        });

        //下拉刷新的判断以是否有发证功能为依据，有发证可下拉刷新，无法证功能不可下拉刷新
        swipe.setEnabled(FeatureConfig.getInstance().isDisableMakeNewCert() ? false : true);

        layoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        recyclerViewAdapter = new RecyclerViewAdapter(this, this.toString());
        recyclerView = (RecyclerView) findViewById(R.id.recyclerview);
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setAdapter(recyclerViewAdapter);

        if (BuildConfig.isAAR) {
            rightBtn.setVisibility(View.GONE);
        } else {
            rightBtn.setVisibility(View.VISIBLE);
        }
    }


    @Subscribe
    public void handSwipeEnable(SwipeEnableEvent event) {
        ModuleLog.e("652 CertViewActivity handSwipEnable : [event]");
        swipe.setEnabled(event.isSwipToPull());
    }

    private void pullToRefresh() {
        recyclerViewAdapter.refresh();
    }


    @Override
    public void onClick(View view) {

        if (view.getId() == R.id.title_right_btn) {
            Intent intent = new Intent();
            intent.setClass(this, AboutActivity.class);
            startActivity(intent);
        }
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ModuleLog.d("权限回调");
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            } else {
                isGrant = true;
            }
        }
        onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(final boolean isGrant) {
        isResumeExe = false;
        //使用延时的原因是为了先执行onResume方法，再发送权限申请结果。
        CertViewActivity.this.getWindow().getDecorView().postDelayed(new Runnable() {
            @Override
            public void run() {
                isResumeExe = true;
                if (CertViewActivity.this.type == -1) {
                    getCertAndShow();
                } else {
                    if (isGrant) {
                        sendPhonePermissionResult();
                    } else {
                        showNoPhonePermissionDialog();
                    }
                }
            }
        }, 10);

    }


    /**
     * 展示权限申请对话框
     */
    public void showNoPhonePermissionDialog() {
        if (dialog == null) {
            initNoPermissionDialog();
        }
        dialog.show();
    }


    /**
     * 初始话权限禁用对话框
     */
    private void initNoPermissionDialog() {
        dialog = new SinglePermissionDialog();
        dialog.build(this, SinglePermissionDialog.PERMISSION_PHONE);
    }


    /**
     * 跳转到设置权限页面
     */
    private void gotoSetting() {
        Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts("package", getPackageName(), null);
        intent.setData(uri);
        startActivity(intent);
    }


    @Override
    public void finish() {
        super.finish();
        new CertService().cancelAll();
    }

    @Override
    public void onBackPressed() {

        if (BuildConfig.isAAR) {
            super.onBackPressed();
        } else {
            if (lastClickTime == 0) {
                lastClickTime = System.currentTimeMillis();
                ModuleToast.show(this, R.string.cert_creation_click_one_more);
            } else {
                long current = System.currentTimeMillis();
                if (current - lastClickTime < 1000) {
                    super.onBackPressed();
                } else {
                    ModuleToast.show(this, R.string.cert_creation_click_one_more);
                }
                lastClickTime = current;
            }
        }
    }

    @Subscribe
    public void handleQueryFinished(QueryFinishEvent event) {
        //ModuleToast.show(this, "刷新结束");
        swipe.setRefreshing(false);
    }

    /*@Subscribe
    public void handleDebugEvent(DebugEvent event) {
        Looper.prepare();
//        ModuleToast.show(context, event.getMsg());
        Toast.makeText(context, event.getMsg(),Toast.LENGTH_LONG).show();
    }*/


}
