package com.xdja.safeclient.certcreation.activity;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;

import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.cert_creationGeneratedDatabaseHolder;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabase;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.databases.CertConfigDataBase;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;

import org.apache.commons.net.telnet.TelnetClient;

import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by zjc on 2019/5/21 0021.
 */
@Route(path = ActivityPath.ACTIVITY_CONFIG_STEP1, name = ActivityPath.NAME_CONFIG_STEP1)
public class ConfigStep1Activity extends BaseActivity implements View.OnClickListener {

    private View next;

    private EditText etProjectName;

    private EditText etAirCertIP;

    private EditText etAirCertPort;

    private Button connect;

    private EditText etVHSMIP;

    private EditText etVHSMPort;

    private Button connectVHSM;


    ConfigHandler handler = new ConfigHandler();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        FlowManager.init(new FlowConfig.Builder(context).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
        FlowLog.setMinimumLoggingLevel(FlowLog.Level.V);
        // 解决Android9.0无法导出数据库的问题
        DatabaseWrapper wrapper = FlowManager.getDatabase(CertConfigDataBase.NAME).getHelper().getDelegate().getWritableDatabase();
        boolean isWAL = ((AndroidDatabase) wrapper).getDatabase().isWriteAheadLoggingEnabled();
        ((AndroidDatabase) wrapper).getDatabase().disableWriteAheadLogging();


        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);

        setContentView(R.layout.activity_config_step1);

        if (!checkValidPermission(permissions)) {
            showInvalidPermissionDialog();
        }

        initView();

        initViewByData();


    }

    private void initView() {

        etProjectName = findViewById(R.id.project_name);
        etProjectName.setFilters(EditTextUtil.getDisableEmojFilter(20));

        etAirCertIP = findViewById(R.id.nfc_ip_result);
        etAirCertIP.setFilters(EditTextUtil.getDisableEmojFilter());

        etAirCertPort = findViewById(R.id.port);
        etAirCertPort.setFilters(EditTextUtil.getDisableEmojFilter());


        etVHSMIP = findViewById(R.id.vhsm_ip_result);
        etVHSMIP.setFilters(EditTextUtil.getDisableEmojFilter());

        etVHSMPort = findViewById(R.id.vhsm_port);
        etVHSMPort.setFilters(EditTextUtil.getDisableEmojFilter());


        next = findViewById(R.id.next);
        next.setOnClickListener(this);

        connect = findViewById(R.id.connect);
        connect.setOnClickListener(this);

        connectVHSM = findViewById(R.id.vhsm_connect);
        connectVHSM.setOnClickListener(this);

    }

    private void initViewByData() {

        ServerSettingConfig serverSettingConfig = SQLite.select().from(ServerSettingConfig.class).querySingle();

        if (serverSettingConfig == null) {
            return;
        }

        String projectName = serverSettingConfig.getProjectName();
        if (!TextUtils.isEmpty(projectName)) {
            etProjectName.setText(projectName);
        }

        String ip = serverSettingConfig.getIp();
        if (!TextUtils.isEmpty(ip)) {
            etAirCertIP.setText(ip);
        }

        String port = serverSettingConfig.getPort();
        if (!TextUtils.isEmpty(port)) {
            etAirCertPort.setText(port);
        }

        String vhsm_ip = serverSettingConfig.getVhsm_ip();
        if (!TextUtils.isEmpty(vhsm_ip)) {
            etVHSMIP.setText(vhsm_ip);
        }

        String vhsm_port = serverSettingConfig.getVhsm_port();
        if (!TextUtils.isEmpty(vhsm_port)) {
            etVHSMPort.setText(vhsm_port);
        }


    }

    @Override
    public void onClick(View view) {

        int id = view.getId();

        if (id == R.id.next) {
            next();
        } else if (id == R.id.connect) {
            connectType = TYPE_SERVER;
            ping(etAirCertIP.getText().toString(), etAirCertPort.getText().toString());
        } else if (id == R.id.vhsm_connect) {
            connectType = TYPE_VHSM;
            ping(etVHSMIP.getText().toString(), etVHSMPort.getText().toString());
        }

    }

    @Override
    public boolean valid() {

        if (!validProjectName()) {
            return false;
        }

        if (!validIP(etAirCertIP.getText().toString())) {
            return false;
        }

        if (!validPort(etAirCertPort.getText().toString())) {
            return false;
        }

        if (!validIP(etVHSMIP.getText().toString())) {
            return false;
        }

        if (!validPort(etVHSMPort.getText().toString())) {
            return false;
        }

        return true;
    }

    /**
     * 不可为空，最大可输入20个字，只能输入汉字和英文字符
     *
     * @return
     */

    private boolean validProjectName() {

        String projectName = etProjectName.getText().toString();

        if (TextUtils.isEmpty(projectName)) {

            ModuleToast.show(context, R.string.cert_creation_project_name_hint);

            return false;

        }

        if (projectName.length() > 20) {

            ModuleToast.show(context, R.string.cert_creation_err_length_project_name);

            return false;

        }

        return true;

    }

    /**
     * 不可为空，IP地址格式校验：
     * <p>
     * 4组数字组成。
     * <p>
     * 1、第一位不能是小数点；
     * <p>
     * 2、第一位不能是0；
     * <p>
     * 3、只能输入数字和小数点；
     * <p>
     * 4、每位ip只能输入0-255之间的整数 ；
     * <p>
     * 5、必须是4位；
     * <p>
     * 错误提示：【服务器IP地址错误】
     *
     * @return
     */
    private boolean validIP(String ip) {

        if (TextUtils.isEmpty(ip)) {
            ModuleToast.show(context, R.string.cert_creation_config_empty_server_address);
            return false;
        }


        boolean success = AddressUtil.validIP(ip);

        if (!success) {
            ModuleToast.show(context, R.string.cert_creation_config_error_server_address);
        }

        return success;

    }

    /**
     * 不可为空，1-65535
     * <p>
     * 错误提示：【服务器端口错误】
     * <p>
     * 为空提示：【请输入服务器端口】
     *
     * @return
     */
    private boolean validPort(String port) {

        if (TextUtils.isEmpty(port)) {
            ModuleToast.show(context, R.string.cert_creation_config_please_input_server_port);
            return false;
        }

        boolean success = AddressUtil.validPort(port);

        if (!success) {
            ModuleToast.show(context, R.string.cert_creation_config_error_server_port);
        }

        return success;

    }


    @Override
    public void saveValue() {
        super.saveValue();
    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_CONFIG_STEP2;
    }

    @Override
    public void route() {
        super.route();

        ARouter.getInstance()
                .build(nextActivity())
                .withString("projectName", etProjectName.getText().toString())
                .withString("serverIP", etAirCertIP.getText().toString())
                .withString("vhsmServerIP", etVHSMIP.getText().toString())
                .withString("vhsmServerPort", etVHSMPort.getText().toString())
                .withString("serverPort", etAirCertPort.getText().toString())
                .navigation(context);

    }

    /**
     * @param ip
     * @param port
     */
    private void ping(String ip, String port) {

        // 按钮显示连接中
        setConnecting();

        // 本次尝试ping连接完成前不允许再次点击按钮
        disablePing();

        pingServer(ip, port);

    }

    private void setConnecting() {
        handler.sendEmptyMessage(SET_CONNECTING);
    }

    private void disablePing() {
        handler.sendEmptyMessage(DISABLE_PIN);
    }

    private void pingServer(String ip, String port) {
        pingIP(ip, port);
    }

    public static final int CONNECT_SUCCESS = 0;

    public static final int CONNECT_FAILED = 1;

    public static final int SET_CONNECT_TEST = 2;

    public static final int SET_CONNECTING = 3;

    public static final int DISABLE_PIN = 4;

    public static final int ENABLE_PIN = 5;

    public static final int SERVER_SUCCESS = 6;

    public static final int SERVER_FAILED = 7;

    public static final int SET_VHSM_CONNECTING = 8;


    /**
     * @param ip
     */
    private void pingIP(final String ip, final String port) {

        new Thread(new Runnable() {
            @Override
            public void run() {
                TelnetClient telnet = new TelnetClient();
                try {
                    // 2000毫秒超时
                    telnet.setConnectTimeout(2 * 1000);
                    telnet.connect(ip, Integer.parseInt(port));

                    handler.sendEmptyMessage(SERVER_SUCCESS);

                } catch (Exception e) {
                    handler.sendEmptyMessage(SERVER_FAILED);
                    e.printStackTrace();
                } finally {
                    try {
                        telnet.disconnect();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();






       /* new Thread(new Runnable() {
            @Override
            public void run() {

                try {
                    Process p = Runtime.getRuntime().exec("ping -c 1 -w " + 2 + " " + ip);
                    int status = p.waitFor();
                    if (status == 0) {
                        handler.sendEmptyMessage(SERVER_SUCCESS);
                    } else {
                        handler.sendEmptyMessage(SERVER_FAILED);
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                    handler.sendEmptyMessage(SERVER_FAILED);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                    handler.sendEmptyMessage(SERVER_FAILED);
                }

            }
        }).start();*/

    }

    public static int connectType = -1;

    public static final int TYPE_SERVER = 0;

    public static final int TYPE_VHSM = 1;

    class ConfigHandler extends Handler {

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            if (msg.what == CONNECT_SUCCESS) {

                ModuleToast.showNoRepeat(context, R.string.cert_creation_connect_success);

            } else if (msg.what == CONNECT_FAILED) {

                ModuleToast.showNoRepeat(context, R.string.cert_creation_connect_failed);

            } else if (msg.what == SET_CONNECT_TEST) {
                if (connectType == TYPE_SERVER) {
                    connect.setText(R.string.cert_creation_config_test);
                } else if (connectType == TYPE_VHSM) {
                    connectVHSM.setText(R.string.cert_creation_config_test);
                }
            } else if (msg.what == SET_CONNECTING) {
                if (connectType == TYPE_SERVER) {
                    connect.setText(R.string.cert_creation_config_connecting);
                } else if (connectType == TYPE_VHSM) {
                    connectVHSM.setText(R.string.cert_creation_config_connecting);
                }

            } else if (msg.what == DISABLE_PIN) {

                if (connectType == TYPE_SERVER) {
                    connect.setClickable(false);
                } else if (connectType == TYPE_VHSM) {
                    connectVHSM.setClickable(false);
                }

            } else if (msg.what == ENABLE_PIN) {

                if (connectType == TYPE_SERVER) {
                    connect.setClickable(true);
                } else if (connectType == TYPE_VHSM) {
                    connectVHSM.setClickable(true);
                }

            } else if (msg.what == SERVER_SUCCESS) {
                showResult(true);
            } else if (msg.what == SERVER_FAILED) {
                showResult(false);
            }

        }
    }

    private void showResult(final boolean success) {

        handler.sendEmptyMessage(success ? CONNECT_SUCCESS : CONNECT_FAILED);

        setConnectText();

        enablePing();

    }

    private void setConnectText() {
        handler.sendEmptyMessage(SET_CONNECT_TEST);
    }

    private void enablePing() {
        handler.sendEmptyMessage(ENABLE_PIN);
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

    private String[] permissions = new String[]{
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
    };

    /**
     * 判断是否所有权限都开启
     *
     * @param permissions
     * @return
     */
    private boolean checkValidPermission(String... permissions) {
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    /**
     * 弹窗提示用户用户开启权限
     */
    private void showInvalidPermissionDialog() {

        ArrayList<String> list = new ArrayList<>();

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item2));
        }

        String permission = HTMLText.formatPermissionText(this, list);

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(context);

        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                checkoutPermission();
            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.dismiss();
                ConfigStep1Activity.this.finish();
            }
        });
    }


    /**
     * 权限检测（只检测敏感权限即可，其他权限只要在manifest里写入，系统自动赋予）
     */
    @XdjaPermission(permissions = {
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
    })
    private void checkoutPermission() {
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ModuleLog.d("权限回调");
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            } else {
                isGrant = true;
            }
        }
        onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(final boolean isGrant) {
        //使用延时的原因是为了先执行onResume方法，再发送权限申请结果。
        ConfigStep1Activity.this.getWindow().getDecorView().postDelayed(new Runnable() {
            @Override
            public void run() {

                if (!isGrant) {
                    showNoPhonePermissionDialog();
                }

            }
        }, 10);

    }

    /**
     * 展示权限申请对话框
     */
    public void showNoPhonePermissionDialog() {
        if (dialog == null) {
            initNoPermissionDialog();
        }
        dialog.show();
    }


    /**
     * 初始话权限禁用对话框
     */
    private void initNoPermissionDialog() {
        SinglePermissionDialog dialog = new SinglePermissionDialog();
        dialog.build(this, SinglePermissionDialog.PERMISSION_PHONE);
    }

}
