package com.xdja.safeclient.certcreation.activity;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;

import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.a3rdplugin.demo.NFCCompany;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.CertConfigAdapter;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.AllowUpdate;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.databases.CertConfigDataBase;
import com.xdja.safeclient.certcreation.databases.DatabaseManager;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.event.ChooseConfigEvent;
import com.xdja.safeclient.certcreation.event.DeleteCertConfigEvent;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.ConfigDialog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;

import org.apache.commons.net.telnet.TelnetClient;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by zjc on 2019/5/21 0021.
 */
@Route(path = ActivityPath.ACTIVITY_CONFIG_STEP3, name = ActivityPath.NAME_CONFIG_STEP3)
public class ConfigStep3Activity extends BaseActivity implements View.OnClickListener {

    public static final String DEFAULT_CARD_TYPE_TEXT = "请选择";

    @Autowired
    public String projectName;

    @Autowired
    public String serverIP;

    @Autowired
    public String serverPort;

    @Autowired
    public String vhsmServerIP;

    @Autowired
    public String vhsmServerPort;

    @Autowired(name = ConfigParam.PROCEDURE)
    public String procedure;

    RecyclerView recyclerView;

    List<TableCertConfig> list;

    CertConfigAdapter adapter;

    Button addNewCard;

    Button export;

    /**
     * 活体检测
     */
    private View liveCompanyView;

    private TextView liveCompanyResult;

    /**
     * OCRCompany
     */
    private View ocrView;

    private TextView ocrResult;

    /**
     * nfc
     */
    private View nfcView;

    private TextView nfcResult;

    private View nfcIPView;

    private EditText nfcIPResult;

    private View nfcPortView;

    private EditText nfcPortResult;

    private TextView exportHint;

    private CheckBox sAllowUpdate;

    private Button connect;

    private View layout3rdNServer;

    private View dividerLive;

    ConfigHandler handler = new ConfigHandler();

    private ServerSettingConfig serverSettingConfig;

    public static final String path
            = Environment.getExternalStorageDirectory() + "/" + CertConfigDataBase.NAME + ".db";

    private boolean exportSuccess;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_config_step3);

        ARouter.getInstance().inject(this);

        initData();

        initView();

        initViewByData();

        if (list.size() == 0 || list == null) {
            list = new ArrayList<>();
            list.add(defaultCertConfig());
        }

        recyclerView = findViewById(R.id.list_device_detail);

        adapter = new CertConfigAdapter(context, list);

        // recyclerView不可滑动
        LinearLayoutManager layoutManager = new LinearLayoutManager(context) {
            @Override
            public boolean canScrollVertically() {
                return false;
            }
        };

        recyclerView.setLayoutManager(layoutManager);

        recyclerView.setAdapter(adapter);

        resize();

    }

    private void initData() {

        serverSettingConfig = SQLite.select().from(ServerSettingConfig.class).querySingle();

        list = SQLite.select().from(TableCertConfig.class).queryList();

        ModuleLog.d(serverSettingConfig);

        ModuleLog.d(list);
        Log.e("jff", "194 ConfigStep3Activity initData : " + list);
    }

    @Override
    public void onClick(View view) {

        int id = view.getId();

        if (id == R.id.connect) {

            ping();

        } else if (id == R.id.add_new_card) {

            list.add(defaultCertConfig());

            adapter.notifyDataSetChanged();

            resize();

        } else if (id == R.id.export) {

            boolean success = validBeforeExport();

            if (!success) {
                return;
            }

            showExportDialog();


        }

    }

    private void ping() {

        // 按钮显示连接中
        setConnecting();

        // 本次尝试ping连接完成前不允许再次点击按钮
        disablePing();

        pingServer();

    }

    private void setConnecting() {
        handler.sendEmptyMessage(SET_CONNECTING);
    }

    private void disablePing() {
        handler.sendEmptyMessage(DISABLE_PIN);
    }

    private void pingServer() {
        ping(nfcIPResult.getText().toString(), nfcPortResult.getText().toString());
    }

    public static final int CONNECT_SUCCESS = 0;

    public static final int CONNECT_FAILED = 1;

    public static final int SET_CONNECT_TEST = 2;

    public static final int SET_CONNECTING = 3;

    public static final int DISABLE_PIN = 4;

    public static final int ENABLE_PIN = 5;

    public static final int SERVER_SUCCESS = 6;

    public static final int SERVER_FAILED = 7;

    /**
     * @param ip
     */
    private void ping(final String ip, final String port) {

        new Thread(new Runnable() {
            @Override
            public void run() {
                TelnetClient telnet = new TelnetClient();
                try {
                    // 2000毫秒超时
                    telnet.setConnectTimeout(2 * 1000);
                    telnet.connect(ip, Integer.parseInt(port));

                    handler.sendEmptyMessage(SERVER_SUCCESS);

                } catch (Exception e) {
                    handler.sendEmptyMessage(SERVER_FAILED);
                    e.printStackTrace();
                } finally {
                    try {
                        telnet.disconnect();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();

    }


    class ConfigHandler extends Handler {

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            if (msg.what == CONNECT_SUCCESS) {

                ModuleToast.showNoRepeat(context, R.string.cert_creation_connect_success);

            } else if (msg.what == CONNECT_FAILED) {

                ModuleToast.showNoRepeat(context, R.string.cert_creation_connect_failed);

            } else if (msg.what == SET_CONNECT_TEST) {
                connect.setText(R.string.cert_creation_config_test);
            } else if (msg.what == SET_CONNECTING) {
                connect.setText(R.string.cert_creation_config_connecting);
            } else if (msg.what == DISABLE_PIN) {
                connect.setClickable(false);
            } else if (msg.what == ENABLE_PIN) {
                connect.setClickable(true);
            } else if (msg.what == SERVER_SUCCESS) {
                showResult(true);
            } else if (msg.what == SERVER_FAILED) {
                showResult(false);
            }

        }
    }

    private void showResult(final boolean success) {

        handler.sendEmptyMessage(success ? CONNECT_SUCCESS : CONNECT_FAILED);

        setConnectText();

        enablePing();

    }

    private void setConnectText() {
        handler.sendEmptyMessage(SET_CONNECT_TEST);
    }

    private void enablePing() {
        handler.sendEmptyMessage(ENABLE_PIN);
    }


    /**
     * 设备信息增加后，重新设置RecyclerView的高度
     */
    private void resize() {
        recyclerView.setMinimumHeight(ScreenUtil.dip2px(context, 317) * list.size());
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

    }

    @Subscribe
    public void handleConfig(ChooseConfigEvent event) {

        ConfigBean value = event.getConfig();

        String text = value.getContent();

        int position = event.getPosition();

        // 选择的是身份认证服务（活体检测、OCRCompany、NFCCompany）中的一个
        if (position == -1) {
            if (LiveCompany.list.contains(value)) {

                liveCompanyResult.setText(text);

            } else if (NFCCompany.list.contains(value)) {

                nfcResult.setText(text);

            } else if (OCRCompany.list.contains(value)) {
                ocrResult.setText(text);
            }

        } else {

//             选择的是证书设备信息
// （签发设备、签发容器号、密钥算法、证书机制、展示证书类型、操作权限）中的一个

            TableCertConfig item = list.get(position);

            if (CardType.list.contains(value)) {
                item.setCardType(text);
            } else if (ContainerNum.list.contains(value)) {
                item.setContainerNum(Integer.parseInt(text));
            } else if (AlgType.list.contains(value)) {
                item.setAlgType(text);
            } else if (CertRule.list.contains(value)) {
                item.setCertRule(text);
            } else if (CertType.list.contains(value)) {
                item.setCertType(text);
            } else if (CertPermission.list.contains(value)) {
                item.setCertPermission(text);
            }

            list.set(position, item);
            adapter.notifyDataSetChanged();

        }

    }

    /**
     * 签发设备
     * 选择框
     * 内置安全芯片、智能薄膜卡、TF卡、联网VHSM、离线VHSM，无默认项
     * <p>
     * 签发容器号
     * 选择框
     * 0.1.2.3.4.6，必填，默认0号
     * <p>
     * 密钥算法
     * 单选
     * SM2,RSA ，默认选择SM2
     * <p>
     * 证书机制
     * 单选
     * 双证，单证，默认选择双证
     * <p>
     * 展示证书类型
     * 选择框
     * 签名证书，加密证书，默认选择签名证书
     *
     * @return
     */
    public TableCertConfig defaultCertConfig() {

        TableCertConfig certConfig = new TableCertConfig();
        certConfig.setPosition(list.size());
        certConfig.setCardType(DEFAULT_CARD_TYPE_TEXT);
        certConfig.setContainerNum(ContainerNum.getDefault());
        certConfig.setAlgType(AlgType.getDefaule());
        certConfig.setCertType(CertType.getDefault());
        certConfig.setCertRule(CertRule.getDefault());
        certConfig.setCertPermission(CertPermission.getDefault());
        return certConfig;
    }

    @Subscribe
    public void handleDeleteConfigDetail(DeleteCertConfigEvent event) {
        list.remove(event.getPosition());
        adapter.notifyDataSetChanged();
        resize();
    }

    private void initView() {

        dividerLive = findViewById(R.id.divider_live);

        connect = findViewById(R.id.connect);
        connect.setOnClickListener(this);

        sAllowUpdate = findViewById(R.id.switch_allow_update);

        exportHint = findViewById(R.id.export_hint);

        // 已导出
        exportSuccess = SharePreferencesUtil.getExportState(context);

        if (exportSuccess) {

            exportHint.setVisibility(View.VISIBLE);

            if (BuildConfig.isAAR) {
                exportHint.setText(R.string.cert_creation_save_success);
            } else {
                exportHint.setText("导出路径：" + path);
            }

        }

        addNewCard = findViewById(R.id.add_new_card);
        addNewCard.setOnClickListener(this);

        export = findViewById(R.id.export);
        export.setOnClickListener(this);

        liveCompanyView = findViewById(R.id.live_company);
        liveCompanyView.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(context, LiveCompany.list);
            }
        });
        liveCompanyResult = findViewById(R.id.live_company_result);

        ocrView = findViewById(R.id.ocr);
        ocrView.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(context, OCRCompany.list);
            }
        });
        ocrResult = findViewById(R.id.ocr_result);

        nfcView = findViewById(R.id.nfc);
        nfcView.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {

                ConfigDialog.show(context, NFCCompany.list);
            }
        });
        nfcResult = findViewById(R.id.nfc_result);

        nfcPortView = findViewById(R.id.nfc_port_view);

        nfcPortResult = findViewById(R.id.nfc_port);

        nfcIPView = findViewById(R.id.nfc_ip_view);

        nfcIPResult = findViewById(R.id.nfc_ip_result);

        layout3rdNServer = findViewById(R.id.layout_3rd_n_server);

        initDefault3rdConfig();

    }

    private void initViewByData() {

        if (serverSettingConfig == null) {
            return;
        }

        liveCompanyResult.setText(serverSettingConfig.getLiveCompany());

        ocrResult.setText(serverSettingConfig.getOcrCompany());

        nfcResult.setText(serverSettingConfig.getNfcCompany());

        nfcIPResult.setText(serverSettingConfig.getNfcServerIP());

        nfcPortResult.setText(serverSettingConfig.getNfcServerPort());

        sAllowUpdate.setChecked(serverSettingConfig.getAllowUpdate().equals(AllowUpdate.AYE));


    }

    private void initDefault3rdConfig() {

//        如果用户在证书申请流程中，选择了标准流程，需要进行活体检测、OCRCompany、NFC配置
        if (procedure.equals(Procedure.STANDARD)) {
//             默认全显示，什么也不做
        } else if (procedure.equals(Procedure.STD_NO_OCR)) {
//            如果选择标准流程（无OCR），需要进行活体检测和NFC配置
            ocrView.setVisibility(View.GONE);
        } else if (procedure.equals(Procedure.STD_NO_NFC)) {
//            如果选择标准流程（无NFC），需要进行活体检测配置
            connect.setVisibility(View.GONE);
            ocrView.setVisibility(View.GONE);
            nfcView.setVisibility(View.GONE);
            nfcIPView.setVisibility(View.GONE);
            nfcPortView.setVisibility(View.GONE);
            dividerLive.setVisibility(View.GONE);
        } else if (procedure.equals(Procedure.PHONE)) {
//            如果选择持证拍照、手机号认证，则不展示身份认证服务配置
            layout3rdNServer.setVisibility(View.GONE);
        } else if (procedure.equals(Procedure.SIMPLIFIED)) {
            layout3rdNServer.setVisibility(View.GONE);
        }

//        活体检测，默认云从
        if (layout3rdNServer.getVisibility() == View.VISIBLE
                && liveCompanyView.getVisibility() == View.VISIBLE) {
            liveCompanyResult.setText(LiveCompany.YUNCONG);
        }

//        OCRCompany，默认云从
        if (layout3rdNServer.getVisibility() == View.VISIBLE
                && ocrView.getVisibility() == View.VISIBLE) {
            ocrResult.setText(OCRCompany.YUNCONG);
        }

//        NFCCompany，默认信大捷安
        if (layout3rdNServer.getVisibility() == View.VISIBLE
                && nfcView.getVisibility() == View.VISIBLE) {
            nfcResult.setText(NFCCompany.XDJA);
        }

    }

    private boolean validBeforeExport() {

        // 标准流程、标准流程无OCR需要校验NFC地址

        if (procedure.equals(Procedure.STANDARD)
                || procedure.equals(Procedure.STD_NO_OCR)
                ) {

            String ip = nfcIPResult.getText().toString();

            if (TextUtils.isEmpty(ip)) {
                ModuleToast.show(context, R.string.cert_creation_config_please_input_nfc_address);
                return false;
            }

            boolean success = AddressUtil.validIP(ip);

            if (!success) {
                ModuleToast.show(context, R.string.cert_creation_config_error_nfc_address);
                return false;
            }

            String port = nfcPortResult.getText().toString();

            if (TextUtils.isEmpty(port)) {
                ModuleToast.show(context, R.string.cert_creation_config_please_input_server_port);
                return false;
            }

            success = AddressUtil.validPort(port);

            if (!success) {
                ModuleToast.show(context, R.string.cert_creation_config_error_server_port);
                return false;
            }

        }

        boolean success = validCertConfig();

        return success;
    }

    /**
     * 校验设备信息是否符合规则
     * 由于是选项，所以不用校验值是否是选项内，只用校验必填就可以
     *
     * @return
     */
    private boolean validCertConfig() {

//        容器号、密钥算法、证书机制、展示证书类型都是有默认值的
//        所以只要校验设备类型不是“请选择”就行

        boolean success = true;

        for (TableCertConfig config : list) {

            if (config.cardType.equals(DEFAULT_CARD_TYPE_TEXT)) {
                success = false;

                ModuleToast.show(context, R.string.cert_creation_config_please_choose_card_type);

                break;
            }

            // 特殊说明：同一类型的安全设备，不能存在相同的容器号，
            // toast提示【同一设备类型，容器号不能相同】

            // 新增约束：【同一设备类型，有且仅有一个容器可申请证书】

            int first = list.indexOf(config);

            int last = list.lastIndexOf(config);

            if (first != last) {
                success = false;

                TableCertConfig config1 = list.get(first);

                TableCertConfig config2 = list.get(last);

                String cardType1 = config1.getCardType();

                String cardType2 = config2.getCardType();

                if (cardType1.equals(CardType.ONLINE_VHSM)
                        && (cardType2.equals(CardType.OFFLINE_VHSM))) {
                    ModuleToast.show(context, "不能同时使用离线VHSM和联网VHSM");
                    break;
                } else if (cardType1.equals(CardType.OFFLINE_VHSM)
                        && (cardType2.equals(CardType.ONLINE_VHSM))
                        ) {
                    ModuleToast.show(context, "不能同时使用离线VHSM和联网VHSM");
                    break;
                } else {

                    if (config1.cardType.equals(config2.cardType)) {
                        if (config1.containerNum == config2.containerNum) {
                            ModuleToast.show(context, R.string.cert_creation_repeat_container_num);
                        } else if (config1.certPermission.equals(CertPermission.APPLY)
                                && config2.certPermission.equals(CertPermission.APPLY)
                                ) {
                            ModuleToast.show(context, R.string.cert_creation_repeat_cert_permission);
                        }
                    }

                }

                break;
            }

        }

        return success;

    }


    private void showExportDialog() {

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(context);

        bindIdentifyDialog.setTitle("导出配置文件");
        bindIdentifyDialog.setMessage("导出前请确认所有信息已准确配置");
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText("取消");
        bindIdentifyDialog.setPositiveButtonText("导出");
        bindIdentifyDialog.setCancelable(true);
        bindIdentifyDialog.setCanceledOnTouchOutside(true);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {

                boolean hasPermission = checkValidPermission(permissions);

                if (!hasPermission) {
                    showInvalidPermissionDialog();
                    return;
                }

                deleteDatabase();

                exportToSDCard();

                bindIdentifyDialog.cancel();
            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.cancel();
            }
        });
    }

    /**
     * 删除表，防止出现多条数据
     */
    private void clearTableValue() {
        // Delete a whole table
        Delete.table(ServerSettingConfig.class);
        Delete.table(TableCertConfig.class);
    }

    private void exportToSDCard() {

        clearTableValue();

        // 保存到数据库（此时数据库仍在私有目录下）

        // 表1
        ServerSettingConfig table = new ServerSettingConfig();

        table.liveCompany = liveCompanyResult.getText().toString();
        table.ocrCompany = ocrResult.getText().toString();
        table.nfcCompany = nfcResult.getText().toString();

        table.ip = serverIP;
        table.port = serverPort;

        table.setVhsm_ip(vhsmServerIP);
        table.setVhsm_port(vhsmServerPort);

        table.nfcServerIP = nfcIPResult.getText().toString();
        table.nfcServerPort = nfcPortResult.getText().toString();

        table.allowUpdate =
                sAllowUpdate.isChecked() ? AllowUpdate.AYE : AllowUpdate.NAY;

        table.procedure = procedure;

        table.projectName = projectName;

        table.save();

        // 表2
        for (TableCertConfig config : list) {
            config.save();
        }

        // 独立版导出把数据库复制到根目录
        // 融合版界面显示保存，点击保存数据库，安全接入自己调用导出接口
        if (!BuildConfig.isAAR) {
            DatabaseManager.getInstance().exportDatabase2Sdcard(context);
            ModuleToast.show(context, R.string.cert_creation_export_success);
        }

        exportHint.setTextColor(context.getResources().getColor(R.color.config_hint));
        exportHint.setVisibility(View.VISIBLE);

        if (BuildConfig.isAAR) {
            exportHint.setText(R.string.cert_creation_save_success);
        } else {
            exportHint.setText("导出路径：" + path);
        }

        // 存储导出成功的状态
        SharePreferencesUtil.saveExportState(context, true);

    }


    /**
     * 弹窗提示用户用户开启权限
     */

    private void showInvalidPermissionDialog() {

        ArrayList<String> list = new ArrayList<>();

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item2));
        }

        String permission = HTMLText.formatPermissionText(this, list);

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(context);

        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                checkoutPermission();
            }

            @Override
            public void doCancel() {
                ConfigStep3Activity.this.finish();
            }
        });


    }

    /**
     * 权限检测（只检测敏感权限即可，其他权限只要在manifest里写入，系统自动赋予）
     */
    @XdjaPermission(permissions = {
            Manifest.permission.WRITE_EXTERNAL_STORAGE,

    })
    private void checkoutPermission() {

    }

    private String[] permissions = new String[]{
            Manifest.permission.WRITE_EXTERNAL_STORAGE
    };

    /**
     * 判断是否所有权限都开启
     *
     * @param permissions
     * @return
     */
    private boolean checkValidPermission(String... permissions) {
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    private void deleteDatabase() {
        File file = new File(path);
        if (file.exists()) {
            ModuleLog.e("db文件已存在，尝试删除");
            boolean success = file.delete();
            ModuleLog.e(success ? "删除成功" : "删除失败，有可能是没有授予存储权限");
        }
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }
}
