package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;

import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import com.xdja.safeclient.certcreation.bean.request.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.RegistIdCardInfo;
import com.xdja.safeclient.certcreation.bean.request.RegisterRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.RegisterResult;
import com.xdja.safeclient.certcreation.callback.HttpArrayResponseCallBack;
import com.xdja.safeclient.certcreation.event.DepartmentEvent;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.ProfessionDepartment;
import com.xdja.safeclient.certcreation.event.ProfessionJobTitle;
import com.xdja.safeclient.certcreation.event.ProfessionPerson;
import com.xdja.safeclient.certcreation.event.ProfessionRank;
import com.xdja.safeclient.certcreation.event.ProfessionType;
import com.xdja.safeclient.certcreation.util.DialogUtil;
import com.xdja.safeclient.certcreation.util.IntentUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OperatorUtil;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.view.ProChooseView;
import com.xdja.safeclient.certcreation.view.ProEditView;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import okhttp3.Call;

/**
 * 完善职业信息
 * Created by zjc on 2018/6/11 0011.
 */
@Route(path = ActivityPath.ACTIVITY_PROFESSION, name = ActivityPath.NAME_PROFESSION)
public class ProfessionActivity extends BaseActivity implements View.OnClickListener {


    //两个电话的对应说明
//    手机-入网电话 - 自己填 - 安全终端使用的手机号，用于机卡绑定
//    办公电话-联系电话 - 不需要自己填，从验证手机页面中取

    private ProEditView pePoliceNum;
    private ProChooseView pcPerson;
    private ProChooseView pcType;
    private ProChooseView pcJobTitle;
    private ProChooseView pcDepartment;
    private ProChooseView pcRank;
    private ProEditView peRuwangPhone;

    private String cardNum;
    private CryptoDevType cardType;
    /**
     * 可以接收验证码的手机号
     */
    private String phoneNum;
    private String id;
    private int sex;
    private String name;

    private Button submit;

    private ArrayList<ProfessionBean> personList = new ArrayList<>();
    private ArrayList<ProfessionBean> typeList = new ArrayList<>();
    private ArrayList<ProfessionBean> rankList = new ArrayList<>();
    private ArrayList<ProfessionBean> jobTitleList = new ArrayList<>();
    private ArrayList<ProfessionDepartment> departmentList = new ArrayList<>();

    Context context;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        setContentView(R.layout.activity_profession);
        super.onCreate(savedInstanceState);

        context = this;

        OttoUtil.register(this);

        Intent intent = getIntent();

        cardNum = IntentUtil.getCardNum(intent);
        cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType(this));
        phoneNum = IntentUtil.getPhone(intent);
        if (TextUtils.isEmpty(phoneNum)) {
            //todo 之后补一个错误提示
            return;
        }
        id = IntentUtil.getID(intent);
        name = IntentUtil.getName(intent);
        sex = IntentUtil.getSex(intent);

        pePoliceNum = (ProEditView) findViewById(R.id.pe_police_num);
        pePoliceNum.setOnClickListener(this);

        pcPerson = (ProChooseView) findViewById(R.id.pc_person);
        pcPerson.setOnClickListener(this);

        pcType = (ProChooseView) findViewById(R.id.pc_type);
        pcType.setOnClickListener(this);

        pcJobTitle = (ProChooseView) findViewById(R.id.pc_job_title);
        pcJobTitle.setOnClickListener(this);

        pcDepartment = (ProChooseView) findViewById(R.id.pc_department);
        pcDepartment.setOnClickListener(this);

        pcRank = (ProChooseView) findViewById(R.id.pc_rank);
        pcRank.setOnClickListener(this);

        peRuwangPhone = (ProEditView) findViewById(R.id.pe_ruwang_phone);
        peRuwangPhone.setOnClickListener(this);

        submit = (Button) findViewById(R.id.submit);
        submit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                submit();
            }
        });

        initList();
    }

    /**
     * 初始化数据
     */
    private void initList() {
        // TODO: 2018/6/15 0015 以下几项请求在获取失败的时候，并未对数据源进行处理，之后需要补上

        // TODO: 2018/6/21 0021 因为获取也是网络请求，所以这个地方是有进度提示的
        // TODO: 2018/6/21 0021 但是因为网络请求本身是异步的，但是现在串行了几个网络请求，之后用RXJava处理下

        //获取人员类型
        service.getPersonType(cardNum, new HttpArrayResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptiopnFailure(Call call, IOException e) {
                ModuleLog.e("获取人员类型异常");
                showRequestError();
            }

            @Override
            public void onsuccessfullresponse(Call call, String response) {
                personList = parseArray(response, new ProfessionBean());
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e("获取人员类型失败：" + baseErrorResponse.toString());
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

        //获取警种信息
        try {
            service.getPoliceClass(cardNum, new HttpArrayResponseCallBack<CommonResponse>() {

                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }

                @Override
                public void onIoExceptiopnFailure(Call call, IOException e) {
                    ModuleLog.e("获取警种类型异常");
                    showRequestError();
                }

                @Override
                public void onsuccessfullresponse(Call call, String response) {
                    typeList = parseArray(response, new ProfessionBean());
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.e("获取警种信息失败");
                }

                @Override
                public void dismissDialog() {
                    dismissLoading();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

        //获取职务信息
        try {
            service.getPosition(cardNum, new HttpArrayResponseCallBack<CommonResponse>() {
                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }

                @Override
                public void onIoExceptiopnFailure(Call call, IOException e) {
                    ModuleLog.e("获取职务信息异常");
                    showRequestError();
                }

                @Override
                public void onsuccessfullresponse(Call call, String response) {
                    jobTitleList = parseArray(response, new ProfessionBean());
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.e("获取职务信息失败：" + baseErrorResponse.toString());
                }

                @Override
                public void dismissDialog() {
                    dismissLoading();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

        //获取级别信息
        try {
            service.getLevel(cardNum, new HttpArrayResponseCallBack<CommonResponse>() {

                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }


                @Override
                public void onIoExceptiopnFailure(Call call, IOException e) {
                    ModuleLog.e("获取级别信息异常");
                    showRequestError();
                }

                @Override
                public void onsuccessfullresponse(Call call, String response) {
                    rankList = parseArray(response, new ProfessionBean());
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.d("获取级别信息失败：" + baseErrorResponse.toString());
                }

                @Override
                public void dismissDialog() {
                    dismissLoading();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }


        //获取部门信息
        service.getDepartment(cardNum, new HttpArrayResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptiopnFailure(Call call, IOException e) {
                ModuleLog.e("获取部门信息异常");
                showRequestError();
            }

            @Override
            public void onsuccessfullresponse(Call call, String response) {
                departmentList = parseArray(response, new ProfessionDepartment());
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e("获取部门信息失败：" + baseErrorResponse.toString());
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private void submit() {

        final RegisterRequest request = buildRegisterRequest();
        //为null说明至少有一项必填项未填写
        if (request == null) {
            return;
        }

        showLoading();

        try {
            service.register(request, cardNum, new HttpResponseCallBack<CommonResponse>() {

                @Override
                public void onOtherException(Exception e) {
                    e.printStackTrace();
                }


                @Override
                public void onIoExceptionFailure(Call call, IOException e) {
                    showRequestError();
                    dismissLoading();
                }

                @Override
                public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                    ModuleLog.d(commonResponse);
                    //RESULT_OK代表实体注册成功，接下来进行发证请求，所以当前的进度条不再取消
                    if (!commonResponse.equals(RegisterResult.RESULT_OK)) {
                        dismissLoading();
                    }
                    handleResult(commonResponse);
                }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    ModuleLog.e("注册失败" + baseErrorResponse.toString());
                    if (baseErrorResponse.getMessage().equals("user_register_failed")) {
                        ModuleToast.show(context, R.string.cert_creation_register_failed);
                    }
                    dismissLoading();
                }

                @Override
                public void dismissDialog() {

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 构造PAMS注册的request
     *
     * @return
     */
    private RegisterRequest buildRegisterRequest() {

        Intent intent = getIntent();

        RegisterRequest request = new RegisterRequest();

        RegistIdCardInfo id = new RegistIdCardInfo();

        id.setName(IntentUtil.getName(intent));
        id.setSex(IntentUtil.getSex(intent));
        id.setIdNum(IntentUtil.getID(intent));

        //警号
        String alarmNo = pePoliceNum.getText();
        if (TextUtils.isEmpty(alarmNo)) {
            //提示警号未选择
            ModuleToast.show(context, R.string.cert_creation_not_null_police_num);
            return null;
        } else {
            id.setAlarmNo(alarmNo);
        }

        ProfessionBean person = (ProfessionBean) pcPerson.getTag();
        if (person == null) {
            ModuleToast.show(context, R.string.cert_creation_not_null_profession_person);
            //提示人员类型未选择
            return null;
        } else {
            id.setPersonType(person.getCode());
        }

        ProfessionBean type = (ProfessionBean) pcType.getTag();
        if (type == null) {
            //提示警种未选择
            ModuleToast.show(context, R.string.cert_creation_not_null_profession_type);
            return null;
        } else {
            id.setPoliceClass(type.getCode());
        }

        ProfessionBean jobTitle = (ProfessionBean) pcJobTitle.getTag();
        if (jobTitle == null) {
            //提示职务未选择
            ModuleToast.show(context, R.string.cert_creation_not_null_profession_job_title);
            return null;
        } else {
            id.setPosition(jobTitle.getCode());
        }

        ProfessionDepartment department = (ProfessionDepartment) pcDepartment.getTag();
        //提示部门未选择
        if (department == null) {
            ModuleToast.show(context, R.string.cert_creation_not_null_profession_department);
            return null;
        } else {
            id.setDepartment(department.getCode());
        }

        ProfessionBean rank = (ProfessionBean) pcRank.getTag();
        if (rank == null) {
            //提示级别未选择
            ModuleToast.show(context, R.string.cert_creation_not_null_profession_rank);
            return null;
        } else {
            id.setLevel(rank.getCode());
        }

        //1为默认值，非必填
        id.setPersonState("1");
        //0为默认值，非必填
        id.setFlag("0");

        request.setIdCardInfo(id);

        ChipInfo chip = new ChipInfo();
        //运营商
        chip.setCommType(OperatorUtil.getType(context));

        //按照现在的要求，第一步填写的手机号就是联系电话（可以接收短信的那个手机号），所以不用用户继续填写了
        chip.setPhone(phoneNum);
        request.setChipInfo(chip);

        //入网电话需要自己填
        String phone = peRuwangPhone.getText();

        boolean valid = !TextUtils.isEmpty(phone);
        if (!valid) {
            //提示手机号不能为空
            ModuleToast.show(context, R.string.cert_creation_not_null_ruwang_phone);
            return null;
        }
        chip.setOfficePhone(phone);

        //默认值为空串，非必填
        request.setBasic("");

        return request;
    }


    @SuppressWarnings("unchecked")
    private ArrayList parseArray(String json, Object object) {
        JSONArray array = JSON.parseArray(json);

        if (TextUtils.isEmpty(json) || array == null) {
            //连接不到UAS的时候直接返回空的json
            // TODO: 2018/6/21 0021 之后补充个错误提示
            return new ArrayList();
        }

        ArrayList<Object> list = new ArrayList<>();
        for (int i = 0; i < array.size(); i++) {
            list.add(JSON.parseObject(array.get(i).toString(), object.getClass()));
        }

        return list;
    }

    /**
     * 查询子部门
     *
     * @param original 所需要查询的集合
     * @param id       父部门的ID
     * @return
     */
    private List<ProfessionDepartment> findSubDepartment(List<ProfessionDepartment> original, String id) {

        // TODO: 2018/6/13 0013 当前遍历寻找子串的方法效率不算特别高，之后待优化

        ArrayList<ProfessionDepartment> list = new ArrayList<>();
        for (ProfessionDepartment department : original) {
            if (id == null) {
                //父部门id为null，意味着寻找的是第一级部门目录
                if (department.getPId() == null) {
                    list.add(department);
                }
            } else {
                //查找所有与父部门ID相同的部门，放入到新的集合中
                String pid = department.getPId();
                if (id.equals(pid)) {
                    list.add(department);
                }
            }
        }
        return list;
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        OttoUtil.unRegister(this);
    }

    @Subscribe
    public void handleProfessionType(ProfessionType type) {
        ProfessionBean value = typeList.get(type.getPosition());
        pcType.setRightText(value.getName());
        pcType.setTag(value);
    }

    @Subscribe
    public void handleProfessionPerson(ProfessionPerson person) {
        ProfessionBean value = personList.get(person.getPosition());
        pcPerson.setRightText(value.getName());
        pcPerson.setTag(value);
    }

    @Subscribe
    public void handleProfessionRank(ProfessionRank rank) {
        ProfessionBean value = rankList.get(rank.getPosition());
        pcRank.setRightText(value.getName());
        pcRank.setTag(value);
    }

    @Subscribe
    public void handleJobTitle(ProfessionJobTitle jobTitle) {
        ProfessionBean value = jobTitleList.get(jobTitle.getPosition());
        pcJobTitle.setRightText(value.getName());
        pcJobTitle.setTag(value);
    }

    @Subscribe
    public void handleDepartment(DepartmentEvent event) {
        //1，点击后，将自身排除，余下的结合作为下一次查找的源数据
        List<ProfessionDepartment> all = event.getRest();

        //2，获得上一次点击的数据
        ProfessionDepartment current = event.getCurrent();

        //3，遍历剩余集合，找出这个种类下剩下的部门
        List<ProfessionDepartment> rest = findSubDepartment(all, current.getId());

        //4，剩余部门（子部门）为空，说明当前选择是最后一个级别
        //不为空，则继续弹出列表继续选择
        if (rest.size() != 0) {
            DialogUtil.popSpinnerList(this, all, rest);
        } else {
            pcDepartment.setRightText(current.getName());
            pcDepartment.setTag(current);
        }

    }

    private void handleResult(CommonResponse response) {

        String result = response.getResult();
        if (result.equals(RegisterResult.RESULT_OK)) {
//            现在注册成功之后直接调用发证，不再Toast提示了
//            ModuleToast.show(context, R.string.register_success);
           /* VerifyInfoSelfieRequest request = ApplyCertUtil.buildRequest(id, name, phoneNum, sex, cardType);
            ApplyCertUtil.start(request, cardType, cardNum, new ApplyCertUtil.WhatHappen() {
                @Override
                public void showDialog() {
                    ProfessionActivity.this.showLoading();
                }

                @Override
                public void cancelDialog() {
                    ProfessionActivity.this.dismissLoading();
                }

                @Override
                public void IOError() {
                    ProfessionActivity.this.dismissLoading();
                    showRequestError();
                }

                @Override
                public void handleResult(CommonResponse response) {
                    ApplyCertUtil.handleSuccessResult(ProfessionActivity.this, response);
                }

                @Override
                public void handleError(BaseErrorResponse baseErrorResponse) {
                    // TODO: 2018/12/18 0018 这个地方要获取下卡号
                    OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(cardType, "", null, baseErrorResponse));
                }
            });
*/

        } else {
            ModuleToast.show(context, new RegisterResult().getErrText(result));
        }

    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }

    @Override
    public void onClick(View view) {
        int id = view.getId();
        if (id == R.id.pc_person) {
            DialogUtil.popSpinnerList(this, personList, DialogUtil.PERSON);
        } else if (id == R.id.pc_type) {
            DialogUtil.popSpinnerList(this, typeList, DialogUtil.TYPE);
        } else if (id == R.id.pc_rank) {
            DialogUtil.popSpinnerList(this, rankList, DialogUtil.RANK);
        } else if (id == R.id.pc_job_title) {
            DialogUtil.popSpinnerList(this, jobTitleList, DialogUtil.JOB_TITLE);
        } else if (id == R.id.pc_department) {
            DialogUtil.popSpinnerList(this, departmentList, findSubDepartment(departmentList, null));
        }
    }
}
