package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;

import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import okhttp3.Call;

/**
 * Created by jff on 2018/6/29.
 */
@Route(path = ActivityPath.ACTIVITY_REASON, name = ActivityPath.NAME_REASON)
public class ReasonActivity extends BaseActivity {

    /**
     * 废弃证书
     */
    public static final int REVOKE = 2;

    /**
     * 解冻证书
     */
    public static final int RECOVERY = 1;

    private EditText reasonET;
    private Button submit;

    public CertDetailInfo certDetailInfo;

    @Autowired(name = "chipBean")
    public ChipBean chipBean;

    CryptoDevType cardType;

    @Autowired(name = ActivityParam.CONTAINER_NUM)
    public int containerNum;

    public String certRule;

    @Autowired(name = ActivityParam
            .CERT_TYPE)
    public String certType;

    @Autowired(name = "cardId")
    public String cardID;

    int type;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_reason);

        ARouter.getInstance().inject(this);

        certDetailInfo = chipBean.getCertBean();

        cardType = CryptoDevTypeUtil.formatType(chipBean.getType());

        type = getIntent().getIntExtra("type", 0);
        if (type == REVOKE) {

        } else {

        }

        certRule = AppConfig.getInstance().getCertConfig()
                .getCertRule(cardType, containerNum);

//        ModuleToast.show(this, chipBean.toString());

        reasonET = (EditText) findViewById(R.id.reason);
        reasonET.addTextChangedListener(textWatcher);
        reasonET.setFilters(EditTextUtil.getDisableEmojFilter());

        submit = (Button) findViewById(R.id.submit);
        final Context context = this;
        submit.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                    if (reasonET.getText().length() > 0) {
                        ModuleLog.e("点击撤销");
                        hideSoft();
                        revokeCert();
                    } else {
                        ModuleToast.show(context, R.string.cert_creation_reason_input);
                    }
                }
        });


    }

    InputFilter inputFilter = new InputFilter() {

        // 不允许输入表情
        Pattern pattern = Pattern
                .compile("[^\\u0000-\\uFFFF]");

        // 只允许输入中英文和汉字
//        Pattern pattern = Pattern.compile("[^a-zA-Z0-9\\u4E00-\\u9FA5_]");

        @Override
        public CharSequence filter(CharSequence charSequence, int i, int i1, Spanned spanned, int i2, int i3) {
            Matcher matcher = pattern.matcher(charSequence);
            if (!matcher.find()) {
                return null;
            } else {
                return "";
            }

        }
    };

    private void revokeCert() {

        // TODO: 2018/12/20 0020 原来的Loading和默认的loading不太一样
        showLoading();

        // TODO: 2018/12/20 0020 判断网络状况，如果没有网络连接的话的话直接提示

        RevokedCertRequest request = buildRequest();
        if (request == null) {
            return;
        }

        service.revokedCert(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
//                ModuleLog.e("注销异常： " + e.getMessage());
                //网络异常，请重试
                dismissLoading();
                ModuleToast.show(ReasonActivity.this, R.string.net_disconnected_text);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();

                if (result.equals("0")) {
                    chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                } else if (result.equals("1")) {//撤销申请成功
                    chipBean.setState(CertState.AGREE_REVOKE);
                } else if (result.equals("2")) {//撤销被拒绝
                    chipBean.setState(CertState.REJECT_REVOKE);
                } else if (result.equals("5")) {
                    // todo 证书被冻结
                } else if (result.equals("6")) {
                    //todo 证书过期
                }

                BusProvider.getMainProvider().post(chipBean);
                OttoUtil.postRevokeResult(chipBean, reasonET.getText().toString());

                finish();

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                String message = baseErrorResponse.getMessage();
                    ModuleLog.e("注销失败： " + baseErrorResponse.getErrCode());
//                handleErrorResponse(baseErrorResponse.getErrCode());
//                ModuleToast.show(ReasonActivity.this, baseErrorResponse.getMessage());
                ModuleToast.show(ReasonActivity.this, OkNetError.userError(context, baseErrorResponse.getErrCode()));
                dismissDialog();
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private RevokedCertRequest buildRequest() {

        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        String sn;
        if (certDetailInfo != null) {
            if (certType.equals(CertType.SIGNING) || certRule.equals(CertRule.SINGLE)) {
                sn = certDetailInfo.sn;
            } else {
                sn = DeviceWrapper.getInstance().readCertFromContainer(cardType, containerNum, (CertType.SIGNING)).sn;
            }
        } else {
            ModuleLog.e("sn为空");
            return null;

        }
        info.setSn(sn);
        // TODO: 2018/12/20 0020 原因是否需要增加判空
        info.setReason(reasonET.getText().toString());
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(cardType, containerNum, info.toString());
        if (sign != null) {
            if (sign.startsWith("errorCode")) {//签名时验证默认PIN码失败
                showPinDialog();
                return null;
            } else {
                revokeRequest.setSign(sign);
                ModuleLog.e("revoke sign " + sign + " 原文： " + info.toString());
            }
        } else {
            ModuleToast.show(context, R.string.cert_creation_signFail);
        }

        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));
        return revokeRequest;

    }

    private PinDialog pinDialog = null;

    /**
     * 显示输入pin码对话框
     */
    private void showPinDialog() {
        pinDialog = new PinDialog(context, cardType);
        pinDialog.show();

    }


    private void hideSoft() {
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        if (imm != null) {
            imm.hideSoftInputFromWindow(getWindow().getDecorView().getWindowToken(), 0);
        }
    }


    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_revoke_cert;
    }

    private TextWatcher textWatcher = new TextWatcher() {
        private CharSequence temp;
        private int selectionStart;
        private int selectionEnd;

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            temp = charSequence;
        }

        @Override
        public void afterTextChanged(Editable editable) {
            selectionStart = reasonET.getSelectionStart();
            selectionEnd = reasonET.getSelectionEnd();

            if (temp.length() > 40) {
                ModuleToast.show(ReasonActivity.this, R.string.cert_creation_reason_text_length);
                editable.delete(selectionStart - 1, selectionEnd);
                int tempSelection = selectionEnd;
                reasonET.setText(editable);
                reasonET.setSelection(tempSelection);
            }
        }
    };


}
