package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.xdja.safeclient.certcreation.R;
import com.xdja.a3rdplugin.demo.ConfigBean;

import java.util.List;

/**
 * Description:弹框Adapter
 * Created by zjc on 2017/2/8 0008.
 */
public class ConfigListAdapter extends RecyclerView.Adapter<ConfigListAdapter.ViewHolder> {

    private Context context;

    private List<? extends ConfigBean> dataSource;

    private int currentPosition = -1;

    ConfigBean selectedItem;

    OnItemClickListener onItemClickListener;

    public int position;

    public ConfigListAdapter(Context context) {
        this.context = context;
    }

    public ConfigListAdapter(Context context, int position) {
        this.context = context;
        this.position = position;
    }

    public int getPosition() {
        return position;
    }

    public void setDataSource(List<? extends ConfigBean> dataSource) {
        this.dataSource = dataSource;
        notifyDataSetChanged();
    }

    public void setSelectedItem(ConfigBean selectedItem) {
        this.selectedItem = selectedItem;
    }

    public ConfigBean getSelectedItem() {
        return dataSource.get(currentPosition);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(context).inflate(R.layout.dialog_item, null));
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        ConfigBean bean = dataSource.get(position);
        String text = bean.getContent();
        holder.name.setText(text);

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                currentPosition = position;
                if (onItemClickListener != null) {
                    onItemClickListener.onItemSelected(currentPosition);
                }

            }
        });

    }

    @Override
    public int getItemCount() {
        return dataSource.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {

        View layout;

        TextView name;

        public ViewHolder(View itemView) {
            super(itemView);
            layout = itemView.findViewById(R.id.layout);
            name = (TextView) itemView.findViewById(R.id.name);
        }
    }

    public interface OnItemClickListener {
        void onItemSelected(int position);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }
}
