package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;

import java.util.List;

/**
 * Description:弹框Adapter
 * Created by zjc on 2017/2/8 0008.
 */
public class ProfessionListAdapter extends RecyclerView.Adapter<ProfessionListAdapter.ViewHolder> {

    private Context context;

    private List<? extends ProfessionBean> dataSource;

    private int currentPosition = -1;

    ProfessionBean selectedItem;

    OnItemClickListener onItemClickListener;


    public ProfessionListAdapter(Context context) {
        this.context = context;
    }

    public void setDataSource(List<? extends ProfessionBean> dataSource) {
        this.dataSource = dataSource;
        notifyDataSetChanged();
    }

    public void setSelectedItem(ProfessionBean selectedItem) {
        this.selectedItem = selectedItem;
    }

    public ProfessionBean getSelectedItem() {
        return dataSource.get(currentPosition);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(context).inflate(R.layout.dialog_item, null));
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        ProfessionBean state = dataSource.get(position);
        if (!TextUtils.isEmpty(String.valueOf(state.getId()))) {
            String text = state.getName();
            holder.name.setText(text);

        } else {
        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                currentPosition = position;
                if (onItemClickListener != null) {
                    onItemClickListener.onItemSelected(currentPosition);
                }

            }
        });

    }

    @Override
    public int getItemCount() {
        return dataSource.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {

        View layout;

        TextView name;

        public ViewHolder(View itemView) {
            super(itemView);
            layout = itemView.findViewById(R.id.layout);
            name = (TextView) itemView.findViewById(R.id.name);
        }
    }

    public interface OnItemClickListener {
        void onItemSelected(int position);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }
}
