package com.xdja.safeclient.certcreation.bean;

import android.content.Context;

import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.config.Procedure;

/**
 * 错误码定义合集
 * Created by yangpeng on 2018/4/21.
 */

public class OkNetError {

    //0X0004	missing_required_parameters	缺少必要请求参数
    public static final String MISSING_REQUIRED_PARAMETERS = "missing_required_parameters";
    public static final String MISSING_REQUIRED_PARAMETERS_CODE = String.valueOf(0x0004);

    //0X0005	illegal_request_parameter	非法请求参数
    public static final String ILLEGAL_REQUEST_PARAMETER = "illegal_request_parameter";
    public static final String ILLEGAL_REQUEST_PARAMETER_CODE = String.valueOf(0X0005);

    //0x0009	server_internal_exception	服务器内部异常
    public static final String SERVER_INTERNAL_EXCEPTION = "server_internal_exception";
    public static final String SERVER_INTERNAL_EXCEPTION_CODE = String.valueOf(0x0009);

    //0x0010	request_method_not_supported	请求方法不支持
    public static final String REQUEST_METHOD_NOT_SUPPORTED = "request_method_not_supported";
    public static final String REQUEST_METHOD_NOT_SUPPORTED_CODE = String.valueOf(0x0010);

    //0x0011	parameters_sign_verify_failed	参数验签失败
    public static final String PARAMETERS_SIGN_VERIFY_FAILED = "parameters_sign_verify_failed";
    public static final String PARAMETERS_SIGN_VERIFY_FAILED_CODE = String.valueOf(0x0011);


    //0x1001	id_card_resolve_failed	身份证照片解析失败
    public static final String ID_CARD_RESOLVE_FAILED = "id_card_resolve_failed";
    public static final String ID_CARD_RESOLVE_FAILED_CODE = String.valueOf(0x1001);

    //0x1021	face_auth_failed	实体认证失败
    public static final String FACE_AUTH_FAILED = "face_auth_failed";
    public static final String FACE_AUTH_FAILED_CODE = String.valueOf(0x1021);

    //0x1023	identity_not_police	身份证号在警员库中不存在
    public static final String IDENTIFY_NOT_POLICE = "identity_not_police";
    public static final String IDENTIFY_NOT_POLICE_CODE = String.valueOf(0x1023);

    //0x1024	identity_check_repeat	请勿重复提交实体认证
    public static final String IDENTITY_CHECK_REPEAT = "identity_check_repeat";
    public static final String IDENTITY_CHECK_REPEAT_CODE = String.valueOf(0x1024);

    //0x1025	card_type_error	卡类型错误
    public static final String CARD_TYPE_ERROR = "card_type_error";
    public static final String CARD_TYPE_ERROR_CODE = String.valueOf(0x1025);

    //0x1026	license_limit	License达到最大数量
    public static final String LICENSE_LIMIT = "license_limit";
    public static final String LICENSE_LIMIT_CODE = String.valueOf(0x1026);

    //0x1027	caAlg_error	不支持的算法类型
    public static final String CAALG_ERROR = "caAlg_error";
    public static final String CAALG_ERROR_CODE = String.valueOf(0x1027);

    //0x1028	identity_expire	身份证过期
    public static final String IDENTITY_EXPIRE = "identity_expire";
    public static final String IDENTITY_EXPIRE_CODE = String.valueOf(0x1028);

    //0x1029	card_identity_not_same	卡和身份证不是对应
    public static final String CARD_IDENTITY_NOT_SAME = "card_identity_not_same";
    public static final String CARD_IDENTITY_NOT_SAME_CODE = String.valueOf(0x1029);

    //0x1030	phone_not_valid_pams	phone_not_valid_pams
    public static final String PHONE_NOT_VALID_PAMS = "phone_not_valid_pams";
    public static final String PHONE_NOT_VALID_PAMS_CODE = String.valueOf(0x1030);

    //0x1031	not_match_header_img	没有对应的头像
    public static final String NOT_MATCH_HEADER_IMG = "not_match_header_img";
    public static final String NOT_MATCH_HEADER_IMG_CODE = String.valueOf(0x1031);

    //0x1032	not_reality_header_img	不是真实的自拍图像
    public static final String NOT_REALITY_HEADER_IMG = "not_reality_header_img";
    public static final String NOT_REALITY_HEADER_IMG_CODE = String.valueOf(0x1032);

    //0x1033	one_card_type_one_cert	一个用户一个芯片类型只能有一个设备
    public static final String ONE_CARD_TYPE_ONE_CERT = "one_card_type_one_cert";
    public static final String ONE_CARD_TYPE_ONE_CERT_CODE = String.valueOf(0x1033);


    //0x1034	one_person_one_cert	一个用户只能有一个证书
    public static final String ONE_PERSON_ONE_CERT = "one_person_one_cert";
    public static final String ONE_PERSON_ONE_CERT_CODE = String.valueOf(0x1034);

    //0x1035	no_authority	没有操作权限
    public static final String NO_AUTHORITY = "no_authority";
    public static final String NO_AUTHORITY_CODE = String.valueOf(0x1035);

    //0x1036   vhsm 同步人员信息失败
    public static final String VHSM_IMPORT_PERSON_DEVICE_ERROR = "vhsm_import_person_device_error";
    public static final String VHSM_IMPORT_PERSON_DEVICE_ERROR_CODE = String.valueOf(0x1036);

    //0x1037 no_activation设备未启用
    public static final String DEVICE_NO_ACTIVATION = "no_activation";
    public static final String DEVICE_NO_ACTIVATION_CODE = String.valueOf(0x1037);

    //0x1041	photo_identity_fail 	认证失败
    public static final String PHOTO_IDENTITY_FAIL = "photo_identity_fail";
    public static final String PHOTO_IDENTITY_FAIL_CODE = String.valueOf(0x1041);

    //0x1042	not_found_check_info	未找到认证信息
    public static final String NOT_FOUND_CHECK_INFO = "not_found_check_info";
    public static final String NOT_FOUND_CHECK_INFO_CODE = String.valueOf(0x1042);


    //0x1061	card_cert_exist	卡号对应的证书存在
    public static final String CARD_CERT_EXIST = "card_cert_exist";
    public static final String CARD_CERT_EXIST_CODE = String.valueOf(0x1061);

    //0x1062	P10_fromat_error	p10格式有问题
    public static final String P10_FROMAT_ERROR = "P10_fromat_error";
    public static final String P10_FROMAT_ERROR_CODE = String.valueOf(0x1062);

    //0x1063	identity_info_error	没有实体认证信息
    public static final String IDENTITY_INFO_ERROR = "identity_info_error";
    public static final String IDENTITY_INFO_ERROR_CODE = String.valueOf(0x1063);

    //0x1064	cert_issue_frequently	证书申请过于频繁
    public static final String CERT_ISSUE_FREQUENTLY = "cert_issue_frequently";
    public static final String CERT_ISSUE_FREQUENTLY_CODE = String.valueOf(0x1064);

    //0x1065	identity_check_refuse	实体认证拒绝
    public static final String IDENTITY_CHECK_REFUSE = "identity_check_refuse";
    public static final String IDENTITY_CHECK_REFUSE_CODE = String.valueOf(0x1065);

    //0x1066	identity_check_waiting	正在实体认证
    public static final String IDENTITY_CHECK_WAITING = "identity_check_waiting";
    public static final String IDENTITY_CHECK_WAITING_CODE = String.valueOf(0x1066);

    //0x1067	cert_issue_faile	证书签发失败
    public static final String CERT_ISSUE_FAILE = "cert_issue_faile";
    public static final String CERT_ISSUE_FAILE_CODE = String.valueOf(0x1067);

    //0x1071	cert_updates_fail 	证书更新/延期失败
    public static final String CERT_UPDATES_FAIL = "cert_updates_fail";
    public static final String CERT_UPDATES_FAIL_CODE = String.valueOf(0x1071);

    //0x1072	cert_update_frequently	证书更新申请过于频繁
    public static final String CERT_UPDATE_FREQUENTLY = "cert_update_frequently";
    public static final String CERT_UPDATE_FREQUENTLY_CODE = String.valueOf(0x1072);

    //0x1092	cert_status_normal	证书状态正常
    public static final String CERT_STATUS_NORMAL = "cert_status_normal";
    public static final String CERT_STATUS_NORMAL_CODE = String.valueOf(0x1092);

    //0x1093	cert_freeze_frequently	证书解冻申请过于频繁
    public static final String CERT_FREEZE_FREQUENTLY = "cert_freeze_frequently";
    public static final String CERT_FREEZE_FREQUENTLY_CODE = String.valueOf(0x1093);


    //0x10a1	cert_not_exist	cert_not_exist
    public static final String CERT_NOT_EXIST = "cert_not_exist";
    public static final String CERT_NOT_EXIST_CODE = String.valueOf(0x10a1);

    //0x10a2	cert_is_revoke	证书已经是撤销状态
    public static final String CERT_IS_REVOKE = "cert_is_revoke";
    public static final String CERT_IS_REVOKE_CODE = String.valueOf(0x10a2);

    //0x10a3	cert_revoke_fail	证书注销失败
    public static final String CERT_REVOKE_FAIL = "cert_revoke_fail";
    public static final String CERT_REVOKE_FAIL_CODE = String.valueOf(0x10a3);

    //0x10a4	cert_status_other 	证书状态异常
    public static final String CERT_STATUS_OTHER = "cert_status_other";
    public static final String CERT_STATUS_OTHER_CODE = String.valueOf(0x10a4);

    //0x10a5	app_time_exception	时间异常
    public static final String APP_TIME_EXCEPTION = "app_time_exception";
    public static final String APP_TIME_EXCEPTION_CODE = String.valueOf(0x16a5);

    //0x10a5	not_exist_info	卡信息不存在
    public static final String NOT_EXIST_INFO = "not_exist_info";
    public static final String NOT_EXIST_INFO_CODE = String.valueOf(0x10a5);

    //0x10a6	client_server_cert_not_same	 客户端没有证书，但是pams上有状态正常的证书,请联系管理员
    public static final String CLIENT_SERVER_CERT_NOT_SAME = "client_server_cert_not_same";
    public static final String CLIENT_SERVER_CERT_NOT_SAME_CODE = String.valueOf(0x10a6);

    public static final String CERT_UNLOCK_FAILED = "cert_status_other";
    public static final String CERT_UNLOCK_FAILED_CODE = String.valueOf(0x1091);

    public static final String CERT_UPDATES_FREEZE_FAIL = "cert_updates_freeze_fail";
    public static final String CERT_UPDATES_FERRZE_FAIL_CODE = String.valueOf(0x2001);

    public static final String CHIP_NOT_USER_INFO = "chip_not_user_info";
    public static final String CHIP_NOT_USER_INFO_CODE = String.valueOf(0x3001);

    public static final String CERT_HAS_FREEZE = "cert_has_freeze";
    public static final String CERT_HAS_FREEZE_CODE = String.valueOf(0x2002);


    /**
     * 处理服务器返回的错误码
     *
     * @param errorCode
     */
    public static String handleErrorCodeToMsg(Context context, String errorCode) {
        return userError(context, errorCode);
    }

    /**
     * @param errorCode 十进制错误码
     * @return 十六进制错误码，总位数为4位，例如0009、10a6
     */
    public static String toHex(String errorCode) {
        String hex = Integer.toHexString(Integer.parseInt(errorCode));
        return fill(hex);
    }

    /**
     * 将位数不足4位的错误码前面补足0
     *
     * @param errorCode
     * @return
     */
    private static String fill(String errorCode) {
        int num = 4 - errorCode.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; i++) {
            sb.append("0");
        }
        sb.append(errorCode);
        return sb.toString();
    }

    /**
     * 将错误码转换成用户提示
     *
     * @param context
     * @param errorCode 错误码
     * @return
     */
    public static String userError(Context context, String errorCode) {
        // 系统原因用户无法识别和处理

        try {
            if (errorCode.equals(MISSING_REQUIRED_PARAMETERS_CODE)
                    || errorCode.equals(ILLEGAL_REQUEST_PARAMETER_CODE)
                    || errorCode.equals(SERVER_INTERNAL_EXCEPTION_CODE)
                    || errorCode.equals(REQUEST_METHOD_NOT_SUPPORTED_CODE)
                    || errorCode.equals(PARAMETERS_SIGN_VERIFY_FAILED_CODE)
                    || errorCode.equals(ID_CARD_RESOLVE_FAILED_CODE)
                    || errorCode.equals(PHOTO_IDENTITY_FAIL_CODE)
                    || errorCode.equals(NOT_FOUND_CHECK_INFO_CODE)
                    || errorCode.equals(FACE_AUTH_FAILED_CODE)
                    || errorCode.equals(CERT_ISSUE_FAILE_CODE)
                    || errorCode.equals(CERT_STATUS_OTHER_CODE)
                    || errorCode.equals(IDENTITY_INFO_ERROR_CODE)
                    || errorCode.equals(P10_FROMAT_ERROR_CODE)
                    || errorCode.equals(CERT_REVOKE_FAIL_CODE)
                    || errorCode.equals(CAALG_ERROR_CODE)
                    || errorCode.equals(CARD_TYPE_ERROR_CODE)
                    || errorCode.equals(CERT_UNLOCK_FAILED_CODE)
                    || errorCode.equals(CERT_UPDATES_FAIL_CODE)
                    || errorCode.equals(CERT_UPDATES_FERRZE_FAIL_CODE)
                    ) {
                return String.format(context.getString(R.string.cert_creation_server_error), toHex(errorCode));
            } else if (errorCode.equals(CERT_NOT_EXIST_CODE) || errorCode.equals(NOT_EXIST_INFO_CODE)) {
                return String.format(context.getString(R.string.cert_creation_cert_not_exist_show), toHex(errorCode));
            }
            //发证中心原因用户可识别需要联系管理员处理

            else if (errorCode.equals(IDENTIFY_NOT_POLICE_CODE)) {

                String procedure =
                        AppConfig.getInstance().getServerSettingConfig().getProcedure();

                if (!procedure.equals(Procedure.PHONE)) {
                    return context.getString(R.string.cert_creation_identity_not_police_user);
                } else {
                    return context.getString(R.string.cert_creation_identity_not_phone_user);
                }
            } else if (errorCode.equals(NOT_MATCH_HEADER_IMG_CODE)) {
                return context.getString(R.string.cert_creation_not_match_header_img_user);
            } else if (errorCode.equals(LICENSE_LIMIT_CODE)) {
                return context.getString(R.string.cert_creation_license_limit_user);
            } else if (errorCode.equals(CARD_CERT_EXIST_CODE)
                    || errorCode.equals(CLIENT_SERVER_CERT_NOT_SAME_CODE)
                    || errorCode.equals(CARD_IDENTITY_NOT_SAME_CODE)) {
                return String.format(context.getString(R.string.cert_creation_device_occupied), toHex(errorCode));
            } else if (errorCode.equals(CHIP_NOT_USER_INFO_CODE)) {
                return context.getString(R.string.cert_creation_chip_not_user_info);
            }

            //用户原因用户可识别并可根据提示进行处理


            else if (errorCode.equals(IDENTITY_CHECK_REPEAT_CODE) || errorCode.equals(IDENTITY_CHECK_WAITING_CODE)) {
                return context.getString(R.string.cert_creation_apply_should_be_only_once);
            } else if (errorCode.equals(ONE_CARD_TYPE_ONE_CERT_CODE)) {
                return context.getString(R.string.cert_creation_one_person_one_cardType_one_cert);
            } else if (errorCode.equals(NOT_REALITY_HEADER_IMG_CODE)) {
                return context.getString(R.string.cert_creation_not_reality_header_img_user);
            } else if (errorCode.equals(IDENTITY_EXPIRE_CODE)) {
                return context.getString(R.string.cert_creation_identity_expire_user);
            } else if (errorCode.equals(CERT_ISSUE_FREQUENTLY_CODE)
                    //                    || errorCode.equals(CERT_UPDATE_FREQUENTLY_CODE)
                    || errorCode.equals(CERT_FREEZE_FREQUENTLY_CODE)) {
                return String.format(context.getString(R.string.cert_creation_operate_frequently), toHex(errorCode));
            } else if (errorCode.equals(CERT_IS_REVOKE_CODE)) {
                return context.getString(R.string.cert_creation_cert_is_revoke_user);
            } else if (errorCode.equals(CERT_HAS_FREEZE_CODE)) {
                return context.getString(R.string.cert_creation_cert_has_freeze_code);
            } else if (errorCode.equals(APP_TIME_EXCEPTION_CODE)) {
                return context.getString(R.string.cert_creation_app_time_exception_user);
            }

            // 其它
            else if (errorCode.equals(PHONE_NOT_VALID_PAMS_CODE)) {
                return context.getString(R.string.cert_creation_phone_not_valid_pams);
            } else if (errorCode.equals(IDENTITY_CHECK_REFUSE_CODE)) {
                return context.getString(R.string.cert_creation_identity_check_refuse);
            } else if (errorCode.equals(CERT_STATUS_NORMAL_CODE)) {
                return context.getString(R.string.cert_creation_cert_status_normal);
            } else if (errorCode.equals(NO_AUTHORITY_CODE)) {
                return context.getString(R.string.cert_creation_no_authority);
            } else if (errorCode.equals(ONE_PERSON_ONE_CERT_CODE)) {
                return context.getString(R.string.cert_creation_one_person_one_cert);
            } else if (errorCode.equals(VHSM_IMPORT_PERSON_DEVICE_ERROR_CODE)) {
                return context.getString(R.string.cert_creation_vhsm_import_person_fail);
            } else if (errorCode.equals(DEVICE_NO_ACTIVATION_CODE)) {
                return context.getString(R.string.cert_creation_device_no_activation);
            } else {
                return String.format(context.getString(R.string.cert_creation_unknown_error_2), toHex(errorCode));
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
            return errorCode;
        }
    }
}
