package com.xdja.safeclient.certcreation.device;

import android.text.TextUtils;

import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.devapi.RSAPubkey;
import com.xdja.cryptodev.devapi.SM2Pubkey;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.config.XDJAAlgParams;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.util.FidUtil;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;

/**
 * Created by jff on 2018/11/14.
 */

public class PKCS10ForRSAUtils extends PKCS10Utils {


    public static PKCS10ForRSAUtils pkcs10ForRSAUtils = new PKCS10ForRSAUtils();


    public static PKCS10ForRSAUtils getInstance() {
        if (pkcs10ForRSAUtils == null) {
            pkcs10ForRSAUtils = new PKCS10ForRSAUtils();
        }
        return pkcs10ForRSAUtils;
    }

    public PKCS10ForRSAUtils() {

    }

    /**
     * 生成RSA单证请求的P10
     *
     * @param dn 主题
     * @return 返回p10请求的字符串
     * @throws SignatureException
     * @throws NoSuchProviderException
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeyException
     */
    @Override
    public String getP10RequestBC(CryptoDevType type, int containerNum, String dn, boolean isApplyCert) {

        if (TextUtils.isEmpty(dn)) {
            return "";
        }

        if (isApplyCert) {
            int keyResult = generateRSAKeys(type, containerNum);

            //TODO JFF 2018.7.20 需要跟zjc确认错误码处理
            if (keyResult != 0 && keyResult != -1) {
                return "errorCode" + CryptoDevManager.getInstance().getErrorText(keyResult);
            }
        }


        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
//        ModuleLog.e("RSA cryptoInstance = " + cryptoInstance);
        if (cryptoInstance == null) {
            return "";
        }

        byte[][] keyPair = FidUtil.getKeyPairFid(type, containerNum);


        byte[] pubFid = keyPair[0];
        byte[] priFid = keyPair[1];
        RSAPubkey pubkey = new RSAPubkey();
        int result = cryptoInstance.readRSAPubKey(pubFid, pubkey);
//        ModuleLog.e("读取RSA公钥 result = " + result + "  " + CryptoDevManager.getInstance().getErrorText(result));
        if (result != 0) {
            return CryptoDevManager.getInstance().getErrorText(result);
        }
        try {
            //获取公钥pub
            final byte pub[] = new byte[128];
            System.arraycopy(pubkey.getM(), 0, pub, 0, 128);

            ASN1ObjectIdentifier rsaOID = new ASN1ObjectIdentifier(XDJAAlgParams.OID_RSA);
            SubjectPublicKeyInfo spi = new SubjectPublicKeyInfo(new AlgorithmIdentifier(rsaOID), pub);

            final X500Name x500Name = new X500Name(dn);
            CertificationRequestInfo cf1 = new CertificationRequestInfo(x500Name, spi, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream(outStream);
            try {
                derOutStream.writeObject(cf1);
            } catch (IOException e) {
                e.printStackTrace();
            }
            byte[] certInfoBytes = outStream.toByteArray();
            //对CertificationRequestInfo进行签名
            byte[] signData = new byte[128];
            int[] signDataLen = new int[1];
//            ModuleLog.e("入参 RSA SIGN AppConfig.RSA_KEY_LEN_1024 = " + AppConfig.RSA_KEY_LEN_1024
//                    + " priFid = " + priFid
//                    + " dateType = 1"
//                    + " certInfoBytes.length = " + certInfoBytes.length
//                    + " signDataLen" + signDataLen
//            );
            int encodeRequestInfo = cryptoInstance.RSASign(
                    XDJAAlgParams.RSA_KEY_LEN_1024, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
//            ModuleLog.e("RSA签名后返回的结果 = " + encodeRequestInfo);
            if (encodeRequestInfo != 0) {
                return null;
            }
            DERBitString dbs = new DERBitString(signData);
            String signAlg = "SHA1WITHRSA";
            AlgorithmIdentifier signIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(signAlg);
            CertificationRequest cr = new CertificationRequest(cf1, signIdentifier, dbs);
            PKCS10CertificationRequest request = new PKCS10CertificationRequest(cr);

            byte[] buffer = request.getEncoded();

            String p10 = new String(Base64.encode(buffer));
//            ModuleLog.e("RSA_P10请求字符串 ： " + p10);
//            checkP10(CryptoDevType.DEV_TYPE_Chip, p10);
            return p10;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }


    /**
     * 生成RSA签名公私钥对
     * author jff
     * todo jff 生成签名公私钥对
     *
     * @return
     */
    private int generateRSAKeys(CryptoDevType type, int containerNum) {
        int genRsaKeysPairResult = -1;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return genRsaKeysPairResult;
        }
        AppConfig module = AppConfig.getInstance();

//此处添加验证PIN，是因为生成公私钥操作返回-15（没有权限）
        int pinResult = DeviceWrapper.verifyPin(type, containerNum, "");
        if (pinResult == 0) {
            genRsaKeysPairResult = genRSAKeyPair(cryptoInstance, type, containerNum);
        } else {
            return pinResult;
        }

        if (genRsaKeysPairResult == 2030 || genRsaKeysPairResult == 2041) {
            if (cryptoInstance.createContainer(module.getRole(type, containerNum), module.getDefaultConfig().getPin(), containerNum, "") == 0) {
                genRsaKeysPairResult = genRSAKeyPair(cryptoInstance, type, containerNum);
            } else {
                return genRsaKeysPairResult;
            }
        }
//        ModuleLog.d("生成RSA公私钥对结果 " + result + "   " + CryptoDevManager.getInstance().getErrorText(result));
        cryptoInstance.close();
        return genRsaKeysPairResult;
    }


    private int genRSAKeyPair(CryptoInstance cryptoInstance, CryptoDevType type, int containerNum) {
        int genRsaKeysPairResult = -1;
        if (AppConfig.getInstance().getCertConfig().getCertRule(type, containerNum).equals(CertRule.SINGLE)) {
            if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals(CertType.SIGNING)
                    || TextUtils.isEmpty(AppConfig.getInstance().getCertConfig().getCertType(type, containerNum))) {
                genRsaKeysPairResult = cryptoInstance.genSignRSAKeyPair(containerNum, XDJAAlgParams.RSA_KEY_LEN_1024);
            } else {
                genRsaKeysPairResult = cryptoInstance.genExchangeRSAKeyPair(containerNum, XDJAAlgParams.RSA_KEY_LEN_1024);
            }
        } else {
            genRsaKeysPairResult = cryptoInstance.genSignRSAKeyPair(containerNum, XDJAAlgParams.RSA_KEY_LEN_1024);
        }
        return genRsaKeysPairResult;
    }


    private void checkP10(CryptoDevType type, String p10) {
        if (p10 == null || p10.equals("")) {
            return;
        }

        try {
            byte[] bs = Base64.decode(p10);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(bs);
            CertificationRequest request = re.toASN1Structure();
            CertificationRequestInfo cerReqInfo = request.getCertificationRequestInfo();

            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream(outStream);
            try {
                derOutStream.writeObject(cerReqInfo);
            } catch (IOException e) {
                e.printStackTrace();
            }
            byte[] certInfoBytes = outStream.toByteArray();

            byte[] signature = re.getSignature();
            SubjectPublicKeyInfo info = re.getSubjectPublicKeyInfo();
            DERBitString keyInfo = info.getPublicKeyData();
            byte[] bytes = keyInfo.getBytes();

            byte x[] = new byte[32];
            byte y[] = new byte[32];
            System.arraycopy(bytes, 1, x, 0, x.length);
            System.arraycopy(bytes, x.length + 1, y, 0, y.length);


            SM2Pubkey pubkey = new SM2Pubkey();
            pubkey.setX(x);
            pubkey.setY(y);

            byte pubFid[] = {0x00, 0x00};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.SM2SignVerify(pubFid, 1, pubkey, certInfoBytes, certInfoBytes.length, signature);

            }
//            ModuleLog.d("验签结果： = " + ret);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
