package com.xdja.safeclient.certcreation.service;

import android.os.Environment;
import android.os.Message;

import com.aircert.util.ModuleLog;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.fastjson.JSON;
import com.xdja.https.module.bean.HttpsParam;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.databases.CacheModel;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * Created by gyx on 2018/9/10.
 */

public class CertRequest {

    private String url, cardNo;
    private RequestBody body;
    private RequestCallback certCallback;

    public CertRequest(String url, String cardNo, RequestBody body, RequestCallback callback) {
        this.url = url;
        this.cardNo = cardNo;
        this.body = body;
        this.certCallback = callback;
    }

    /**
     * 记录请求
     *
     * @param url
     * @return
     */
    private long logRequest(String url) {
        long time = RequestCache.getInstance().getTime();
        if (time == 0) {
            time = System.currentTimeMillis();
        }

        DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");


        CacheModel value = new CacheModel();
        value.cardNo = cardNo;
        value.name = url;
        value.time = time + " | " + formatter.format(time);
        value.type = RequestCache.getInstance().getType(cardNo);
        // 如果是实体认证接口，存储下图片
        if (url.contains("authentication")) {
            value.selfie = ImageCache.getInstance().getSelfie();
            value.idImage = ImageCache.getInstance().getId();

            // TODO: 2019/2/19 0019 图片是可能为null的，原因需要追踪，先暂时处理下
            if (value.selfie == null || value.idImage == null) {
                return time;
            }

            // TODO: 2019/2/14 0014 调试 图片上传到服务器显示一半的问题
            // ACE下实际地址为 /storage/emulated/legacy/yishu
            // Mate10下实际地址为 /storage/sdcard0/yishu
            ImageCache.copyBase64ToFile(URLDecoder.decode(value.idImage), new File(Environment.getExternalStorageDirectory() + File.separator + "yishu" + File.separator + value.name + time + ".jpg"));

        }
        value.save();

        RequestCache.getInstance().resetTime();
        return time;
    }

    private Request initRequest(String url, String cardNo, RequestBody body) {
        // 当加密设备为空时，builder.addHeader会引起崩溃

        if (cardNo == null) {
            return null;
        }

        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json")
                .addHeader("cardNo", cardNo)
                .addHeader("clientTime", String.valueOf(System.currentTimeMillis()))
                .url(url);

        if (body != null) {
            MediaType mediaType = MediaType.parse("application/json; charset=UTF-8");
            String jsonStr = JSON.toJSONString(body);
//            ModuleLog.e("json转换 " + jsonStr);

            body = RequestBody.create(mediaType, jsonStr);
            builder.post(body);
        }

        return builder.build();
    }

    public void request() {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {

                // 如果在准备请求过程中，设备不存在（一般是TF卡或者贴膜卡）被拔出
                // 此时获取到的卡号cardNo为空，这时的处理是生成的request为空
                // 此时在上层调用的地方自行处理如何提示用户
                Request request = initRequest(CertRequest.this.url, CertRequest.this.cardNo, CertRequest.this.body);

                if (request == null) {
                    chipExecutorService.sendMessage(myHandler, CARD_EXCEPTION, null);
                    return;
                }

                final OkHttpClient client = HttpClientHelper.getOkHttpClient();
//                ModuleLog.e("request : = " + request.toString());
                final Call call = client.newCall(request);
                try {


//                    if(CertRequest.this.url.contains("/v1/identify/authentication")){
//                        ResponseInner responseInnerX = new ResponseInner();
//                        responseInnerX.call = null;
//                        responseInnerX.isSuccessful = true;
//                        responseInnerX.response = "{\"result\":1,\"message\":\"cn=郑钧辰 410402199312265510,ou=00,ou=00,o=00,l=00,l=00,ST=41,C=CN\"}";
//                        chipExecutorService.sendMessage(myHandler, RESPONSE_OK, responseInnerX);
//                    } else {

                    Response response = call.execute();
                    ResponseInner responseInner = new ResponseInner();
                    responseInner.call = call;
                    responseInner.isSuccessful = response.isSuccessful();
                    responseInner.response = response.body().string();
                    chipExecutorService.sendMessage(myHandler, RESPONSE_OK, responseInner);
//                    }


                } catch (IOException e) {
                    e.printStackTrace();
                    e.printStackTrace();
                    Failure failure = new Failure();
                    failure.call = call;
                    failure.e = e;
                    chipExecutorService.sendMessage(myHandler, IOE_EXCEPTION, failure);
                }
            }
        };
        chipExecutorService.exe(runnable);
    }


    /**
     * 请求网络
     *
     * @throws Exception
     */
    private void doRequest(final Request request, final HttpsParam httpsParam) {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {


            }
        };
        chipExecutorService.exe(runnable);
    }


    private HttpsParam generateHttpsParam() {
        HttpsParam httpsParam = new HttpsParam();
        httpsParam.setSupportHttps(true);
        httpsParam.setServerCertAccessPwd(AppConfig.getInstance().getDefaultConfig().getBksVerifyCode().toCharArray());
        httpsParam.setServerCertInputStream(AppConfig.getInstance().getContext().getResources().openRawResource(R.raw.truststore));
        return httpsParam;
    }

    private static class MyHandler extends WeakReferenceHandler<CertRequest> {
        public MyHandler(CertRequest reference) {
            super(reference);
        }

        @Override
        protected void handleMessage(CertRequest reference, Message msg) {
            int what = msg.what;
            if (what == RESPONSE_OK) {
                ResponseInner responseInner = (ResponseInner) msg.obj;
                reference.certCallback.onResponse(responseInner.call, responseInner.isSuccessful, responseInner.response);
            } else if (what == IOE_EXCEPTION) {
                Failure failure = (Failure) msg.obj;
                reference.certCallback.onFailure(failure.call, failure.e);
            } else if (what == CARD_EXCEPTION) {
                // 卡设备不存在
                reference.certCallback.onException(new CardNotExistException());
            } else {
                Exception e = (Exception) msg.obj;
                reference.certCallback.onException(e);
            }
        }
    }

    private static final int CARD_EXCEPTION = -3; // 卡设备不存在
    private static final int OTHER_EXCEPTION = -2; //其他类型异常
    private static final int IOE_EXCEPTION = -1;  //网络IOException
    private static final int RESPONSE_OK = 0;   //服务器正常放回
    private static final int SEND_HTTPSPARAM = 1;  //发送参数HttpsParam


    private MyHandler myHandler = new MyHandler(this);
    private ChipExecutorService chipExecutorService = new ChipExecutorService();


    private class Failure {
        Call call;
        IOException e;
    }


    private class ResponseInner {
        Call call;
        String response;
        boolean isSuccessful;
    }


}
