package com.xdja.safeclient.certcreation.service;

import android.util.Log;

import com.aircert.util.ModuleLog;
import com.alibaba.fastjson.JSON;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.callback.HttpArrayResponseCallBack;
import com.xdja.safeclient.certcreation.util.OttoUtil;

import java.io.IOException;

import ocr.bean.IDCardInfo;
import okhttp3.Call;
import okhttp3.RequestBody;


/**
 * Created by wanghao on 2017/8/22.
 */

public class CertService {

    //开发环境，苏士辉本机
//    static final String CLOUD_HOST = "http://11.12.85.65:8100/airIssue-api";
//    static final String CLOUD_HOST = "https://11.12.85.65:8101/airIssue-api";
//
    //演示环境外网  https
//    static final String CLOUD_HOST = "https://120.194.4.152:40053/airIssue-api";
//    演示环境内网  https
//    private static final String CLOUD_HOST = "https://11.12.107.145:8019/airIssue-api";


    //    //测试环境外网
//    private static final String CLOUD_HOST = "https://120.194.4.152:40058/airIssue-api";
//    //测试环境内网
//    private static final String CLOUD_HOST = "https://11.12.107.145:40058/airIssue-api";



    //广州现场
//    private static final String CLOUD_HOST = "https://20.95.15.176:8100/airIssue-api";

    //广东测试内网 https
//    private static final String CLOUD_HOST = "https://11.12.107.145:8019/airIssue-api";


    //广东测试外网 https
//    private static final String CLOUD_HOST = "https://120.194.4.152:40053/airIssue-api";


    //天津现场环境 -- 贾海红提供
//    private static final String CLOUD_HOST = "https://20.3.2.95:9443/airIssue-api";


    private static String CLOUD_HOST;
    public CertService(){
        AppConfig certCommonModule = AppConfig.getInstance();
        Log.e("jff", "61 CertService CertService : " + certCommonModule.getServerSettingConfig());
        if(certCommonModule.getServerSettingConfig().getIp() == null){
            return;
        }
        CLOUD_HOST = "https://"
                + certCommonModule.getServerSettingConfig().getIp()
                + ":" + certCommonModule.getServerSettingConfig().getPort()
                + "/airIssue-api";
        ModuleLog.e("ip " + certCommonModule.getServerSettingConfig().getIp());
    }

    /**
     * 2.1.【I-airIssue-api-001】解析身份证信息
     *
     * @param body
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void resoleIdentifyInfo(RequestBody body, String cardNo, final HttpResponseCallBack<IDCardInfo> callback) {
        ModuleLog.e("CertService resoleIdentifyInfo");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final IDCardInfo resolveIdentifyReponse = JSON.parseObject(response, IDCardInfo.class);
                    callback.onSuccessfulResponse(call, resolveIdentifyReponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/identify/resolve";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }


    /**
     * 2.2.【I-airIssue-api-002】实体认证
     *
     * @param body
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void entityAuthentication(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        ModuleLog.e("CertService entityAuthentication");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();

            }
        };

        String url = CLOUD_HOST + "/v1/identify/authentication";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

     /**
     * 2.3.【I-airIssue-api-003】实体认证结果查询
     *
     * @param identity 身份证号一定不能为空，否则会引起崩溃
     * @param callback
     * @param cardNo
     * @throws Exception
     */
    public void queryAuthenticationResult(String identity, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        ModuleLog.e("CertService queryAuthenticationResult");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {

                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/identity/check/result/" + identity;
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();

    }

    /**
     * 2.4.【I-airIssue-api-004】证书申请
     *
     * @param cardNo
     * @param callBack
     * @throws Exception
     */
    public void applyCert(RequestBody body, String cardNo, final HttpResponseCallBack<CertApplyResponse> callBack) {

        ModuleLog.e("CertService applyCert");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                ModuleLog.e("CertService applyCert success");
                if (isSuccessful) {
                    final CertApplyResponse certApplyResponse = JSON.parseObject(response, CertApplyResponse.class);
                    callBack.onSuccessfulResponse(call, certApplyResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/application";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    /**
     * 2.5.【I-airIssue-api-006】证书撤销
     *
     * @param body
     * @param cardNo
     * @param callBack
     * @throws Exception
     */
    public void revokedCert(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {

        ModuleLog.e("CertService revokedCert");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/cert/revoke";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }


    /**
     * 2.6【I-airIssue-api-007】查询证书状态
     *
     * @param body
     * @param callback
     * @param cardNo
     * @throws Exception
     */
    public void certStateQuery(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        ModuleLog.e("CertService certStateQuery");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                OttoUtil.postQueryFishied();
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                OttoUtil.postQueryFishied();
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                OttoUtil.postQueryFishied();
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/cert/status/";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }


    /**
     * 2.7【I-airIssue-api-008】校验手机号格式
     *
     * @param cardNo
     * @param callBack
     * @throws Exception
     */
    public void verifyPhoneNum(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {

        ModuleLog.e("CertService verifyPhoneNum");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {

                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
                callBack.dismissDialog();
            }
        };

        String url = CLOUD_HOST + "/v1/identity/phone/";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    /**
     * 2.8.【I-airIssue-api-009】证书解冻申请
     *
     * @param requestBody
     * @param cardNo
     * @param callBack
     */
    public void thawingCert(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        ModuleLog.e("CertService thawingCert");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/cert/unfreeze";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();

    }

    /**
     * 2.9.【I-airIssue-api-010】证书用户信息更新/延期申请
     *
     * @param requestBody
     * @param cardNo
     * @param callBack
     * @throws Exception
     */
    public void updateOrDelayCert(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        ModuleLog.e("CertService updateOrDelayCert");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };

        String url = CLOUD_HOST + "/v1/cert/update";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();


    }

    /**
     * 2.10.【I-airIssue-api-010】写卡状态上报
     *
     * @param cardNo
     * @param callBack
     * @throws Exception
     */
    public void uploadWriteCertResult(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        ModuleLog.e("CertService uploadWriteCertResult");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }

            }
        };

        String url = CLOUD_HOST + "/v1/cert/write";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    /**
     * 2.11.【I-airIssue-api-012】发送手机号验证码
     *
     * @param requestBody
     * @param cardNo
     * @param callBack
     */
    public void requestSMSCode(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        ModuleLog.e("CertService requestSMSCode");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
                callBack.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {

                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
                callBack.dismissDialog();
            }


        };

        String url = CLOUD_HOST + "/v1/phone/send/code/";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();

    }

    /**
     * 2.12.【I-airIssue-api-013】验证手机号校验码
     *
     * @param requestBody
     * @param cardNo
     * @param callBack
     * @throws Exception
     */
    public void verifySMSCode(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        ModuleLog.e("CertService verifySMSCode");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {

                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }

        };

        String url = CLOUD_HOST + "/v1/phone/verify/code";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();

    }

    /**
     * 2.13.【I-airIssue-api-014】实体认证-无需活体检测(同2.2)
     *
     * @param body
     * @param cardNo
     * @param callback
     */
    public void applyAuthentication(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {

        ModuleLog.e("CertService applyAuthentication 2.13");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                ModuleLog.e("实体认证返回：=" + response);
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/identify/authentication";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    /**
     * 2.14.【I-airIssue-api-015】用户注册
     *
     * @param body
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void register(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {

        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }

        };
        String url = CLOUD_HOST + "/v1/user/register";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }


    /**
     * 2.15.【I-airIssue-api-016】获取部门结构
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getDepartment(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {


        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }

        };
        String url = CLOUD_HOST + "/v1/user/department";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    /**
     * 2.16.【I-airIssue-api-017】获取人员类型
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getPersonType(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {

        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }

        };

        String url = CLOUD_HOST + "/v1/user/personType";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    /**
     * 2.17.【I-airIssue-api-018】获取警钟信息
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getPoliceClass(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {

        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };

        String url = CLOUD_HOST + "/v1/user/policeClass";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    /**
     * 2.18.【I-airIssue-api-019】获取级别信息
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getLevel(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {

        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/user/level";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    /**
     * 2.19.【I-airIssue-api-020】获取职务信息
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getPosition(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {

        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }


        };

        String url = CLOUD_HOST + "/v1/user/positions";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    /**
     * 2.21.【I-airIssue-api-021】用户信息获取
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getUserInfo(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {

        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();

            }
        };

        String url = CLOUD_HOST + "/v1/user/info";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    /**
     * 2.22.【I-airIssue-api-022】证书密钥更新
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void updateCertPwd(RequestBody body, String cardNo, final HttpResponseCallBack<CertApplyResponse> callback) {
        ModuleLog.e("CertService updateCertPwd");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CertApplyResponse commonResponse = JSON.parseObject(response, CertApplyResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();

            }
        };

        String url = CLOUD_HOST + "/v1/cert/pwd";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }


    /**
     * 2.24.【I-airIssue-api-024】获取云从授权码
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getOcrAuthCode(String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        ModuleLog.e("CertService getOcrAuthCode");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();

            }
        };

        String url = CLOUD_HOST + "/v1/client/getOcrAuthCode";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    /**
     * 2.25.【I-airIssue-api-025】获取VHSM服务端地址
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void getVhsmURL(String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        ModuleLog.e("CertService getVhsmURL");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();

            }
        };

        String url = CLOUD_HOST + "/v1/client/getVhsmUrl";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }


    /**
     * 2.26.【I-airIssue-api-026】撤销非当前设备的证书
     *
     * @param cardNo
     * @param callback
     * @throws Exception
     */
    public void revokeOwnOldCert(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        ModuleLog.e("CertService revokeOwnOldCert");
        RequestCallback certCallback = new RequestCallback() {
            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    final CommonResponse commonResponse = JSON.parseObject(response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    final BaseErrorResponse baseErrorResponse = JSON.parseObject(response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };

        String url = CLOUD_HOST + "/v1/cert/oldCertRevoke";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }


    /**
     * 取消所有请求
     */
    public void cancelAll() {
//        try {
////            com.xdja.https.module.HttpClientManager.getInstance().createHttpClient(httpsParam)
////            HttpClientManager.getInstance().createHttpClient().dispatcher().cancelAll();
////            com.xdja.https.module.HttpClientManager.getInstance().createHttpClient().dispatcher().cancelAll();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
    }


}

