package com.xdja.safeclient.certcreation.util;

import android.app.AlertDialog;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Window;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.ConfigListAdapter;
import com.xdja.a3rdplugin.demo.ConfigBean;

import java.util.List;

/**
 * Created by Administrator on 2019/5/21 0021.
 */

public class ConfigDialog {

    public static void show(Context context, final List<ConfigBean> all) {

        final AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.show();
        dialog.setContentView(R.layout.common_dialog_list);
        Window window = dialog.getWindow();
        RecyclerView recyclerView = (RecyclerView) window.findViewById(R.id.gateway_list);
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context);
        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.setLayoutManager(layoutManager);

        final ConfigListAdapter adapter = new ConfigListAdapter(context);
        adapter.setDataSource(all);
        adapter.setOnItemClickListener(new ConfigListAdapter.OnItemClickListener() {
            @Override
            public void onItemSelected(int position) {
                OttoUtil.postChooseResult(adapter.getSelectedItem());
                dialog.cancel();
            }
        });

        recyclerView.setAdapter(adapter);
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
    }

    public static void show(Context context, int position, final List<ConfigBean> all) {

        final AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.show();
        dialog.setContentView(R.layout.common_dialog_list);
        Window window = dialog.getWindow();
        RecyclerView recyclerView = (RecyclerView) window.findViewById(R.id.gateway_list);
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context);
        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.setLayoutManager(layoutManager);

        final ConfigListAdapter adapter = new ConfigListAdapter(context, position);
        adapter.setDataSource(all);
        adapter.setOnItemClickListener(new ConfigListAdapter.OnItemClickListener() {
            @Override
            public void onItemSelected(int position) {
                OttoUtil.postChooseResult(adapter.getPosition(), adapter.getSelectedItem());
                dialog.cancel();
            }
        });

        recyclerView.setAdapter(adapter);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(true);
    }


}
