package ocr.activity;

import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.IOException;
import java.lang.ref.WeakReference;

import cn.cloudwalk.libproject.view.RoundProgressBarWidthNumber;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

/**
 * 新版设计中，认证在身份证信息界面进行，不再使用单独的Activity
 * 身份验证
 * Created by yangpeng on 2018/4/10.
 */
@Deprecated
public class AuthenticationActivity extends BaseActivity {

    private String faceImg;
    private IDCardInfo idCardInfo;
    private MyHandler myHandler;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.compare_loading);
        initView();
        getParams();
        myHandler = new MyHandler(this);
        startTimerRunnable();
        request();
        leftBtn.setVisibility(View.INVISIBLE);
    }

    /**
     * 开始上传数据进行比对
     */
    private void request() {
        int devType = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
//        ModuleLog.e("实体认证 1 cardID = " + cardID);
        if (TextUtils.isEmpty(cardID)) {
            ModuleToast.show(context, R.string.cert_creation_card_device_error);
            return;
        }
//        ModuleLog.e( "实体认证 2 cardID = " + cardID);
        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = buildRequest();
        if (request == null) {
            ModuleToast.show(context, R.string.cert_creation_get_imsi_failed);
            compareResult.setResult("");
            compareResult.setMessage(getResources().getString(R.string.cert_creation_get_imsi_failed));
            compareResult.setSuccess(false);
            compareResult.setIdentity(idCardInfo.getIdNum());
            verifyFailResultActivity(currentChipBeanType, compareResult);
            OttoUtil.postFinishActivity();
            return;
        }
        service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
//                ModuleLog.e("onOtherException");
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                stopTimer();
                ModuleLog.e("io exception");
                compareResult.setResult("");
                compareResult.setMessage(context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(idCardInfo.getIdNum());
//                AuthResult auth = new AuthResult(currentChipBeanType, compareResult);
//                OttoUtil.postAuthResult(auth);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
//                ModuleLog.e("认证返回结果code= " + commonResponse.getResult());

                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(idCardInfo.getIdNum());
                compareResult.setSuccess(true);
                if (commonResponse.getResult().equals("2")) {
                    // 返回2的情况很少，只有现场的某些服务会有
                    verifyFailResultActivity(currentChipBeanType, compareResult);
                    finish();
                    OttoUtil.postFinishActivity();
                } else {


//                    AuthResult auth = new AuthResult(currentChipBeanType, compareResult, RequestCache.getInstance().getObject());
//                    OttoUtil.postAuthResult(auth);
                    OttoUtil.postFinishActivity();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                ModuleLog.e("认证失败");
                stopTimer();
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(idCardInfo.getIdNum());
                compareResult.setSuccess(false);
//                AuthResult auth = new AuthResult(currentChipBeanType, compareResult);
//                OttoUtil.postAuthResult(auth);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
            }

            @Override
            public void dismissDialog() {

            }
        });

    }


    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {

        ARouter.getInstance()
                .build(ActivityPath.ACTIVITY_AUTH_FAIL)
                .withSerializable("result", result)
                .withSerializable("devType", type)
                .navigation(this);

    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));
//        ModuleLog.e("实体验证  卡类型 " + Util.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));
        chipInfo.setImei(deviceWrapper.getIMEI());
//        chipInfo.setVhsmType(String.valueOf(AppConfig.getInstance().getShowDeviceType()));
        String imsi = deviceWrapper.getIMSI();
//        ModuleLog.e("imsi = " + imsi);
//        if (TextUtils.isEmpty(imsi)) {
////            ModuleToast.show(this, "获取imsi失败，请确认SIM卡插入正常");
////            ModuleLog.e("请确认SIM卡插入正常");
//
//            return null;
//        }
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(AuthenticationActivity.this));

        request.setIdCardInfo(idCardInfo);
        request.setChipInfo(chipInfo);
        request.setFaceImg(faceImg);
//        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType().getCaAlg());
//        Log.e("jff","实体认证： " + request.toString());
        return request;

    }


    /**
     * 获取执行后续业务所需的参数
     */
    private void getParams() {
        Bundle others = getIntent().getExtras();
        faceImg = others.getString(FACE_IMG);
        if (others.containsKey(ID_CardInfo)) {
            idCardInfo = others.getParcelable(ID_CardInfo);
        }
    }


    private RoundProgressBarWidthNumber progress_loading;

    private void initView() {
        ImageView img_loading = (ImageView) findViewById(R.id.img_loading);
        TextView tv_loading = (TextView) findViewById(R.id.tv_loading);
        progress_loading = (RoundProgressBarWidthNumber) findViewById(R.id.progress_loading);
        img_loading.setImageResource(R.drawable.compare_loading);
        tv_loading.setText(R.string.cert_creation_face_comparing);
    }

    private void initProgress(int max) {
        progress_loading.setMax(max);
    }

    private void updateTime(int time) {
        progress_loading.setProgress(time);
    }

    private static final int UPDATE_TIME_LEFT = 100; //用来更新显示时间
    private static final int UPDATE_FINAL = 101; //展示最终结果

    private TimerRunnable timerRunnable = null;

    private void startTimerRunnable() {
        int totalTime = 40;
        initProgress(totalTime);
        updateTime(totalTime);
        timerRunnable = new TimerRunnable(totalTime, this);
        myHandler.post(timerRunnable);
    }


    private void stopTimer() {
        if (timerRunnable != null) {
            timerRunnable.setFlag(true);
            myHandler.removeMessages(UPDATE_TIME_LEFT); //移除已发送出的更新界面时间的Message gyx 2017.12.4
        }
    }

    static class TimerRunnable implements Runnable {

        private int total;
        private final WeakReference<AuthenticationActivity> reference;

        public TimerRunnable(int total, AuthenticationActivity activity) {
            this.total = total;
            reference = new WeakReference<>(activity);
        }

        private boolean isStop = false;

        public void setFlag(boolean isStop) {
            this.isStop = isStop;
        }

        @Override
        public void run() {
            AuthenticationActivity activity = reference.get();
            if (isStop || activity == null) {
                return;
            }
            activity.myHandler.obtainMessage(UPDATE_TIME_LEFT, total).sendToTarget();
            total--;
            if (total >= 0) {
                activity.myHandler.postDelayed(activity.timerRunnable, 1000);
            } else {
                activity.myHandler.obtainMessage(UPDATE_FINAL).sendToTarget();
            }
        }
    }


    static class MyHandler extends WeakReferenceHandler<AuthenticationActivity> {

        public MyHandler(AuthenticationActivity reference) {
            super(reference);
        }

        @Override
        protected void handleMessage(AuthenticationActivity reference, Message msg) {
            int what = msg.what;
            if (what == UPDATE_TIME_LEFT) {
                reference.updateTime((Integer) msg.obj);
            } else {
//                reference.setFinal();
            }
        }
    }

    @Override
    public void finish() {
        super.finish();
        service.cancelAll();
    }

    @Override
    protected boolean isOCRActivity() {
        return true;
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_identify;
    }
}

