package ocr.activity;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

/**
 * 证件拍照引导页
 * 标题-上传身份证照片
 *
 */

@Route(name = ActivityPath.NAME_ID_READY, path = ActivityPath.ACTIVITY_CAMERA_ID_READY)
public class IDReadyActivity extends BaseActivity {

    @Autowired()
    public int type;
    String        cardNo;
    CryptoDevType cardType;
    String        phone;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_camera_id_ready);
        left_title_tv.invalidate();
        hideBG();

        cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType(this));
        cardNo = DeviceWrapper.getInstance().getCardID(cardType);

        phone = SharePreferencesUtil.getPhoneNum(this);

        if (TextUtils.isEmpty(cardNo)) {
            ModuleToast.show(context, R.string.cert_creation_card_device_error);
            return;
        }

        Button bt_startdect = (Button) findViewById(R.id.start);

        bt_startdect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                next();
            }
        });


    }

    @Override
    public boolean valid() {
        return ContextCompat.checkSelfPermission(IDReadyActivity.this, Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED;
    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_SELFIE;
    }

    @Override
    public void route() {
        super.route();
        ARouter.getInstance()
                .build(nextActivity())
                .withInt("type", type)
                .withString("cardNo", cardNo)
                .withSerializable("cardType", cardType)
                .withString("phone", phone)
                .navigation(this);
    }

    @XdjaPermission(permissions = {
            Manifest.permission.CAMERA,
    })
    private void requestCamera() {

    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (permissions[0].equals(Manifest.permission.CAMERA) && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            next();
        }

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_selfie_photo_title;
    }

    @Subscribe

    public void handleFinishActivity(FinishActivity activity) {
        finish();
    }

}
