package ocr.activity;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.provider.Settings;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.nfcoperate.bean.CardInfo;
import com.xdja.nfcoperate.callback.IDCardInfoCallback;
import com.xdja.nfcoperate.operate.cardinfo.CardInfoInit;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.util.ModuleToast;

import java.io.ByteArrayOutputStream;

import cn.cloudwalk.libproject.util.NetUtil;
import ocr.bean.IDCardInfo;
import ocr.command.NFCCommand;
import ocr.command.NetErrorCommand;
import ocr.fragment.NFCLoadingFragment;
import ocr.util.Convert;

/**
 * Created by gyx on 2018/6/21.
 */
@Route(name = ActivityPath.NANE_XDJA_NFC, path = ActivityPath.ACTIVITY_XDJA_NFC)
public class XDJANFCActivity extends NFCActivity implements IDCardInfoCallback, NFCCommand, NetErrorCommand {

    /**
     * /**
     * 超时
     */
    protected static final int MESSAGE_TIMEOUT = 14;
    /**
     * NFC读取数据失败
     */
    protected static final int MESSAGE_INVALID_NFC = 15;
    /**
     * NFC读取数据成功
     */
    protected static final int MESSAGE_VALID_NFC = 16;

    private CardInfoInit mInit;

    public int containerNum;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.layout_nfc);

        ARouter.getInstance().inject(this);

        showNormalFragment();
        mInit = new CardInfoInit(this);
//        读取完整身份证信息调用
        mInit.getCardInfo(getIntent());
        getData();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (mInit != null) {
            //读取完整身份证信息调用
            mInit.getCardInfo(intent);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mInit != null) {
            mInit.onResume();
        }

        switch (mInit.detectionNFC(getContext())) {
            case -2:
                ModuleToast.show(this, R.string.cert_creation_open_nfc);
                break;
            case -1:
                ModuleToast.show(this, R.string.cert_creation_not_support_nfc);
                finish();
                break;
        }

        if (!mInit.isNetWorkConnect()) {
            showNetworkErrFragment();
        }
    }


    @Override
    protected void onPause() {
        super.onPause();
        if (mInit != null) {
            mInit.onPause();
        }
    }

    @Override
    public int getNFCState() {
        if (mInit == null) {
            return NFCLoadingFragment.STATE_UNSUPPORT;
        }
        int state = mInit.detectionNFC(getContext());
        if (state == -2) {
            return NFCLoadingFragment.STATE_UNOPEN;
        } else if (state == -1) {
            return NFCLoadingFragment.STATE_UNSUPPORT;
        } else {
            return NFCLoadingFragment.STATE_NORMAL;
        }
    }

    @Override
    public void openNFC() {
        Intent intent = new Intent(Settings.ACTION_NFC_SETTINGS);
        startActivity(intent);
    }

    @Override
    public void retry() {
        if (!NetUtil.isConnected(this)) { //断开网络时
            ModuleToast.show(this, R.string.net_disconnected_text);
        } else {
            retryResume();
        }
    }

    private void retryResume() {
        showNormalFragment();
        if (mInit != null) {
            mInit.onResume();
        }

        switch (mInit.detectionNFC(getContext())) {
            case -2:
                ModuleToast.show(this, R.string.cert_creation_open_nfc);
                break;
            case -1:
                ModuleToast.show(this, R.string.cert_creation_not_support_nfc);
                finish();
                break;
        }

    }

    @Override
    public int getErrorMsg() {
        return R.string.net_disconnected_text;
    }

    @Override
    public void getCardInfo(int i, CardInfo cardInfo) {
        if (!mInit.isNetWorkConnect()) {
            showNetworkErrFragment();
            return;
        }

        if (i == MESSAGE_VALID_NFC) {
            //NFC读取数据成功
            getDataInfoSuccess(cardInfo);
        } else if (i == MESSAGE_TIMEOUT) {
            //NFC读取数据超时
            ModuleToast.show(this, R.string.net_timeout);
        } else if (i == MESSAGE_INVALID_NFC) {
            //读取数据失败
//            Toast.makeText(this, " 读取数据失败", Toast.LENGTH_SHORT).show();
            ModuleToast.show(this, R.string.cert_creation_get_data_fail);
        }

    }

    /**
     * NFC读取数据成功
     *
     * @param cardInfo
     */
    private void getDataInfoSuccess(CardInfo cardInfo) {
        if (cardInfo != null && cardInfo.getName() != null) {

            //实际身份证信息
            IDCardInfo id = Convert.cardInfoToIdentifyInfo(cardInfo);

            Bundle others = new Bundle();
            others.putString(FACE_IMG, liveFaceImg);
            others.putByteArray("selfie", getBytesByBitmap(cardInfo.getPhoto()));
            others.putParcelable(IDENTIFY_INFO, id);
            Intent intent = new Intent(this, XDJANFCIDCardActivity.class);
            others.putInt(ActivityParam.CONTAINER_NUM, containerNum);
            intent.putExtras(others);
            startActivity(intent);


            finish();
        } else {
            ModuleToast.show(this, R.string.cert_creation_get_data_fail);
        }
    }

    protected String liveFaceImg;

    public void getData() {
        Bundle others = getIntent().getExtras();
        if (others != null && others.containsKey(FACE_IMG)) {
            liveFaceImg = others.getString(FACE_IMG);
        }

        if (others != null) {
            containerNum = others.getInt(ActivityParam.CONTAINER_NUM);
        }

    }

    public byte[] getBytesByBitmap(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos);
        return baos.toByteArray();

    }


    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public PendingIntent getPendingIntent() {
        return PendingIntent.getActivity(this, 0, new Intent(this, XDJANFCActivity.class).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
    }
}
