package ocr.view;

import android.content.Context;
import android.support.annotation.ColorRes;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;


/**
 * Created by guoyaxin on 2017/11/20.
 */

public abstract class MyClickText extends ClickableSpan {


    private int color;
    private Context context;

    public MyClickText(Context context, @ColorRes int color) {
        this.context = context.getApplicationContext();
        this.color = color;
    }

    @Override
    public void updateDrawState(TextPaint ds) {
        super.updateDrawState(ds);
        //设置文本的颜色
        ds.setColor(this.context.getResources().getColor(color));
        //超链接形式的下划线，false 表示不显示下划线，true表示显示下划线
        ds.setUnderlineText(false);
    }

    @Override
    public void onClick(View widget) {
        doClick();
    }

    public abstract void doClick();
}
