/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import com.xdja.safeclient.certcreation.event.ProfessionDepartment;
import java.util.List;

public class DepartmentListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<ProfessionDepartment> dataSource;
    private int currentPosition = -1;
    ProfessionBean selectedItem;
    OnItemClickListener onItemClickListener;

    public DepartmentListAdapter(Context context) {
        this.context = context;
    }

    public void setDataSource(List<ProfessionDepartment> dataSource) {
        this.dataSource = dataSource;
        this.notifyDataSetChanged();
    }

    public void setSelectedItem(ProfessionBean selectedItem) {
        this.selectedItem = selectedItem;
    }

    public ProfessionDepartment getSelectedItem() {
        return this.dataSource.get(this.currentPosition);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.dialog_item, null));
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        ProfessionDepartment state = this.dataSource.get(position);
        if (!TextUtils.isEmpty((CharSequence)String.valueOf(state.getId()))) {
            String text = state.getName();
            holder.name.setText((CharSequence)text);
        }
        holder.layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DepartmentListAdapter.this.currentPosition = position;
                if (DepartmentListAdapter.this.onItemClickListener != null) {
                    DepartmentListAdapter.this.onItemClickListener.onItemSelected(DepartmentListAdapter.this.currentPosition);
                }
            }
        });
    }

    public int getItemCount() {
        return this.dataSource.size();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemSelected(int var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        View layout;
        TextView name;

        public ViewHolder(View itemView) {
            super(itemView);
            this.layout = itemView.findViewById(R.id.layout);
            this.name = (TextView)itemView.findViewById(R.id.name);
        }
    }
}

