package com.xdja.safeclient.certcreation.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import ocr.activity.BaiduOCRActivity;
import ocr.bean.IDCardInfo;

import static com.aircert.CommonActivity.ToolBarActivity.FACE_IMG;

/**
 * Created by Administrator on 2019/5/15 0015.
 */

public class BaiduOCRReveiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {

        if (context == null) {
            return;
        }

        String faceImg = intent.getStringExtra(FACE_IMG);

        IDCardInfo info = new IDCardInfo();

        info.setName(getValue(intent, "name"));
        info.setSex(getValue(intent, "sex").equals("男") ? 1 : 2);
        info.setBirthDate(getValue(intent, "birthDay"));
        info.setNation(getValue(intent, "nation"));
        info.setAddr(getValue(intent, "address"));
        info.setIdNum(getValue(intent, "idNum"));
        info.setIssueOffice(getValue(intent, "issue"));
        info.setValidDate(getValue(intent, "validDate"));

        Intent newIntent = new Intent(context, BaiduOCRActivity.class);
        newIntent.putExtra("identify_info", info);
        newIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        newIntent.putExtra(FACE_IMG, faceImg);
        context.startActivity(newIntent);

    }

    private String getValue(Intent intent, String key) {
        return intent.getStringExtra(key);
    }

}
