package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.text.TextUtils;

import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.PhoneInputActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.IDCard;
import com.xdja.safeclient.certcreation.bean.request.SimpleChipInfo;
import com.xdja.safeclient.certcreation.bean.request.VerifyInfoSelfieRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.service.CertService;

import java.io.IOException;

import okhttp3.Call;

/**
 * 申请证书方法类<br><br>
 * 因为在BasicInfoActivity和ProfessionActivity中都有申请证书的请求，因此写一个公共类
 * Created by Administrator on 2018/6/26 0026.
 */
public class ApplyCertUtil {

    public interface WhatHappen {
        void showDialog();

        void cancelDialog();

        void IOError();

        void handleResult(CommonResponse response);

        void handleError(BaseErrorResponse baseErrorResponse);
    }

    /**
     * 简易流程实体认证
     *
     * @param happen 回调
     */
    public static void start(Context context, final int containerNum, final WhatHappen happen) {
        happen.showDialog();

        final CryptoDevType cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType(context));

        final String cardNo = DeviceWrapper.getInstance().getCardID(cardType);
        if (TextUtils.isEmpty(cardNo)) {
            ModuleToast.show(context, R.string.cert_creation_card_device_error);
            return;
        }

        final VerifyInfoSelfieRequest request = buildRequest(SharePreferencesUtil.getIDCardNo(context, cardType.getType()),
                SharePreferencesUtil.getName(context),
                SharePreferencesUtil.getPhoneNum(context),
                SharePreferencesUtil.getSex(context, cardType.getType()),
                cardType,
                containerNum
        );

        CertService service = new CertService();

        service.applyAuthentication(request, cardNo, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("实体注册异常");
                //因为现在省掉了一个context参数，所以如果想用Toast进行提示，回调中自行处理
                happen.IOError();
                OttoUtil.postAuthResult(buildAuthResult(cardType, containerNum, cardNo, null, null));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                ModuleLog.d("实体注册成功");
                OttoUtil.postAuthResult(buildAuthResult(cardType, containerNum, cardNo, commonResponse, null));
                //此时前面的几个界面是需要结束的，具体情况在handleResult中进行处理
                happen.handleResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e("实体注册失败：" + baseErrorResponse.toString());
                //之所以不直接调用handleErrorMessage进行Toast提示是因为
                //有些地方可能对错误码有特殊处理，比如广东在遇到“身份证号在警员库中不存在,请联系管理员。”时，不再进行提示
                happen.handleError(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                happen.cancelDialog();
            }
        });

    }


    /**
     * 构造认证结果的Otto对象<br><br>
     * 没有就传null
     *
     * @param type          卡类型<br><br>
     * @param cardNum       卡号<br><br>
     * @param response      <font color="red">response为null时是IO异常</font> <br><br>
     * @param errorResponse errorResponse有值代表是服务器返回错误
     * @return
     */
    public static AuthResult buildAuthResult(CryptoDevType type, int containerNum, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {
        CompareResult result = new CompareResult();

        // TODO: 2018/11/8 0008 三种情况的处理需要重写

        ModuleLog.e("ApplyCertUtil response = " + response);
        ModuleLog.e("ApplyCertUtil errorResponse = " + errorResponse);
        // TODO: 2019/10/17 jff 此判断条件需要优化
        //IO异常的处理
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            //错误的处理
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty(errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            //正确的处理
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            //注意，成功的时候是没有errCode的
            result.setSuccess(true);
        }

        result.setIdentity(cardNum);

        AuthResult auth = new AuthResult(type, containerNum, result, RequestCache.getInstance().getObject());
        ModuleLog.d(auth);
        return auth;
    }

    /**
     * 构造申请证书请求的Request<br><br>
     * <font color="red">判空操作(及对应的提示)需在传参之前进行</font> <br><br>
     * <font color="red">如果某项值为null，请求时会返回缺少必要参数</font>
     *
     * @param id       身份证号
     * @param name     姓名
     * @param phone    入网手机
     * @param sex      性别 男是1；女是2
     * @param cardType 卡类型
     * @return
     */
    public static VerifyInfoSelfieRequest buildRequest(String id, String name, String phone, int sex, CryptoDevType cardType, int containerNum) {

        VerifyInfoSelfieRequest request = new VerifyInfoSelfieRequest();

        IDCard idCard = new IDCard();
        idCard.setIdNum(id);
        idCard.setName(name);
        idCard.setSex(sex);
        idCard.setPhoto(ImageCache.getInstance().getId());

        SimpleChipInfo chipInfo = new SimpleChipInfo();
        chipInfo.setPhone(phone);
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));


        if (cardType.getType() == CryptoDevType.DEV_TYPE_Soft.getType()) {
            if (AppConfig.getInstance().getCertConfig().getVHSMType()
                    .equals(CardType.ONLINE_VHSM)
                    ) {
                chipInfo.setVhsmType(CardType.REQUEST_PARAM_ONLINE_VHSM);
                chipInfo.setImei(NetVhsmDeviceIdUtils.getDevId(AppConfig.getInstance().getContext()));
            }
        }else{
            chipInfo.setImei(DeviceWrapper.getInstance().getIMEI());
        }

        String procudure = AppConfig.getInstance().getServerSettingConfig().getProcedure();

        if (!procudure.equals(Procedure.PHONE)) {
            //            ImageCache.getInstance().setSelfie(Selfie.CAMERA, Base64Util.fromFile(Environment.getExternalStorageDirectory()
            //                    .getPath() + File.separator + "temp.jpg"), true);
            //            request.setFaceImg(ImageCache.getInstance().getSelfie());
            //        request.setFaceImg(URLEncoder.encode(Base64Util.fromFile(Environment.getExternalStorageDirectory()
            //                .getPath() + File.separator + "temp.jpg")));


            request.setFaceImg(ImageCache.getInstance().getSelfie());
        } else {
            request.setFaceImg("");
        }
        request.setIdCardInfo(idCard);

        request.setChipInfo(chipInfo);
//        Log.e("jff", "220 ApplyCertUtil buildRequest : " + chipInfo.toString());

        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, containerNum));


        return request;

    }

    /**
     * 等待审核
     */
    public static final String WAIT = "0";

    /**
     * 审核自动通过
     */
    public static final String SUCCESS = "1";

    /**
     * 身份识别直接被人脸识别服务识别为不一致
     */
    public static final String AUTO_VERIFY_NOT_MATCH = "2";

    /**
     * 这是一个预留的方法<br><br>
     * 0、1、2三种结果在调用之前已经由OttoUtil.postAuthResult发出去，在CertItemView中进行处理了
     *
     * @param response
     */
    public static void handleSuccessResult(Context context, CommonResponse response) {
        //        ModuleLog.d(response);

        String procudure = AppConfig.getInstance().getServerSettingConfig().getProcedure();

        String result = response.getResult();
        if (result.equals(WAIT)) {
            if (!procudure.equals(Procedure.PHONE)) {
                OttoUtil.post(new SpecificActivity(SelfieActivity.class));
            } else {
                OttoUtil.post(new SpecificActivity(PhoneInputActivity.class));
            }
            //等待审核
            OttoUtil.postFinishActivity();
        } else if (result.equals(SUCCESS)) {
            // 先结束SelfieActivity的原因是，SelfieActivity的背景属性android:windowIsTranslucent = false
            //            如果直接顺次结束Activity，会导致出现黑屏
            //            因此先结束改Activity，此时界面依然处于最上层界面，用户无感知。之后顺次结束不再会有黑屏的问题

            ModuleLog.e("Verify Success");
            if (!procudure.equals(Procedure.PHONE)) {
                OttoUtil.post(new SpecificActivity(SelfieActivity.class));
            } else {
                OttoUtil.post(new SpecificActivity(PhoneInputActivity.class));
            }
            //审核自动通过，此时message为警员信息
            OttoUtil.postFinishActivity();
        } else if (result.equals(AUTO_VERIFY_NOT_MATCH)) {
            //身份识别直接被人脸识别服务识别为不一致；此时停留在当前界面，之前界面不结束
            ModuleToast.show(context, R.string.cert_creation_auto_verify_not_match);
            DeviceWrapper.getInstance().setApplyCertEnd(false);
        }
    }


}
