package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Log;

import java.net.InetAddress;
import java.net.UnknownHostException;


/**
 * Created by wanghao on 2018/3/7.
 */
public class OperatorUtil {

    private static final String THIS_FILE = "OperatorUtil";

    /**
     * 判读是否网络已经连接成功
     *
     * @param context
     * @return true : 连接已经打开且已经连接成功; false:连接网络按钮处于关闭状态或者暂时网络未连接成功
     * <br/>
     * <b>note:该方法只是判断连接网络的按钮处于的状态，对于是否连接到对应的应用服务器该方法不适用<b/>
     */
    public static boolean isNetConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        boolean result = false;
        NetworkInfo mobNetInfo = connectivityManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
        if (mobNetInfo != null && mobNetInfo.isConnected()) {
            result = true;
        }
        NetworkInfo wifiNetInfo = connectivityManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
        if (wifiNetInfo != null && wifiNetInfo.isConnected()) {
            result = true;
        }
        return result;
    }

    /**
     * 获取运营商类型
     * 1，中国移动
     * 2，中国联通
     * 3，中国电信
     * 默认：中国移动
     *
     * @param context
     * @return
     */
    public static String getType(Context context) {
        if (isChinaMobile(context)) {
            return "1";
        } else if (isChinaUnicom(context)) {
            return "2";
        } else if (isChinaTelcome(context)) {
            return "3";
        } else {
            return "1";
        }
    }


    /**
     * 是否是移动网络
     *
     * @param context
     * @return
     */
    public static boolean isChinaMobile(Context context) {
        String IMSI = getIMSI(context);
        if (IMSI == null) {
            return false;
        } else if (IMSI.equals(IMSI_UNKNOWN)) {
            return getNetworkOperatorName(context).equals(OPE_NAME_CHINA_MOBILE)
                    || getNetworkOperator(context).equals(OPERATOR_CHINA_MOBILE);
        } else {
            return IMSI.startsWith(IMSI_CHINA_MOBILE_PREFIX) || IMSI.startsWith(IMSI_CHINA_MOBILE2_PREFIX) ||
                    IMSI.startsWith(IMSI_CHINA_MOBILE3_PREFIX);
        }
    }

    /**
     * 是否是中国联通
     *
     * @param context
     * @return
     */
    public static boolean isChinaUnicom(Context context) {
        String IMSI = getIMSI(context);
        if (IMSI == null) {
            return false;
        } else if (IMSI.equals(IMSI_UNKNOWN)) {
            return getNetworkOperatorName(context).equals(OPE_NAME_CHINA_UNICOM)
                    || getNetworkOperator(context).equals(OPERATOR_CHINA_UNICOM);
        } else {
            return getIMSI(context).startsWith(IMSI_CHINA_UNICOM_PREFIX) || getIMSI(context).startsWith(IMSI_CHINA_UNICOM2_PREFIX);
        }
    }

    /**
     * 是否是中国电信
     *
     * @param context
     * @return
     */
    public static boolean isChinaTelcome(Context context) {
        String IMSI = getIMSI(context);
        if (IMSI == null) {
            Log.e(THIS_FILE, "Get no imsi");
            return false;
        } else if (IMSI.equals(IMSI_UNKNOWN)) {
            Log.e(THIS_FILE, "Get imsi:unkown");
            return getNetworkOperatorName(context).equals(OPE_NAME_CHINA_TELECOM)
                    || getNetworkOperator(context).equals(OPERATOR_CHINA_TELECOM)
                    ;
        } else {
            Log.e(THIS_FILE, "Get imsi: " + IMSI);
            return getIMSI(context).startsWith(IMSI_CHINA_TELCOM_PREFIX) || getIMSI(context).startsWith(IMSI_CHINA_TELCOM2_PREFIX) ||
                    getIMSI(context).startsWith(IMSI_CHINA_TELCOM3_PREFIX);
        }
    }

    public static final String IMSI_UNKNOWN = "Unknown";

    //不同运营商IMSI的开头，例如一个完整的移动IMSI 460020604414143
    public static final String IMSI_CHINA_MOBILE_PREFIX = "46000";
    public static final String IMSI_CHINA_MOBILE2_PREFIX = "46002";
    public static final String IMSI_CHINA_MOBILE3_PREFIX = "46007";

    public static final String IMSI_CHINA_UNICOM_PREFIX = "46001";
    public static final String IMSI_CHINA_UNICOM2_PREFIX = "46006";

    public static final String IMSI_CHINA_TELCOM_PREFIX = "46003";
    public static final String IMSI_CHINA_TELCOM2_PREFIX = "46005";
    public static final String IMSI_CHINA_TELCOM3_PREFIX = "46011";

    /**
     * 获取IMSI
     * warning:某些情况下会获取
     *
     * @param context
     * @return
     */
    private static String getIMSI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String IMSI = telephonyManager.getSubscriberId();
//        Log.d("network imsi", IMSI);
//        Log.d("network operator name", telephonyManager.getNetworkOperatorName());
//        Log.d("network operator", telephonyManager.getNetworkOperator());
        return IMSI;
    }

    //    warning：有些手机读取不到IMSI，所以需要通过operatorName来判断
    //不同运营商的getNetworkOperatorName
    public static final String OPE_NAME_CHINA_MOBILE = "CMCC";
    public static final String OPE_NAME_CHINA_UNICOM = "CHN-UNICOM";
    public static final String OPE_NAME_CHINA_TELECOM = "CHN-CT";

    /**
     * 获取运营商名称
     *
     * @param context
     * @return
     */
    private static String getNetworkOperatorName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String name = telephonyManager.getNetworkOperatorName();
        return name;
    }

    //保险起见，还可以增加一个operator判断的分支
    public static final String OPERATOR_CHINA_MOBILE = "46000";
    public static final String OPERATOR_CHINA_UNICOM = "46001";
    public static final String OPERATOR_CHINA_TELECOM = "46011";

    /**
     * 获取运营商
     *
     * @param context
     * @return 注：结果肯定是一串数字
     */
    private static String getNetworkOperator(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String operator = telephonyManager.getNetworkOperator();
        return operator;
    }

    /**
     * 判断当前是否处于wifi环境下
     *
     * @param context
     * @return
     */
    public static boolean isWifi(Context context) {
        ConnectivityManager cm =
                (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        return cm != null
                && cm.getActiveNetworkInfo() != null
                && cm.getActiveNetworkInfo().getType() == ConnectivityManager.TYPE_WIFI;
    }


    /**
     * 解析域名
     *
     * @param domain 域名
     * @return <b>返回解析域名的ip地址或者null</b>
     */
    private static String getHostAddress(String domain) {
        if (domain == null) {
            return null;
        }
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(domain);
            if (inetAddress != null) {
                return inetAddress.getHostAddress();
            }
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }
}
