package ocr.util;

import android.content.Context;

import com.aircert.callback.CommonCallBackUtil;

import ocr.bean.IDCardInfo;


/**
 * Created by guoyaxin on 2017/11/22.
 */
public class IDCardManager {

    public interface IDCardListener {
        void onResult(IDCardInfo cardInfo);
    }

    public static IDCardListener idCardListener;

    /**
     * @param context
     * @param commonCallBackUtil
     * @param isNFC              是否是NFC
     */
    public void doIdentify(Context context, final CommonCallBackUtil<IDCardInfo> commonCallBackUtil, boolean isNFC) {

        IDCardListener idCardListener = new IDCardListener() {
            @Override
            public void onResult(IDCardInfo cardInfo) {
                commonCallBackUtil.call(cardInfo);
            }
        };
        IDCardManager.idCardListener = idCardListener;
//        if (isNFC){
//            context.startActivity(new Intent(context, NFCPresenter.class));
//        }else {
//            context.startActivity(new Intent(context, OcrPresenter.class));
//        }
    }


}
