/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import ocr.activity.AuthenticationFailActivity;
import okhttp3.Call;

public class PhoneApplyActivity
extends BaseActivity {
    private Button btn_submit;
    private EditText etPhone;
    private PinDialog pinDialog;
    public CryptoDevType cardType;
    public int containerNum;
    public String cardNum;
    public String certType;
    private boolean isVerifying = false;
    ExitHandler exitHandler = new ExitHandler((Activity)this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.cert_creation_activity_phone_apply_cert);
        this.verifyPin();
        this.initView();
    }

    protected int getTitleRes() {
        return -1;
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.cardType = (CryptoDevType)this.getIntent().getSerializableExtra("cardType");
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
        this.certType = this.getIntent().getStringExtra("certType");
    }

    private void initView() {
        this.etPhone = (EditText)this.findViewById(R.id.et_phone);
        this.etPhone.setFilters(EditTextUtil.getDisableEmojFilter());
        this.btn_submit = (Button)this.findViewById(R.id.btn_submit);
        this.btn_submit.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                PhoneApplyActivity.this.submit();
            }
        });
    }

    private void verifyPin() {
        if (this.cardType != CryptoDevType.DEV_TYPE_Soft || NetVHSMHandle.isNetVHSMCanUse()) {
            DeviceWrapper.getInstance();
            int pinResult = DeviceWrapper.verifyPin(this.cardType, this.containerNum, AppConfig.getInstance().getDefaultConfig().getPin());
            if (pinResult != 0) {
                this.pinDialog = new PinDialog((Context)this, this.cardType);
                this.pinDialog.show();
            }
        }
    }

    private void submit() {
        KeyboardUtils.hideKeyboard((View)this.etPhone);
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            String phone = this.etPhone.getText().toString();
            if (TextUtils.isEmpty((CharSequence)phone)) {
                ModuleToast.showNoRepeat(this.getContext(), R.string.cert_creation_not_null_phone_num);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                return;
            }
            this.verifyPhoneNum(phone);
            this.isVerifying = true;
        }
    }

    private void verifyPhoneNum(String phone) {
        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);
        this.showLoading();
        this.service.verifyPhoneNum(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                PhoneApplyActivity.this.isVerifying = false;
                PhoneApplyActivity.this.dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.showRequestError();
                PhoneApplyActivity.this.isVerifying = false;
                PhoneApplyActivity.this.dismissLoading();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                PhoneApplyActivity.this.isVerifying = false;
                String resultCode = commonResponse.getResult();
                if (resultCode.equals("0")) {
                    PhoneApplyActivity.this.startVerify();
                } else {
                    PhoneResult phoneResult = PhoneApplyActivity.this.buildPhoneResult(PhoneApplyActivity.this.getCardType(), PhoneApplyActivity.this.getCardNum(), commonResponse, null);
                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(PhoneApplyActivity.this.containerNum);
                    authResult.setPhoneResult(phoneResult);
                    OttoUtil.postPhoneAuthResult(authResult);
                    PhoneApplyActivity.this.finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.isVerifying = false;
            }

            @Override
            public void dismissDialog() {
                PhoneApplyActivity.this.dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {
        CompareResult result = new CompareResult();
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty((CharSequence)errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            result.setSuccess(true);
        }
        result.setIdentity(cardNum);
        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }

    private void startVerify() {
        if (this.cardType == null || TextUtils.isEmpty((CharSequence)this.cardNum)) {
            return;
        }
        String phoneNum = this.etPhone.getText().toString();
        SharePreferencesUtil.savePhone((Context)this, phoneNum);
        ApplyCertUtil.start((Context)this, this.containerNum, new ApplyCertUtil.WhatHappen(){

            @Override
            public void showDialog() {
            }

            @Override
            public void cancelDialog() {
            }

            @Override
            public void IOError() {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.dismissLoading();
                PhoneApplyActivity.this.showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                PhoneApplyActivity.this.finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                PhoneApplyActivity.this.handleError(baseErrorResponse);
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.exitHandler != null) {
            this.exitHandler.removeCallbacksAndMessages(null);
        }
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        AuthResult result = ApplyCertUtil.buildAuthResult(this.getCardType(), this.containerNum, this.getCardNum(), null, baseErrorResponse);
        if (baseErrorResponse.getErrCode().equals(OkNetError.ONE_CARD_TYPE_ONE_CERT_CODE)) {
            Intent intent = new Intent((Context)this, AuthenticationFailActivity.class);
            intent.putExtra("containerNum", this.containerNum);
            intent.putExtra("result", (Serializable)result.getResult());
            intent.putExtra("photoType", (Serializable)this.cardType);
            this.startActivity(intent);
        }
        OttoUtil.postAuthResult(result);
        OttoUtil.postFinishActivity();
        this.finish();
    }

    static class ExitHandler
    extends Handler {
        WeakReference<Activity> reference;

        ExitHandler(Activity activity) {
            this.reference = new WeakReference<Activity>(activity);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            Activity activity = (Activity)this.reference.get();
            if (activity == null) {
                return;
            }
            activity.finish();
        }
    }
}

