/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.CertDetailInfoActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.UpdateEventCode;
import com.xdja.safeclient.certcreation.bean.request.CertInfoUpdateRequest;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwd;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwdReq;
import com.xdja.safeclient.certcreation.bean.request.UpdateInfo;
import com.xdja.safeclient.certcreation.bean.request.UpdateUserInfo;
import com.xdja.safeclient.certcreation.bean.request.UpdateUserInfoReq;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyRAStatusResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.dialog.DeleteCertDialog;
import com.xdja.safeclient.certcreation.event.UpdateEvent;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ThreadUtil;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import okhttp3.Call;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class UpdateCertActivity
extends BaseActivity {
    private static final String TAG = "UpdateCertActivity";
    private RadioGroup updateRadioGroup;
    private EditText updateReasonText;
    private Button updateSubmitBtn;
    public ChipBean chipBean;
    private int containerNum;
    private CertDetailInfo certDetailInfo;
    private CryptoDevType chipBeanType;
    public String cardNum;
    private String newDN;
    UpdateCertPwd updateCertPwd = new UpdateCertPwd();
    UpdateCertPwdReq updateCertPwdReq = new UpdateCertPwdReq();

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.chipBean = (ChipBean)this.getIntent().getSerializableExtra("chipBean");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_update_cert);
        this.init();
        this.certDetailInfo = this.chipBean.getCertBean();
        this.chipBeanType = CryptoDevTypeUtil.formatType(this.chipBean.getType());
    }

    protected int getTitleRes() {
        return R.string.cert_creation_updateCert_title;
    }

    private void init() {
        this.updateRadioGroup = (RadioGroup)this.findViewById(R.id.update_choose);
        this.updateReasonText = (EditText)this.findViewById(R.id.update_reason_text);
        this.updateReasonText.setFilters(EditTextUtil.getDisableEmojFilter());
        this.updateSubmitBtn = (Button)this.findViewById(R.id.update_submit_btn);
        this.updateSubmitBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int updateChoose = UpdateCertActivity.this.updateRadioGroup.getCheckedRadioButtonId();
                UpdateEvent updateEvent = new UpdateEvent();
                if (TextUtils.isEmpty((CharSequence)UpdateCertActivity.this.updateReasonText.getText().toString())) {
                    ModuleToast.show(UpdateCertActivity.this.getContext(), R.string.cert_creation_update_reason_input);
                    return;
                }
                if (updateChoose == R.id.delayRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.DELAY_CERT.getType());
                    updateEvent.setReasonStr(UpdateCertActivity.this.updateReasonText.getText().toString());
                    UpdateCertActivity.this.reasonIsTemp(updateEvent);
                    ModuleLog.e((Object)"\u5ef6\u671f\u66f4\u65b0");
                }
                if (updateChoose == R.id.updateUserInfoRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.USERINFO_UPDATE.getType());
                    updateEvent.setReasonStr(UpdateCertActivity.this.updateReasonText.getText().toString());
                    UpdateCertActivity.this.reasonIsTemp(updateEvent);
                    ModuleLog.e((Object)"\u7528\u6237\u4fe1\u606f\u66f4\u65b0");
                }
                if (updateChoose == R.id.updateCertPwdRadio) {
                    UpdateCertActivity.this.deleteCertBeforeUpdate();
                }
            }
        });
    }

    private void deleteCertBeforeUpdate() {
        DeleteCertDialog dialog = new DeleteCertDialog();
        dialog.setListener(new DeleteCertDialog.OnClickListener(){

            @Override
            public void onPositive() {
                UpdateCertActivity.this.showLoading(R.string.cc_delete_cert);
                ClearContainerTask task = new ClearContainerTask();
                task.execute(new Object[0]);
            }
        });
        dialog.build(this.getContext());
        dialog.show();
    }

    private void updateKeyPair() {
        UpdateEvent updateEvent = new UpdateEvent();
        updateEvent.setUpdateType(UpdateEventCode.UPDATE_PWD.getType());
        updateEvent.setReasonStr(this.updateReasonText.getText().toString());
        this.reasonIsTemp(updateEvent);
    }

    private void readPubKey() {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.removeProvider("BC");
        Security.addProvider((Provider)provider);
        X509Certificate cert = DeviceWrapper.getInstance().getX509Certificate(DeviceWrapper.getInstance().readCertFromType(this.chipBeanType, this.containerNum), provider);
        if (cert != null) {
            ModuleLog.e((String)TAG, (Object)("\u66f4\u65b0\u524d\u8bc1\u4e66\u516c\u94a5" + cert.getPublicKey().toString()));
        }
    }

    private void update(UpdateEvent updateEvent) {
        CertInfoUpdateRequest certInfoUpdateRequest;
        this.showLoading(R.string.cert_creation_is_update_cert);
        int type = updateEvent.getUpdateType();
        String updateType = String.valueOf(type);
        String reason = updateEvent.getReasonStr();
        ModuleLog.e((String)TAG, (Object)("\u66f4\u65b0\u8bc1\u4e66\uff0c\u5f53\u524d\u7ebf\u7a0b\uff1a" + ThreadUtil.Companion.isMainThread()));
        if (type == UpdateEventCode.USERINFO_UPDATE.getType()) {
            certInfoUpdateRequest = this.getCertInfoUpdateRequest(updateType, reason);
            this.updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.DELAY_CERT.getType()) {
            certInfoUpdateRequest = this.getCertInfoUpdateRequest(updateType, reason);
            this.updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.UPDATE_PWD.getType()) {
            this.updateCertPwd(reason);
        }
    }

    private String getUserInfo() {
        UpdateUserInfoReq userInfoReq = new UpdateUserInfoReq();
        UpdateUserInfo userInfo = new UpdateUserInfo();
        userInfo.setSn(this.certDetailInfo.getSn());
        userInfo.setTime(System.currentTimeMillis());
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, userInfo.toString());
        userInfoReq.setInfo(userInfo);
        userInfoReq.setSign(sign);
        ModuleLog.e((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff1a " + userInfoReq.toString()));
        this.service.getUserInfo(userInfoReq, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.getContext()) ? R.string.net_disconnected_text : R.string.net_timeout;
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7ed3\u679c\uff1a" + result));
                if (result.equals("0")) {
                    UpdateCertActivity.this.newDN = commonResponse.getMessage();
                    ModuleLog.e((Object)("\u65b0\u7684\u7528\u6237\u4fe1\u606f\uff1a" + UpdateCertActivity.this.newDN));
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                ModuleLog.e((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7ed3\u679cerrorCode\uff1a" + errorCode));
            }

            @Override
            public void dismissDialog() {
            }
        });
        return this.newDN;
    }

    private void updateUserInfoOrDelay(CertInfoUpdateRequest certUpdateRequest) {
        ModuleLog.e((Object)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f " + certUpdateRequest.toString()));
        this.service.updateOrDelayCert(certUpdateRequest, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.getContext()) ? R.string.net_disconnected_text : R.string.net_timeout;
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e((Object)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f result = " + result));
                if (result.equals("0")) {
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0c\u670d\u52a1\u7aef\u5ba1\u6838\u4e2d");
                    OttoUtil.postCertUpdateResult(R.string.cert_creation_update_ing, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                    UpdateCertActivity.this.chipBean.setState(CertState.WAITING_VERIFY);
                    OttoUtil.postCertOperate(UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBean);
                    OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                } else if (result.equals("1")) {
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0c\u6210\u529f");
                    String certStr = commonResponse.getMessage();
                    ModuleToast.show(UpdateCertActivity.this.getContext(), "\u8bc1\u4e66\u66f4\u65b0\u6210\u529f");
                    OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                    OttoUtil.postWritUpdateCert(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, certStr, false);
                } else if (result.equals("2")) {
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0c\u62d2\u7edd");
                    String msg = commonResponse.getMessage();
                    ModuleToast.show(UpdateCertActivity.this.getContext(), msg);
                    ModuleToast.show(UpdateCertActivity.this.getContext(), msg);
                    OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_reject, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                } else if (result.equals("45")) {
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0cRA\u5ba1\u6838\u4e2d");
                    OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                    OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_wait, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                }
                UpdateCertActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                Log.e((String)"jff", (String)"405 UpdateCertActivity onFailResponse : ");
                UpdateCertActivity.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void initUpdatePairRequest(String reason) {
        this.updateCertPwd.setSn(this.certDetailInfo.getSn());
        this.updateCertPwd.setTime(System.currentTimeMillis());
        this.updateCertPwd.setReason(reason);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, this.updateCertPwd.toString());
        String p10 = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, this.certDetailInfo.getSubjectCn(), false);
        this.updateCertPwdReq.setInfo(this.updateCertPwd);
        this.updateCertPwdReq.setP10(p10);
        this.updateCertPwdReq.setSign(sign);
    }

    public boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    private void updateCertPwd(String reason) {
        String p10 = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, this.certDetailInfo.getSubjectCn(), true);
        this.updateCertPwdReq.setP10(p10);
        ModuleLog.e((Object)("\u66f4\u65b0\u5bc6\u94a5\u5bf9 " + this.updateCertPwdReq.toString()));
        ModuleLog.e((Object)("\u5f53\u524d\u7ebf\u7a0b" + this.isMainThread()));
        this.showLoading(R.string.cert_creation_is_update_cert);
        this.service.updateCertPwd(this.updateCertPwdReq, this.cardNum, new HttpResponseCallBack<CertApplyRAStatusResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.getContext()) ? R.string.net_disconnected_text : R.string.net_timeout;
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyRAStatusResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                if (result.equals("0")) {
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u66f4\u65b0\u5bc6\u94a5\u5bf9\uff0c\u670d\u52a1\u7aef\u5ba1\u6838\u4e2d");
                    OttoUtil.postUpdateKeyPairEvent(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, R.string.cert_creation_update_ing);
                } else if (result.equals("1")) {
                    String certStr = certApplyResponse.getMessage();
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u66f4\u65b0\u5bc6\u94a5\u5bf9\uff0c\u6210\u529f");
                    OttoUtil.postWritUpdateCert(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, certStr, true);
                } else if (result.equals("2")) {
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u5bc6\u94a5\u66f4\u65b0\uff0c\u88ab\u62d2\u7edd");
                    OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_reject, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                } else if (result.equals("45")) {
                    ModuleLog.d((String)UpdateCertActivity.TAG, (Object)"\u5bc6\u94a5\u66f4\u65b0\uff0cRA\u5ba1\u6838\u4e2d");
                    OttoUtil.postUpdateKeyPairEvent(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, R.string.cc_cert_pass_ra_wait);
                }
                OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                UpdateCertActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                UpdateCertActivity.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
                UpdateCertActivity.this.dismissLoading();
            }
        });
    }

    private void showException(String message) {
        ModuleToast.show((Context)this, message);
    }

    private void handleErrorResponse(String errorCode) {
        String msg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
        this.showException(msg);
        Log.e((String)"jff", (String)"533 UpdateCertActivity handleErrorResponse : ");
        OttoUtil.postRefreshListEvent();
        this.finish();
    }

    private CertInfoUpdateRequest getCertInfoUpdateRequest(String type, String reason) {
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setSn(this.certDetailInfo.getSn());
        updateInfo.setTime(System.currentTimeMillis());
        updateInfo.setType(type);
        updateInfo.setReason(reason);
        String p10 = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, this.certDetailInfo.getSubjectCn(), false);
        updateInfo.setP10(p10);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, updateInfo.toString());
        CertInfoUpdateRequest certUpdateRequest = new CertInfoUpdateRequest();
        certUpdateRequest.setSign(sign);
        certUpdateRequest.setInfo(updateInfo);
        return certUpdateRequest;
    }

    public void reasonIsTemp(UpdateEvent updateEvent) {
        this.update(updateEvent);
    }

    private class ClearContainerTask
    extends AsyncTask {
        int result;

        protected void onPreExecute() {
            super.onPreExecute();
            UpdateCertActivity.this.initUpdatePairRequest(UpdateCertActivity.this.updateReasonText.getText().toString());
        }

        protected Object doInBackground(Object[] objects) {
            this.result = DeviceWrapper.getInstance().clearContainer(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum);
            return this.result;
        }

        protected void onPostExecute(Object o) {
            super.onPostExecute(o);
            if (this.result == 0) {
                UpdateCertActivity.this.updateKeyPair();
            } else {
                ModuleToast.show(UpdateCertActivity.this.getContext(), "\u5220\u9664\u5931\u8d25" + this.result);
                UpdateCertActivity.this.dismissLoading();
            }
        }
    }
}

