/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EmbeddedCertAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<CertItemBean> certItemBeans = new ArrayList<CertItemBean>();
    private HashMap<String, Integer> cards = new HashMap();

    public EmbeddedCertAdapter(Context context, List<CertItemBean> certItemBeans) {
        this.context = context;
        this.certItemBeans = certItemBeans;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_list_layout_embedded, null);
        ViewHolder hold = new ViewHolder(view);
        return hold;
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        boolean isFirst;
        if (this.certItemBeans == null) {
            return;
        }
        if (this.certItemBeans.size() == 0) {
            return;
        }
        CertItemBean certItemBean = this.certItemBeans.get(position);
        CertDetailInfo info = DeviceWrapper.getInstance().readCertFromContainer(certItemBean.getCryptoDevInfo().getType(), certItemBean.getCertConfig().getContainerNum(), certItemBean.getCertConfig().getCertType());
        String cardType = this.certItemBeans.get(position).getCertConfig().getCardType();
        int current = this.certItemBeans.get(position).getCertConfig().getContainerNum();
        if (this.cards.get(cardType) == null) {
            isFirst = true;
            this.cards.put(cardType, current);
        } else {
            int min = this.cards.get(cardType);
            boolean bl = isFirst = current == min;
            if (current < min) {
                this.cards.put(cardType, current);
            }
        }
        if (isFirst) {
            holder.item.setVisibility(0);
        } else {
            holder.item.setVisibility(8);
        }
        CryptoDevType chipBeanType = certItemBean.getCryptoDevInfo().getType();
        if (chipBeanType == CryptoDevType.DEV_TYPE_SdCard) {
            holder.name.setText(R.string.cert_creation_tf_cert);
            holder.icon.setBackgroundResource(R.drawable.tf_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Chip) {
            holder.name.setText(R.string.cert_creation_chip_cert);
            holder.icon.setBackgroundResource(R.drawable.chip);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_SimKey) {
            holder.name.setText(R.string.cert_creation_tiemo_cert);
            holder.icon.setBackgroundResource(R.drawable.sim_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            holder.name.setText(R.string.cert_creation_soft_cert);
            holder.icon.setBackgroundResource(R.drawable.vhsm);
        }
        holder.cardNo.setText((CharSequence)certItemBean.getCryptoDevInfo().getCardId());
        holder.tvContainerNum.setText((CharSequence)(this.context.getString(R.string.cert_creation_config_container_num) + "\uff1a" + String.valueOf(certItemBean.getCertConfig().getContainerNum())));
        holder.tvCertType.setText((CharSequence)certItemBean.getCertConfig().getCertType());
        if (info == null) {
            holder.normalLayout.setVisibility(8);
            holder.noCertLayout.setVisibility(0);
            return;
        }
        holder.normalLayout.setVisibility(0);
        holder.noCertLayout.setVisibility(8);
        ModuleLog.e((Object)info);
        holder.tvSN.setText((CharSequence)info.getSn());
        holder.tvUser.setText((CharSequence)this.getCertHolder(info.getSubjectCn()));
        holder.tvPeroid.setText((CharSequence)info.getIndate());
    }

    public int getItemCount() {
        return this.certItemBeans == null ? 0 : this.certItemBeans.size();
    }

    public void addAll(List<CertItemBean> certItemBeans) {
        if (certItemBeans == null || certItemBeans.size() == 0) {
            return;
        }
        this.certItemBeans.clear();
        this.certItemBeans.addAll(certItemBeans);
        this.notifyDataSetChanged();
    }

    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; ++i) {
            String cnStr = split[i];
            if (!cnStr.contains("CN=")) continue;
            int beginIndex = 3;
            int length = cnStr.length();
            return split[i].substring(beginIndex, length);
        }
        return "";
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        View noCertLayout;
        View normalLayout;
        View stateLayout;
        View item;
        TextView name;
        ImageView icon;
        TextView cardNo;
        TextView tvContainerNum;
        TextView tvCertState;
        TextView tvCertType;
        TextView tvSN;
        TextView tvUser;
        TextView tvPeroid;

        public ViewHolder(View itemView) {
            super(itemView);
            this.noCertLayout = itemView.findViewById(R.id.layout_no_cert);
            this.normalLayout = itemView.findViewById(R.id.layout_normal);
            this.stateLayout = itemView.findViewById(R.id.layout_container_num);
            this.item = itemView.findViewById(R.id.item);
            this.name = (TextView)itemView.findViewById(R.id.name);
            this.icon = (ImageView)itemView.findViewById(R.id.icon);
            this.cardNo = (TextView)itemView.findViewById(R.id.card_num);
            this.tvContainerNum = (TextView)itemView.findViewById(R.id.tv_container_num);
            this.tvCertState = (TextView)itemView.findViewById(R.id.tv_cert_state);
            this.tvCertType = (TextView)itemView.findViewById(R.id.tv_cert_type);
            this.tvSN = (TextView)itemView.findViewById(R.id.tv_sn);
            this.tvUser = (TextView)itemView.findViewById(R.id.tv_user);
            this.tvPeroid = (TextView)itemView.findViewById(R.id.tv_peroid);
        }
    }
}

