/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.cache;

import com.xdja.cryptodev.CryptoDevType;
import java.util.HashMap;

public class RequestCache {
    private HashMap<String, String> types = new HashMap();
    private long time;
    private static RequestCache cache;
    private String object;

    public static RequestCache getInstance() {
        if (cache == null) {
            cache = new RequestCache();
        }
        return cache;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void putType(String cardNo, int cardType) {
        this.types.put(cardNo, RequestCache.formatType(cardType));
    }

    private static String formatType(int type) {
        if (type == CryptoDevType.DEV_TYPE_SdCard.getType()) {
            return "sd\u5361";
        }
        if (type == CryptoDevType.DEV_TYPE_Chip.getType()) {
            return "\u82af\u7247";
        }
        if (type == CryptoDevType.DEV_TYPE_UsbKey.getType()) {
            return "USB Key";
        }
        if (type == CryptoDevType.DEV_TYPE_SimKey.getType()) {
            return "\u8d34\u819c\u5361";
        }
        if (type == CryptoDevType.DEV_TYPE_BlueTooth.getType()) {
            return "\u84dd\u7259";
        }
        if (type == CryptoDevType.DEV_TYPE_Soft.getType()) {
            return "\u8f6f\u8bc1\u4e66";
        }
        return "\u4f4d\u7f6e\u7c7b\u578b" + type;
    }

    public String getType(String cardNo) {
        String result = this.types.get(cardNo);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void resetTime() {
        this.time = 0L;
    }
}

