/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.service;

import com.xdja.https.module.HttpClientManager;
import com.xdja.https.module.bean.HttpsParam;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.util.DebugAbleUtils;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class HttpClientHelper {
    private static OkHttpClient okHttpClient = null;

    public static void initOkHttpClient() {
        if (okHttpClient == null) {
            HttpsParam httpsParam = HttpClientHelper.generateHttpsParam();
            try {
                okHttpClient = HttpClientManager.getInstance().createHttpClient(httpsParam);
                if (DebugAbleUtils.isApkInDebug(AppConfig.getInstance().getContext())) {
                    OkHttpClient.Builder builder = okHttpClient.newBuilder();
                    HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                    logging.setLevel(HttpLoggingInterceptor.Level.BODY);
                    builder.addInterceptor((Interceptor)logging);
                    okHttpClient = builder.build();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static OkHttpClient getOkHttpClient() {
        return okHttpClient;
    }

    private static HttpsParam generateHttpsParam() {
        HttpsParam httpsParam = new HttpsParam();
        httpsParam.setSupportHttps(true);
        httpsParam.setServerCertAccessPwd(AppConfig.getInstance().getDefaultConfig().getBksVerifyCode().toCharArray());
        httpsParam.setServerCertInputStream(AppConfig.getInstance().getContext().getResources().openRawResource(R.raw.truststore));
        return httpsParam;
    }
}

