/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.dialog.SinglePermissionDialog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.Serializable;

public class CameraReadyActivity
extends BaseActivity {
    public int photoType;
    String cardNum;
    CryptoDevType cardType;
    String phone;
    public int containerNum;
    TextView tv_tips1;
    public static final int PERMISSION_CODE = 23;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_camera_ready);
        this.hideBG();
        this.cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType((Context)this));
        this.cardNum = DeviceWrapper.getInstance().getCardID(this.cardType);
        this.phone = SharePreferencesUtil.getPhoneNum((Context)this);
        if (TextUtils.isEmpty((CharSequence)this.cardNum)) {
            ModuleToast.show((Context)this, R.string.cert_creation_card_device_error);
            return;
        }
        Button bt_startdect = (Button)this.findViewById(R.id.start);
        bt_startdect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ContextCompat.checkSelfPermission((Context)CameraReadyActivity.this, (String)"android.permission.CAMERA") != 0) {
                    ActivityCompat.requestPermissions((Activity)CameraReadyActivity.this, (String[])new String[]{"android.permission.CAMERA"}, (int)23);
                } else {
                    CameraReadyActivity.this.route();
                }
            }
        });
        this.tv_tips1 = (TextView)this.findViewById(R.id.hint1);
        if (ScreenUtil.isFullScreen((Activity)this)) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(0, ScreenUtil.dip2px((Context)this, 50.0f), 0, 0);
            layoutParams.addRule(14);
            this.tv_tips1.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Override
    public boolean valid() {
        return ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == 0;
    }

    @Override
    public String nextActivity() {
        return "/cert/selfie";
    }

    @Override
    public void route() {
        super.route();
        Intent intent = new Intent((Context)this, SelfieActivity.class);
        intent.putExtra("photoType", this.photoType);
        intent.putExtra("cardNum", this.cardNum);
        intent.putExtra("cardType", (Serializable)this.cardType);
        intent.putExtra("phone", this.phone);
        intent.putExtra("containerNum", this.containerNum);
        this.startActivity(intent);
    }

    protected void onResume() {
        super.onResume();
        this.left_title_tv.setText(R.string.cert_creation_selfie_photo_ready_title);
    }

    protected void onPause() {
        super.onPause();
        this.left_title_tv.setText((CharSequence)"");
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (permissions[0].equals("android.permission.CAMERA") && grantResults[0] == 0) {
            this.next();
        } else {
            SinglePermissionDialog dialog = new SinglePermissionDialog();
            dialog.build((Context)this, 2);
            dialog.show();
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_selfie_photo_ready_title;
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity activity) {
        this.finish();
    }
}

