/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Base64;
import cn.cloudwalk.libproject.util.NetUtil;
import com.xdja.nfcoperate.bean.CardInfo;
import com.xdja.nfcoperate.callback.IDCardInfoCallback;
import com.xdja.nfcoperate.operate.cardinfo.CardInfoInit;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import ocr.activity.NFCActivity;
import ocr.activity.XDJANFCIDCardActivity;
import ocr.bean.IDCardInfo;
import ocr.command.NFCCommand;
import ocr.command.NetErrorCommand;
import ocr.util.Convert;

public class XDJANFCActivity
extends NFCActivity
implements IDCardInfoCallback,
NFCCommand,
NetErrorCommand {
    protected static final int MESSAGE_TIMEOUT = 14;
    protected static final int MESSAGE_INVALID_NFC = 15;
    protected static final int MESSAGE_VALID_NFC = 16;
    private CardInfoInit mInit;
    private int containerNum;
    protected String liveFaceImg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_nfc);
        this.showNormalFragment();
        this.mInit = new CardInfoInit((IDCardInfoCallback)this);
        this.mInit.getCardInfo(this.getIntent());
        this.getData();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.mInit != null) {
            this.mInit.getCardInfo(intent);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (this.mInit != null) {
            this.mInit.onResume();
            switch (this.mInit.detectionNFC(this.getContext())) {
                case -2: {
                    ModuleToast.show((Context)this, R.string.cert_creation_open_nfc);
                    break;
                }
                case -1: {
                    ModuleToast.show((Context)this, R.string.cert_creation_not_support_nfc);
                    this.finish();
                }
            }
            if (!this.mInit.isNetWorkConnect()) {
                this.showNetworkErrFragment();
            }
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mInit != null) {
            this.mInit.onPause();
        }
    }

    @Override
    public int getNFCState() {
        if (this.mInit == null) {
            return -2;
        }
        int state = this.mInit.detectionNFC(this.getContext());
        if (state == -2) {
            return -1;
        }
        if (state == -1) {
            return -2;
        }
        return 0;
    }

    @Override
    public void openNFC() {
        Intent intent = new Intent("android.settings.NFC_SETTINGS");
        this.startActivity(intent);
    }

    @Override
    public void retry() {
        if (!NetUtil.isConnected((Context)this)) {
            ModuleToast.show((Context)this, R.string.net_disconnected_text);
        } else {
            this.retryResume();
        }
    }

    private void retryResume() {
        this.showNormalFragment();
        if (this.mInit != null) {
            this.mInit.onResume();
            switch (this.mInit.detectionNFC(this.getContext())) {
                case -2: {
                    ModuleToast.show((Context)this, R.string.cert_creation_open_nfc);
                    break;
                }
                case -1: {
                    ModuleToast.show((Context)this, R.string.cert_creation_not_support_nfc);
                    this.finish();
                }
            }
        }
    }

    @Override
    public int getErrorMsg() {
        return R.string.net_disconnected_text;
    }

    public void getCardInfo(int i, CardInfo cardInfo) {
        if (!this.mInit.isNetWorkConnect()) {
            this.showNetworkErrFragment();
            return;
        }
        if (i == 16) {
            this.getDataInfoSuccess(cardInfo);
        } else if (i == 14) {
            ModuleToast.show((Context)this, R.string.net_timeout);
        } else if (i == 15) {
            ModuleToast.show((Context)this, R.string.cert_creation_get_data_fail);
        }
    }

    private void getDataInfoSuccess(CardInfo cardInfo) {
        if (cardInfo != null && cardInfo.getName() != null) {
            IDCardInfo id2 = Convert.cardInfoToIdentifyInfo(cardInfo);
            String base64 = Base64.encodeToString((byte[])this.getBytesByBitmap(cardInfo.getPhoto()), (int)0);
            ImageCache.getInstance().setNfcFaceImgStr(base64);
            ImageCache.getInstance().setNfcFaceImg(cardInfo.getPhoto());
            Bundle others = new Bundle();
            others.putParcelable("identify_info", (Parcelable)id2);
            Intent intent = new Intent((Context)this, XDJANFCIDCardActivity.class);
            others.putInt("containerNum", this.containerNum);
            intent.putExtras(others);
            this.startActivity(intent);
            this.finish();
        } else {
            ModuleToast.show((Context)this, R.string.cert_creation_get_data_fail);
        }
    }

    @Override
    public void getData() {
        Bundle others = this.getIntent().getExtras();
        if (others != null) {
            this.containerNum = others.getInt("containerNum");
        }
    }

    public byte[] getBytesByBitmap(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    @Override
    public Context getContext() {
        return this;
    }

    public PendingIntent getPendingIntent() {
        return PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, XDJANFCActivity.class).addFlags(0x20000000), (int)0);
    }
}

