/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.aircert.util.ModuleLog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import ocr.activity.AuthenticationFailActivity;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

public class XDJAOCRIDCardActivity
extends BaseActivity {
    public int containerNum;
    public String name;
    public String gender;
    public String idNum;
    public String faceImg;
    private EditText etName;
    private TextView tvGender;
    private TextView tvID;
    private Button btnNext;
    private Button btnAgain;
    private IDCardInfo info = new IDCardInfo();
    private ExitHandler exitHandler = new ExitHandler((Activity)this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_xdja_ocr_id_card);
        this.etName = (EditText)this.findViewById(R.id.et_name);
        this.etName.setText((CharSequence)this.name);
        this.etName.setFilters(EditTextUtil.getHanziFilter(14));
        this.tvGender = (TextView)this.findViewById(R.id.tv_gender);
        this.tvGender.setText((CharSequence)this.gender);
        this.tvID = (TextView)this.findViewById(R.id.tv_id);
        this.tvID.setText((CharSequence)this.idNum);
        this.btnNext = (Button)this.findViewById(R.id.btn_next);
        this.btnNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!ValidUtil.name(XDJAOCRIDCardActivity.this.etName.getText().toString())) {
                    KeyboardUtils.hideKeyboard((Activity)XDJAOCRIDCardActivity.this);
                    ModuleToast.show(XDJAOCRIDCardActivity.this.getContext(), R.string.cert_creation_invalid_name_length);
                    return;
                }
                XDJAOCRIDCardActivity.this.request();
            }
        });
        this.btnAgain = (Button)this.findViewById(R.id.btn_again);
        this.btnAgain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                KeyboardUtils.hideKeyboard((Activity)XDJAOCRIDCardActivity.this);
                XDJAOCRIDCardActivity.this.finish();
            }
        });
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        Intent intent = this.getIntent();
        this.name = intent.getStringExtra("name");
        this.gender = intent.getStringExtra("gender");
        this.idNum = intent.getStringExtra("idNum");
        this.containerNum = intent.getIntExtra("containerNum", 0);
        this.faceImg = intent.getStringExtra("faceImg");
    }

    protected int getTitleRes() {
        return R.string.cert_creation_identify_result_title;
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }

    private void request() {
        final int devType = SharePreferencesUtil.getCurrentDevType((Context)this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        if (TextUtils.isEmpty((CharSequence)cardID)) {
            ModuleToast.show(this.getContext(), R.string.cert_creation_card_device_error);
            return;
        }
        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = this.buildRequest();
        this.showLoading();
        this.service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e((Object)"other exception");
                compareResult.setResult("");
                compareResult.setMessage(XDJAOCRIDCardActivity.this.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(XDJAOCRIDCardActivity.this.idNum);
                XDJAOCRIDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                XDJAOCRIDCardActivity.this.finish();
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e((Object)"io exception");
                compareResult.setResult("");
                compareResult.setMessage(XDJAOCRIDCardActivity.this.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(XDJAOCRIDCardActivity.this.idNum);
                XDJAOCRIDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                SharePreferencesUtil.saveIDCardNo(XDJAOCRIDCardActivity.this.getContext(), devType, XDJAOCRIDCardActivity.this.idNum);
                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(XDJAOCRIDCardActivity.this.idNum);
                compareResult.setSuccess(true);
                if (commonResponse.getResult().equals("2")) {
                    XDJAOCRIDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, XDJAOCRIDCardActivity.this.containerNum, compareResult, RequestCache.getInstance().getObject());
                    OttoUtil.postAuthResult(auth);
                }
                XDJAOCRIDCardActivity.this.exitHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        OttoUtil.postFinishActivity();
                        OttoUtil.postFinishYishuNFC();
                        XDJAOCRIDCardActivity.this.finish();
                    }
                }, 0L);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(XDJAOCRIDCardActivity.this.idNum);
                compareResult.setSuccess(false);
                XDJAOCRIDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                XDJAOCRIDCardActivity.this.finish();
            }

            @Override
            public void dismissDialog() {
                XDJAOCRIDCardActivity.this.dismissLoading();
            }
        });
    }

    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {
        Intent intent = new Intent((Context)this, AuthenticationFailActivity.class);
        intent.putExtra("result", (Serializable)result);
        intent.putExtra("devType", (Serializable)type);
        intent.putExtra("identify_info", (Parcelable)this.info);
        intent.putExtra("faceImg", this.faceImg);
        intent.putExtra("containerNum", this.containerNum);
        this.startActivity(intent);
    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType((Context)this)));
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum((Context)this));
        if (AppConfig.getInstance().getCertConfig().getVHSMType().equals("VHSM")) {
            chipInfo.setVhsmType("1");
            chipInfo.setImei(DeviceWrapper.getInstance().getIMEI());
        } else {
            chipInfo.setImei(deviceWrapper.getIMEI());
        }
        this.info.setName(this.name);
        this.info.setSex(this.gender.equals("\u7537") ? 1 : 2);
        this.info.setIdNum(this.idNum);
        request.setIdCardInfo(this.info);
        request.setChipInfo(chipInfo);
        request.setFaceImg(this.faceImg);
        int type = SharePreferencesUtil.getCurrentDevType((Context)this);
        CryptoDevType cardType = CryptoDevTypeUtil.formatType(type);
        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, this.containerNum));
        ModuleLog.e((Object)request.toString());
        return request;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.exitHandler.removeCallbacksAndMessages(null);
    }

    static class ExitHandler
    extends Handler {
        WeakReference<Activity> reference;

        ExitHandler(Activity activity) {
            this.reference = new WeakReference<Activity>(activity);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            Activity activity = (Activity)this.reference.get();
            if (activity == null) {
                return;
            }
            activity.finish();
        }
    }
}

