/*
 * Decompiled with CFR 0.152.
 */
package yishu.nfc.YSnfcCardReader;

import android.app.Activity;
import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.NfcB;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.Log;
import com.ivsign.android.IDCReader.IDCReaderSDK;
import com.ivsign.android.IDCReader.SPUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import yishu.bluetooth.YSBluetoothCardReader.IdentityCard;

public class NFCardReader {
    public static String remoteIP = "";
    public static String remoteIPA = "";
    public static String remoteIPB = "";
    public static String remoteIPC = "";
    public static String recvfilename = "";
    public static String nametext = "";
    public static String sextext = "";
    public static int sexint = 0;
    public static int mingzuint = 0;
    public static String mingzutext = "";
    public static String birthdaytext = "";
    public static String addresstext = "";
    public static String numbertext = "";
    public static String qianfatext = "";
    public static String starttext = "";
    public static String endtext = "";
    public static byte[] recvbyterecvbmp = new byte[40960];
    public static String dncodetext = "";
    public static int fileport = 9007;
    public static int assignport = 17278;
    public int sockid = 0;
    public int TcpConnectFlag = 0;
    public int pathflag = 1;
    public int usbpreflag = 0;
    private NfcB isodep = null;
    boolean isc;
    private static int ipreadnumb = 0;
    private Context thiscontext;
    private Activity activity;
    private final int VendorID = 38259;
    private final int ProductID = 18486;
    private final Handler mHandler;
    public int logflag = 0;
    private NfcAdapter mAdapter = null;
    private PendingIntent pi = null;
    private IntentFilter tagDetected = null;
    private String[][] mTechLists;
    private Intent intentin;
    private String userid = "000000";
    public int processline = 0;
    public int processflag = 1;
    public int reprocessflag = 0;
    private SPUtil spUtil;
    private String licenseLic = "76BBDE3633F5AE47359E2B3C7EFBBC3AA1AF4D712E7C61D3DBA003C69040C0AB";
    private String baseDat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
    static final String FOLDER = "/yishu/";
    static final String FILENAME = "yishu";
    static final String SUFFIX = ".txt";
    private char rightchar = (char)32;
    private static int wordsport;
    private static String wordsip;
    private static int wordsipsetflag;
    private static int wordstest;

    static {
        System.loadLibrary("nfcjni");
        wordsport = 20222;
        wordsip = "192.168.1.1";
        wordsipsetflag = 0;
        wordstest = 0;
    }

    public NFCardReader(Handler mhandlein, Context context) {
        this.thiscontext = context;
        this.mHandler = mhandlein;
        this.writeFile("pass new test 2.1");
        NFCardReader.isExist("/sdcard/yishu");
        this.spUtil = new SPUtil(context);
        this.writeFile("pass new test 2.2");
    }

    public String getServerAddress() {
        return this.spUtil.getRemoteIp();
    }

    public int getServerPort() {
        return this.spUtil.getRemotePort();
    }

    public void setport(int portin) {
        assignport = portin;
    }

    private String getIP(String name) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(name);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (address != null) {
            return address.getHostAddress().toString();
        }
        return "103.21.119.78";
    }

    private static void isExist(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public void setpathflag(int pathflagin) {
        this.pathflag = pathflagin;
    }

    public void setlogflag(int logflagin) {
        this.logflag = logflagin;
    }

    public void setTheServer(String serverAddress, int serverPort) {
        remoteIP = serverAddress;
        assignport = serverPort;
        this.spUtil.putRemoteServer(serverAddress, serverPort);
    }

    public Boolean EnableSystemNFCMessage() {
        this.writeFile("pass new test 2.6");
        this.mAdapter = NfcAdapter.getDefaultAdapter((Context)this.thiscontext);
        this.writeFile("pass new test 2.2");
        if (this.mAdapter == null) {
            this.writeFile("pass new test 2.3");
            return false;
        }
        this.writeFile("pass new test 2.4");
        if (!this.mAdapter.isEnabled()) {
            return false;
        }
        this.init_NFC();
        this.writeFile("pass new test 2.5");
        if (this.mAdapter == null) {
            this.writeFile("pass new test EnableSystemNFCMessage 2.31");
            return false;
        }
        this.writeFile("pass new test EnableSystemNFCMessage 2.41");
        this.startNFC_Listener();
        this.writeFile("pass new test EnableSystemNFCMessage 2.51");
        this.writeFile("pass new test 2.7");
        return true;
    }

    public void startNFC_Listener() {
        this.mAdapter.enableForegroundDispatch((Activity)this.thiscontext, this.pi, new IntentFilter[]{this.tagDetected}, this.mTechLists);
    }

    public void stopNFC_Listener() {
        this.mAdapter.disableForegroundDispatch((Activity)this.thiscontext);
    }

    public void init_NFC() {
        this.pi = PendingIntent.getActivity((Context)this.thiscontext, (int)0, (Intent)new Intent(this.thiscontext, this.thiscontext.getClass()).addFlags(0x20000000), (int)0);
        this.tagDetected = new IntentFilter("android.nfc.action.TAG_DISCOVERED");
        this.tagDetected.addCategory("android.intent.category.DEFAULT");
        this.mTechLists = new String[][]{{NfcB.class.getName()}};
    }

    public Boolean isNFC(Intent intent) {
        String action = intent.getAction();
        this.writeFile("pass onNewIntent 1 ");
        this.writeFile("pass onNewIntent 1.111111 action=" + action);
        if ("android.nfc.action.TECH_DISCOVERED".equals(action)) {
            this.writeFile("pass onNewIntent 2 ");
            return true;
        }
        return false;
    }

    public void NFCreadCardFast(Intent intent) {
        this.intentin = intent;
        new Thread(){

            @Override
            public void run() {
                NFCardReader.this.JLreadCardWithIntentnew(NFCardReader.this.intentin);
            }
        }.start();
    }

    private void JLreadCardWithIntentnew(Intent intent) {
        this.writeFile("Log:Value Of intent = " + intent);
        int rnt = 0;
        Message msg = new Message();
        msg.what = 10000001;
        this.mHandler.sendMessage(msg);
        Tag tagFromIntent = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        this.writeFile("Log:Value Of tagFromIntent = " + tagFromIntent);
        try {
            this.writeFile("pass JLreadCardWithIntentnew 3 ");
            this.isodep = NfcB.get((Tag)tagFromIntent);
            this.writeFile("pass JLreadCardWithIntentnew 3.1 ");
            this.isodep.connect();
            this.writeFile("pass JLreadCardWithIntentnew 3.2 ");
            rnt = 0;
            msg = new Message();
            this.processline = 0;
            this.writeFile("pass JLreadCardWithIntentnew 3.3.1 ");
            rnt = this.JLNfcReadCardact(this.isodep, 1);
            this.writeFile("pass JLreadCardWithIntentnew 1 rnt=" + rnt);
            this.isodep.close();
        }
        catch (Exception e) {
            this.writeFile("pass JLreadCardWithIntentnew 8 ERROR:" + e.getMessage());
            rnt = 41;
        }
        if (rnt == 90) {
            this.writeFile("pass JLreadCardWithIntentnew 4 ");
            IdentityCard identityCard = new IdentityCard();
            this.writeFile("pass JLreadCardWithIntentnew 5 ");
            identityCard.name = nametext;
            identityCard.sex = sextext;
            identityCard.ethnicity = mingzutext;
            identityCard.birth = birthdaytext;
            identityCard.address = addresstext;
            identityCard.cardNo = numbertext;
            identityCard.authority = qianfatext;
            identityCard.period = String.valueOf(starttext) + "-" + endtext;
            identityCard.DN = dncodetext;
            this.writeFile("pass JLreadCardWithIntentnew 6 ");
            msg = new Message();
            msg.what = 30000003;
            msg.obj = identityCard;
            msg.arg1 = 100;
            this.mHandler.sendMessage(msg);
            this.writeFile("pass JLreadCardWithIntentnew 7 ");
        } else if (rnt == 42) {
            String Errorcode = "\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01";
            msg = new Message();
            msg.what = 90000009;
            msg.arg1 = -11;
            msg.obj = Errorcode;
            this.mHandler.sendMessage(msg);
        } else if (rnt == 43) {
            String Errorcode = "\u670d\u52a1\u5668\u5fd9\uff01";
            msg = new Message();
            msg.what = 90000009;
            msg.arg1 = -12;
            msg.obj = Errorcode;
            this.mHandler.sendMessage(msg);
        } else {
            String Errorcode = "\u51fa\u73b0\u9519\u8bef\u9700\u8981\u91cd\u8bd5\uff01";
            msg = new Message();
            msg.what = 90000009;
            msg.arg1 = -7;
            msg.obj = Errorcode;
            this.mHandler.sendMessage(msg);
        }
    }

    public void DisableSystemNFCMessage() {
        if (this.mAdapter != null) {
            this.stopNFC_Listener();
        }
    }

    public void setprocessflag(int inprocessflag) {
        this.processflag = inprocessflag;
    }

    public void setreprocessflag(int inreprocessflag) {
        this.reprocessflag = inreprocessflag;
    }

    public static int inttrans(char s) {
        if (s == '0') {
            return 0;
        }
        if (s == '1') {
            return 1;
        }
        if (s == '2') {
            return 2;
        }
        if (s == '3') {
            return 3;
        }
        if (s == '4') {
            return 4;
        }
        if (s == '5') {
            return 5;
        }
        if (s == '6') {
            return 6;
        }
        if (s == '7') {
            return 7;
        }
        if (s == '8') {
            return 8;
        }
        if (s == '9') {
            return 9;
        }
        if (s == 'a') {
            return 10;
        }
        if (s == 'b') {
            return 11;
        }
        if (s == 'c') {
            return 12;
        }
        if (s == 'd') {
            return 13;
        }
        if (s == 'e') {
            return 14;
        }
        if (s == 'f') {
            return 15;
        }
        if (s == 'A') {
            return 10;
        }
        if (s == 'B') {
            return 11;
        }
        if (s == 'C') {
            return 12;
        }
        if (s == 'D') {
            return 13;
        }
        if (s == 'E') {
            return 14;
        }
        if (s == 'F') {
            return 15;
        }
        return 0;
    }

    public int JLNfcReadCardact(NfcB isodep, int servicemode) {
        int count;
        FileOutputStream fos;
        InputStream is;
        this.writeFile("pass 3.0001");
        this.writeprocess("1");
        byte[] buffer = new byte[64];
        String licenseDat = "294E3B925528DE3907F1049156E29528B675E5668EA26EE53FCCD66B90FF406F93FBC1A418C3AC5D4845085217AFF9F3068A1939839E0BDDB51E841D8093167D";
        int tempinlen = licenseDat.length();
        char strInput2 = '0';
        char strInput3 = '0';
        int strint2 = NFCardReader.inttrans(strInput2);
        int strint3 = NFCardReader.inttrans(strInput3);
        byte[] tempInput = new byte[tempinlen / 2];
        int seq = 0;
        int j = 0;
        while (j < tempinlen) {
            strInput2 = licenseDat.charAt(j);
            if (j + 1 < tempinlen) {
                strInput3 = licenseDat.charAt(j + 1);
            }
            strint2 = NFCardReader.inttrans(strInput2);
            strint3 = NFCardReader.inttrans(strInput3);
            if (seq < tempinlen / 2) {
                tempInput[seq] = (byte)(strint2 * 16 + strint3);
            }
            ++seq;
            j += 2;
        }
        buffer = tempInput;
        remoteIP = this.getServerAddress();
        assignport = this.getServerPort();
        this.writeprocess("1");
        this.writeFile("pass 4.0002");
        this.writeFile("pass 5.1, remoteIP=" + remoteIP);
        this.writeFile("pass 5.1.1, assignport=" + assignport);
        this.writeprocess("1");
        this.writeFile("Pass Here 5 1.");
        this.writeFile("pass 7");
        String filename = "";
        filename = this.pathflag == 1 ? this.thiscontext.getApplicationContext().getFilesDir().getAbsolutePath() : "/sdcard/yishu";
        String Imei = Settings.System.getString((ContentResolver)this.thiscontext.getContentResolver(), (String)"android_id");
        if (Imei == null) {
            Imei = "";
        }
        this.writeFile("pass 7.11");
        this.writeprocess("1");
        int offset = 0;
        offset = this.NfccallJNIconnectprocess(remoteIP, assignport, buffer, filename, Imei, this.userid);
        this.writeFile("pass 7.12 0");
        this.writeFile("pass 7.12, offset=" + offset);
        if (offset == 0) {
            return 42;
        }
        if (offset == -8) {
            return 43;
        }
        if (offset == -1000) {
            this.writeFile("Log:Because Of offset = -1000");
            return 41;
        }
        if (offset == -6000) {
            this.writeFile("Log:Because Of offset = -6000");
            return 41;
        }
        if ((offset = this.NfcPROfirstprocess(remoteIP, assignport, buffer, filename, offset, 0, Imei, "11", "1111", "1111", "1111", "1111", "1111", 5)) <= 0) {
            this.writeFile("Log:Because Of NfcPROfirstprocess offset <= 0");
            return 41;
        }
        byte[] recvresult = this.NfcPROsecondprocess(offset, 1);
        this.writeFile("pass callJNIByteusbwrite recvresult=" + NFCardReader.printHexString(recvresult));
        if (recvresult[0] != 1) {
            this.writeFile("Log:Because Of offset recvresult[0] != (byte) 0x01");
            return 41;
        }
        byte[] inbytes1 = new byte[256];
        int i = 0;
        while (i < 256) {
            inbytes1[i] = recvresult[2 + i];
            ++i;
        }
        this.writeFile("pass callJNIByteusbwrite inbytes1=" + NFCardReader.printHexString(inbytes1));
        this.writeFile("pass callJNIsecondprocess 1000");
        this.writeFile("pass callJNIsecondprocess 1001");
        this.writeprocess("1");
        String recvmessage = "";
        try {
            recvmessage = new String(inbytes1, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            this.writeFile("Log@@:out/01");
            e.printStackTrace();
        }
        this.writeprocess("1");
        this.writeFile("pass 88 recvmessage=" + recvmessage);
        boolean flagofzero = false;
        byte[] namebyte = new byte[60];
        int i2 = 0;
        while (i2 < 30) {
            if (inbytes1[i2] == 0) {
                if (flagofzero) {
                    this.writeFile("Log@@:out/02");
                    break;
                }
                flagofzero = true;
            } else {
                flagofzero = false;
            }
            namebyte[i2] = inbytes1[i2];
            ++i2;
        }
        String bnametext = "";
        try {
            bnametext = new String(namebyte, "UnicodeLittleUnmarked");
            this.writeFile("Log@@:bnametext=" + bnametext);
        }
        catch (UnsupportedEncodingException e) {
            this.writeFile("Log@@:out/03");
            e.printStackTrace();
        }
        nametext = "";
        int i3 = 0;
        while (i3 < bnametext.length()) {
            this.isc = NFCardReader.isChinese(bnametext.charAt(i3));
            nametext = this.isc ? String.valueOf(nametext) + bnametext.charAt(i3) : (NFCardReader.isNumber(bnametext.charAt(i3)) ? String.valueOf(nametext) + bnametext.charAt(i3) : (this.isChineseLP(i3 + 1, namebyte) ? String.valueOf(nametext) + this.rightchar : String.valueOf(nametext) + ' '));
            ++i3;
        }
        nametext = bnametext.trim();
        this.writeFile("Log@@:nametext=" + nametext);
        byte[] sexbyte = new byte[60];
        int i4 = 0;
        while (i4 < 2) {
            sexbyte[i4] = inbytes1[i4 + 30];
            ++i4;
        }
        String bsextext = "";
        try {
            bsextext = new String(sexbyte, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sextext = NFCardReader.getSex(bsextext.trim());
        sexint = NFCardReader.getSexint(bsextext.trim());
        byte[] mingzubyte = new byte[60];
        int i5 = 0;
        while (i5 < 4) {
            mingzubyte[i5] = inbytes1[i5 + 30 + 2];
            ++i5;
        }
        String bmingzutext = "";
        try {
            bmingzutext = new String(mingzubyte, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        mingzutext = NFCardReader.getMinZu(bmingzutext.trim());
        mingzuint = NFCardReader.getMinZuint(bmingzutext.trim());
        byte[] birthdaybyte = new byte[60];
        int i6 = 0;
        while (i6 < 16) {
            birthdaybyte[i6] = inbytes1[i6 + 30 + 2 + 4];
            ++i6;
        }
        String bbirthdaytext = "";
        try {
            bbirthdaytext = new String(birthdaybyte, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        birthdaytext = bbirthdaytext.trim();
        flagofzero = false;
        byte[] addressbyte = new byte[100];
        int i7 = 0;
        while (i7 < 70) {
            if (inbytes1[i7 + 30 + 2 + 4 + 16] == 0) {
                if (flagofzero) break;
                flagofzero = true;
            } else {
                flagofzero = false;
            }
            addressbyte[i7] = inbytes1[i7 + 30 + 2 + 4 + 16];
            ++i7;
        }
        String baddresstext = "";
        try {
            baddresstext = new String(addressbyte, "UnicodeLittleUnmarked");
            this.writeFile("Log@@:baddresstext=" + baddresstext);
        }
        catch (UnsupportedEncodingException e) {
            this.writeFile("Log@@:out/05");
            e.printStackTrace();
        }
        addresstext = "";
        int i8 = 0;
        while (i8 < baddresstext.length()) {
            this.isc = NFCardReader.isChinese(baddresstext.charAt(i8));
            this.writeFile("Log@@:isc*1 = " + this.isc + " &&&& " + "i*1=" + i8);
            if (this.isc) {
                addresstext = String.valueOf(addresstext) + baddresstext.charAt(i8);
            } else if (NFCardReader.isNumber(baddresstext.charAt(i8))) {
                addresstext = String.valueOf(addresstext) + baddresstext.charAt(i8);
                this.writeFile("Log@@:isc*2 = " + this.isc + " &&&& " + "i*2=" + i8);
            } else if (this.isChineseLP(i8 + 1, addressbyte)) {
                addresstext = String.valueOf(addresstext) + this.rightchar;
                this.writeFile("Log@@:isc*3 = " + this.isc + " &&&& " + "i*3=" + i8);
            } else {
                addresstext = String.valueOf(addresstext) + ' ';
            }
            this.writeFile("Log@@:isc*4 = " + this.isc + " &&&& " + "i*4=" + i8);
            ++i8;
        }
        this.writeFile("log@@:Out##01");
        addresstext = baddresstext.trim();
        byte[] numberbyte = new byte[100];
        int i9 = 0;
        while (i9 < 36) {
            numberbyte[i9] = inbytes1[i9 + 30 + 2 + 4 + 16 + 70];
            ++i9;
        }
        String bnumbertext = "";
        try {
            bnumbertext = new String(numberbyte, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            this.writeFile("log@@:Out##02");
            e.printStackTrace();
        }
        numbertext = bnumbertext.trim();
        byte[] qianfabyte = new byte[100];
        flagofzero = false;
        int i10 = 0;
        while (i10 < 30) {
            if (inbytes1[i10 + 30 + 2 + 4 + 16 + 70 + 36] == 0) {
                if (flagofzero) {
                    this.writeFile("log@@:Out##03");
                    break;
                }
                flagofzero = true;
            } else {
                flagofzero = false;
            }
            qianfabyte[i10] = inbytes1[i10 + 30 + 2 + 4 + 16 + 70 + 36];
            ++i10;
        }
        String bqianfatext = "";
        try {
            bqianfatext = new String(qianfabyte, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            this.writeFile("log@@:Out##04");
            e.printStackTrace();
        }
        qianfatext = "";
        int i11 = 0;
        while (i11 < bqianfatext.length()) {
            this.isc = NFCardReader.isChinese(bqianfatext.charAt(i11));
            qianfatext = this.isc ? String.valueOf(qianfatext) + bqianfatext.charAt(i11) : (NFCardReader.isNumber(bqianfatext.charAt(i11)) ? String.valueOf(qianfatext) + bqianfatext.charAt(i11) : (this.isChineseLP(i11 + 1, qianfabyte) ? String.valueOf(qianfatext) + this.rightchar : String.valueOf(qianfatext) + ' '));
            ++i11;
        }
        this.writeFile("log@@:Out##05");
        qianfatext = bqianfatext.trim();
        byte[] startbyte = new byte[60];
        int i12 = 0;
        while (i12 < 16) {
            startbyte[i12] = inbytes1[i12 + 30 + 2 + 4 + 16 + 70 + 36 + 30];
            ++i12;
        }
        String bstarttext = "";
        try {
            bstarttext = new String(startbyte, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            this.writeFile("log@@:Out##06");
            e.printStackTrace();
        }
        starttext = bstarttext.trim();
        byte[] endbyte = new byte[60];
        int i13 = 0;
        while (i13 < 16) {
            endbyte[i13] = inbytes1[i13 + 30 + 2 + 4 + 16 + 70 + 36 + 30 + 16];
            ++i13;
        }
        String bendtext = "";
        try {
            bendtext = new String(endbyte, "UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            this.writeFile("log@@:Out##07");
            e.printStackTrace();
        }
        endtext = bendtext.trim();
        this.writeprocess("1");
        String filenamebmp = "/sdcard/yishu/zp.bmp";
        this.writeFile("Log@@:Picture path:" + filenamebmp);
        if (new File(filenamebmp).exists()) {
            new File(filenamebmp).delete();
        }
        byte[] bmpbytes = new byte[1024];
        int i14 = 0;
        while (i14 < 1024) {
            bmpbytes[i14] = recvresult[258 + i14];
            ++i14;
        }
        this.writeprocess("1");
        this.writeFile("pass callJNIByteusbwrite bmpbytes=" + NFCardReader.printHexString(bmpbytes));
        String filenamebase = "/sdcard/yishu/base.dat";
        this.writeFile("pass callJNIsprocess 1003");
        if (!new File(filenamebase).exists()) {
            this.writeFile("pass callJNIsprocess 1004");
            try {
                is = this.getClass().getResourceAsStream("/res/raw/base.dat");
                fos = new FileOutputStream(filenamebase);
                byte[] bufferbase = new byte[1920];
                count = 0;
                while ((count = is.read(bufferbase)) > 0) {
                    fos.write(bufferbase, 0, count);
                }
                fos.close();
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writeprocess("1");
        filenamebase = "/sdcard/yishu/license.lic";
        this.writeFile("pass callJNIsprocess 1005");
        if (!new File(filenamebase).exists()) {
            this.writeFile("pass callJNIsprocess 1006");
            try {
                is = this.getClass().getResourceAsStream("/res/raw/license.lic");
                fos = new FileOutputStream(filenamebase);
                byte[] bufferlic = new byte[32];
                count = 0;
                while ((count = is.read(bufferlic)) > 0) {
                    fos.write(bufferlic, 0, count);
                }
                fos.close();
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writeprocess("1");
        this.writeFile("pass callJNIsprocess 1007.00");
        try {
            this.writeFile("pass callJNIsprocess 1007.01");
            int ret = IDCReaderSDK.wltInit("/sdcard/yishu/");
            this.writeFile("pass callJNIsprocess 1007.02");
            if (ret == 0) {
                this.writeFile("pass callJNIsprocess 1007.03");
                byte[] byArray = new byte[12];
                byArray[0] = 5;
                byArray[2] = 1;
                byArray[4] = 91;
                byArray[5] = 3;
                byArray[6] = 51;
                byArray[7] = 1;
                byArray[8] = 90;
                byArray[9] = -77;
                byArray[10] = 30;
                byte[] byLicData = byArray;
                int t = IDCReaderSDK.wltGetBMP(bmpbytes, byLicData);
                this.writeFile("pass callJNIsprocess 1007");
                if (t == 1) {
                    this.writeFile("pass callJNIsprocess 1008");
                } else {
                    this.writeFile("pass callJNIsprocess 1009");
                }
            }
        }
        catch (Exception ret) {
            // empty catch block
        }
        this.writeprocess("1");
        filename = "/sdcard/yishu/zp.bmp";
        byte[] bmpdata = new byte[39580];
        this.writeFile("pass callJNIsprocess 1010");
        if (new File(filename).exists()) {
            this.writeFile("pass callJNIsprocess 1011");
            try {
                FileInputStream bmpin = new FileInputStream(filename);
                ((InputStream)bmpin).read(bmpdata);
                ((InputStream)bmpin).close();
                this.writeFile("pass callJNIsprocess 1012");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.writeFile("pass callJNIsprocess 1013");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.writeFile("pass callJNIsprocess 1014");
            }
        }
        this.writeprocess("1");
        int i15 = 0;
        while (i15 < 39580) {
            NFCardReader.recvbyterecvbmp[i15] = bmpdata[i15];
            ++i15;
        }
        return 90;
    }

    private native int NfccallJNIcheckdate(byte[] var1, String var2, int var3);

    private native int NfccallJNIByte(byte[] var1);

    private native byte[] NfccallJNIreceivetext(String var1, int var2, String var3);

    private native byte[] NfccallJNIreceivebmp(String var1, int var2, String var3);

    private native int NfccallJNIfirstprocess(String var1, int var2, byte[] var3, String var4, int var5, int var6);

    private native byte[] NfccallJNIsecondprocess(int var1, int var2);

    private native int NfccallJNIconnectprocess(String var1, int var2, byte[] var3, String var4, String var5, String var6);

    private native int callCDROut(String var1, int var2, String var3, String var4);

    private native byte[] DNNfccallJNIprocess(int var1);

    private native int DNNfccallJNIconnectprocess(String var1, int var2, String var3, String var4, String var5);

    private native byte[] ServiceOprocess(byte[] var1, String var2, String var3, String var4);

    private native int NfcJLfirstprocess(String var1, int var2, byte[] var3, String var4, int var5, int var6, byte[] var7, String var8, String var9, String var10);

    private native byte[] NfcJLsecondprocess(int var1, int var2);

    private native int NFCcallJNIBeginconnectprocess(String var1, int var2, byte[] var3, String var4, String var5, String var6);

    private native int NFCcallJNIserviceprocess(String var1, int var2);

    private native int NFCcallJNIclose(int var1);

    private native byte[] NFCcallJNIreceive(int var1, int var2);

    private native int NFCcallJNIsent(int var1, byte[] var2, int var3);

    private native int NfcPROfirstprocess(String var1, int var2, byte[] var3, String var4, int var5, int var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, int var14);

    private native byte[] NfcPROsecondprocess(int var1, int var2);

    private byte[] NfccallbacksousbWrite(byte[] Check) {
        byte[] InputReport = new byte[65];
        byte[] InputReportback = new byte[65];
        int len = Check[3] & 0xFF;
        byte[] inpara = new byte[len];
        boolean ret = false;
        int i = 0;
        while (i < len) {
            inpara[i] = Check[4 + i];
            ++i;
        }
        try {
            int InLen;
            this.writeprocess("1");
            this.writeFile("pass callJNIByteusbwrite Check=" + NFCardReader.printHexString(Check));
            InputReport = this.isodep.transceive(inpara);
            this.writeFile("pass callJNIByteusbwrite InputReport lenth=" + InputReport.length);
            if (InputReport[0] == 105 && InputReport[1] == -122) {
                InputReportback[0] = -1;
                InputReportback[1] = -1;
                InputReportback[2] = -1;
                InputReportback[3] = -1;
                InputReportback[4] = -1;
                InputReportback[5] = -1;
                InputReportback[6] = -1;
                InputReportback[7] = -1;
                InputReportback[8] = -1;
                InputReportback[9] = -1;
                ret = true;
            }
            this.writeFile("pass callJNIByteusbwrite InputReport 11");
            if (InputReport[0] == 105 && InputReport[1] == -126) {
                InputReportback[0] = -1;
                InputReportback[1] = -1;
                InputReportback[2] = -1;
                InputReportback[3] = -1;
                InputReportback[4] = -1;
                InputReportback[5] = -1;
                InputReportback[6] = -1;
                InputReportback[7] = -1;
                InputReportback[8] = -1;
                InputReportback[9] = -1;
                ret = true;
            }
            if ((InLen = InputReport.length) >= 2 && InputReport[InLen - 1] == 0 && InputReport[InLen - 2] == -112) {
                byte[] InputReportOut = new byte[InLen + 1];
                System.arraycopy(InputReport, 0, InputReportOut, 0, InLen);
                InputReportOut[InLen] = 0;
                return InputReportOut;
            }
            this.writeFile("pass callJNIByteusbwrite 22222222 InputReport=" + NFCardReader.printHexString(InputReport));
        }
        catch (TagLostException e) {
            e.printStackTrace();
            this.writeFile("pass callJNIByteusbwrite 22222222 TagLostException");
            InputReport[0] = -1;
            InputReport[1] = -1;
            InputReport[2] = -1;
            InputReport[3] = -1;
            InputReport[4] = -1;
            InputReport[5] = -1;
            InputReport[6] = -1;
            InputReport[7] = -1;
            InputReport[8] = -1;
            InputReport[9] = -1;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.writeFile("pass callJNIByteusbwrite 22222222 NullPointerException");
            InputReport[0] = -1;
            InputReport[1] = -1;
            InputReport[2] = -1;
            InputReport[3] = -1;
            InputReport[4] = -1;
            InputReport[5] = -1;
            InputReport[6] = -1;
            InputReport[7] = -1;
            InputReport[8] = -1;
            InputReport[9] = -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.writeFile("pass callJNIByteusbwrite 22222222 IOException");
            InputReport[0] = -1;
            InputReport[1] = -1;
            InputReport[2] = -1;
            InputReport[3] = -1;
            InputReport[4] = -1;
            InputReport[5] = -1;
            InputReport[6] = -1;
            InputReport[7] = -1;
            InputReport[8] = -1;
            InputReport[9] = -1;
        }
        if (ret) {
            return InputReportback;
        }
        return InputReport;
    }

    private byte[] NfccallbacksousbWrite11(byte[] Check) {
        byte[] InputReport = new byte[65];
        byte[] InputReportback = new byte[65];
        int len = Check[3] & 0xFF;
        byte[] inpara = new byte[len];
        boolean ret = false;
        int i = 0;
        while (i < len) {
            inpara[i] = Check[4 + i];
            ++i;
        }
        try {
            int InLen;
            this.writeprocess("1");
            InputReport = this.isodep.transceive(inpara);
            if (InputReport[0] == 105 && InputReport[1] == -122) {
                this.writeFile("pass NfccallbacksousbWrite11 EEEEEEEE T1");
                InputReportback[0] = -1;
                InputReportback[1] = -1;
                InputReportback[2] = -1;
                InputReportback[3] = -1;
                InputReportback[4] = -1;
                InputReportback[5] = -1;
                InputReportback[6] = -1;
                InputReportback[7] = -1;
                InputReportback[8] = -1;
                InputReportback[9] = -1;
                ret = true;
            }
            if (InputReport[0] == 105 && InputReport[1] == -126) {
                this.writeFile("pass NfccallbacksousbWrite11 EEEEEEEE T2");
                InputReportback[0] = -1;
                InputReportback[1] = -1;
                InputReportback[2] = -1;
                InputReportback[3] = -1;
                InputReportback[4] = -1;
                InputReportback[5] = -1;
                InputReportback[6] = -1;
                InputReportback[7] = -1;
                InputReportback[8] = -1;
                InputReportback[9] = -1;
                ret = true;
            }
            if ((InLen = InputReport.length) >= 2 && InputReport[InLen - 1] == 0 && InputReport[InLen - 2] == -112) {
                byte[] InputReportOut = new byte[InLen + 1];
                System.arraycopy(InputReport, 0, InputReportOut, 0, InLen);
                InputReportOut[InLen] = 0;
                return InputReportOut;
            }
        }
        catch (TagLostException e) {
            e.printStackTrace();
            this.writeFile("pass callJNIByteusbwrite EEEEEEEE TagLostException");
            InputReport[0] = -1;
            InputReport[1] = -1;
            InputReport[2] = -1;
            InputReport[3] = -1;
            InputReport[4] = -1;
            InputReport[5] = -1;
            InputReport[6] = -1;
            InputReport[7] = -1;
            InputReport[8] = -1;
            InputReport[9] = -1;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.writeFile("pass callJNIByteusbwrite EEEEEEEE NullPointerException");
            InputReport[0] = -1;
            InputReport[1] = -1;
            InputReport[2] = -1;
            InputReport[3] = -1;
            InputReport[4] = -1;
            InputReport[5] = -1;
            InputReport[6] = -1;
            InputReport[7] = -1;
            InputReport[8] = -1;
            InputReport[9] = -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.writeFile("pass callJNIByteusbwrite EEEEEEEE IOException");
            InputReport[0] = -1;
            InputReport[1] = -1;
            InputReport[2] = -1;
            InputReport[3] = -1;
            InputReport[4] = -1;
            InputReport[5] = -1;
            InputReport[6] = -1;
            InputReport[7] = -1;
            InputReport[8] = -1;
            InputReport[9] = -1;
        }
        if (ret) {
            return InputReportback;
        }
        return InputReport;
    }

    private byte[] NfccallbacksousbRead(byte[] Check) {
        byte[] InputReport = new byte[65];
        byte[] InputReportback = new byte[65];
        int len = Check[3] & 0xFF;
        byte[] inpara = new byte[len];
        boolean ret = false;
        int i = 0;
        while (i < len) {
            inpara[i] = Check[4 + i];
            ++i;
        }
        try {
            this.writeprocess("1");
            this.writeFile("pass callJNIByteusbwrite Check=" + NFCardReader.printHexString(Check));
            InputReport = this.isodep.getApplicationData();
            if (InputReport[0] == 0 && InputReport[1] == 0) {
                try {
                    InputReportback = this.isodep.transceive(inpara);
                    InputReport[0] = InputReportback[5];
                    InputReport[1] = InputReportback[6];
                    InputReport[2] = InputReportback[7];
                    InputReport[3] = InputReportback[8];
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.writeprocess("1");
            this.writeFile("pass callJNIByteusbwrite InputReport=" + NFCardReader.printHexString(InputReport));
            this.writeFile("pass callJNIByteusbwrite 333333333www");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            InputReport[0] = -1;
            InputReport[1] = -1;
            InputReport[2] = -1;
            InputReport[3] = -1;
            InputReport[4] = -1;
            InputReport[5] = -1;
            InputReport[6] = -1;
            InputReport[7] = -1;
            InputReport[8] = -1;
            InputReport[9] = -1;
        }
        return InputReport;
    }

    private long Nfccallbackgetcurrentmtime(byte[] Check) {
        return System.currentTimeMillis();
    }

    public String Name() {
        this.writeFile("pass Name() name=" + nametext);
        return nametext;
    }

    public int Sex() {
        return sexint;
    }

    public String SexL() {
        return sextext;
    }

    public int Nation() {
        return mingzuint;
    }

    public String NationL() {
        return mingzutext;
    }

    public String Born() {
        return birthdaytext;
    }

    public String BornL() {
        return String.valueOf(birthdaytext.substring(0, 4)) + "\u5e74" + birthdaytext.substring(4, 6) + "\u6708" + birthdaytext.substring(6, 8) + "\u65e5";
    }

    public String Address() {
        return addresstext;
    }

    public String CardNo() {
        return numbertext;
    }

    public String Police() {
        return qianfatext;
    }

    public String Activity() {
        return String.valueOf(starttext) + endtext;
    }

    public String ActivityL() {
        return String.valueOf(starttext.substring(0, 4)) + "." + starttext.substring(4, 6) + "." + starttext.substring(6, 8) + "-" + endtext.substring(0, 4) + "." + endtext.substring(4, 6) + "." + endtext.substring(6, 8);
    }

    public byte[] GetImage() {
        return recvbyterecvbmp;
    }

    public String DNcode() {
        return dncodetext;
    }

    public static void printHexString(byte[] b, int len) {
        String rstr = "";
        int i = 0;
        while (i < len) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            rstr = String.valueOf(rstr) + hex.toUpperCase();
            ++i;
        }
        Log.e((String)"For Test", (String)("Hex are: " + rstr));
    }

    public static byte[] intToByteArray1(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static String getSex(String input) {
        String Output = "\u672a\u77e5";
        String numb = "0";
        if (input.trim().equals(numb)) {
            Output = "\u672a\u77e5";
        }
        numb = "1";
        if (input.trim().equals(numb)) {
            Output = "\u7537";
        }
        numb = "2";
        if (input.trim().equals(numb)) {
            Output = "\u5973";
        }
        numb = "9";
        if (input.trim().equals(numb)) {
            Output = "\u672a\u8bf4\u660e";
        }
        return Output;
    }

    public static String getMinZu(String input) {
        String Output = "\u672a\u5b9a\u4e49";
        String numb = "00";
        if (input.trim().equals(numb)) {
            Output = "\u672a\u5b9a\u4e49";
        }
        numb = "01";
        if (input.trim().equals(numb)) {
            Output = "\u6c49";
        }
        numb = "02";
        if (input.trim().equals(numb)) {
            Output = "\u8499\u53e4";
        }
        numb = "03";
        if (input.trim().equals(numb)) {
            Output = "\u56de";
        }
        numb = "04";
        if (input.trim().equals(numb)) {
            Output = "\u85cf";
        }
        numb = "05";
        if (input.trim().equals(numb)) {
            Output = "\u7ef4\u543e\u5c14";
        }
        numb = "06";
        if (input.trim().equals(numb)) {
            Output = "\u82d7";
        }
        numb = "07";
        if (input.trim().equals(numb)) {
            Output = "\u5f5d";
        }
        numb = "08";
        if (input.trim().equals(numb)) {
            Output = "\u58ee";
        }
        numb = "09";
        if (input.trim().equals(numb)) {
            Output = "\u5e03\u4f9d";
        }
        numb = "10";
        if (input.trim().equals(numb)) {
            Output = "\u671d\u9c9c";
        }
        numb = "11";
        if (input.trim().equals(numb)) {
            Output = "\u6ee1";
        }
        numb = "12";
        if (input.trim().equals(numb)) {
            Output = "\u4f97";
        }
        numb = "13";
        if (input.trim().equals(numb)) {
            Output = "\u7476";
        }
        numb = "14";
        if (input.trim().equals(numb)) {
            Output = "\u767d";
        }
        numb = "15";
        if (input.trim().equals(numb)) {
            Output = "\u571f\u5bb6";
        }
        numb = "16";
        if (input.trim().equals(numb)) {
            Output = "\u54c8\u5c3c";
        }
        numb = "17";
        if (input.trim().equals(numb)) {
            Output = "\u54c8\u8428\u514b";
        }
        numb = "18";
        if (input.trim().equals(numb)) {
            Output = "\u50a3";
        }
        numb = "19";
        if (input.trim().equals(numb)) {
            Output = "\u9ece";
        }
        numb = "20";
        if (input.trim().equals(numb)) {
            Output = "\u5088\u50f3";
        }
        numb = "21";
        if (input.trim().equals(numb)) {
            Output = "\u4f64";
        }
        numb = "22";
        if (input.trim().equals(numb)) {
            Output = "\u7572";
        }
        numb = "23";
        if (input.trim().equals(numb)) {
            Output = "\u9ad8\u5c71";
        }
        numb = "24";
        if (input.trim().equals(numb)) {
            Output = "\u62c9\u795c";
        }
        numb = "25";
        if (input.trim().equals(numb)) {
            Output = "\u6c34";
        }
        numb = "26";
        if (input.trim().equals(numb)) {
            Output = "\u4e1c\u4e61";
        }
        numb = "27";
        if (input.trim().equals(numb)) {
            Output = "\u7eb3\u897f";
        }
        numb = "28";
        if (input.trim().equals(numb)) {
            Output = "\u666f\u9887";
        }
        numb = "29";
        if (input.trim().equals(numb)) {
            Output = "\u67ef\u5c14\u514b\u5b5c";
        }
        numb = "30";
        if (input.trim().equals(numb)) {
            Output = "\u571f";
        }
        numb = "31";
        if (input.trim().equals(numb)) {
            Output = "\u8fbe\u65a1\u5c14";
        }
        numb = "32";
        if (input.trim().equals(numb)) {
            Output = "\u4eeb\u4f6c";
        }
        numb = "33";
        if (input.trim().equals(numb)) {
            Output = "\u7f8c";
        }
        numb = "34";
        if (input.trim().equals(numb)) {
            Output = "\u5e03\u6717";
        }
        numb = "35";
        if (input.trim().equals(numb)) {
            Output = "\u6492\u62c9";
        }
        numb = "36";
        if (input.trim().equals(numb)) {
            Output = "\u6bdb\u5357";
        }
        numb = "37";
        if (input.trim().equals(numb)) {
            Output = "\u4ee1\u4f6c";
        }
        numb = "38";
        if (input.trim().equals(numb)) {
            Output = "\u9521\u4f2f";
        }
        numb = "39";
        if (input.trim().equals(numb)) {
            Output = "\u963f\u660c";
        }
        numb = "40";
        if (input.trim().equals(numb)) {
            Output = "\u666e\u7c73";
        }
        numb = "41";
        if (input.trim().equals(numb)) {
            Output = "\u5854\u5409\u514b";
        }
        numb = "42";
        if (input.trim().equals(numb)) {
            Output = "\u6012";
        }
        numb = "43";
        if (input.trim().equals(numb)) {
            Output = "\u4e4c\u5b5c\u522b\u514b";
        }
        numb = "44";
        if (input.trim().equals(numb)) {
            Output = "\u4fc4\u7f57\u65af";
        }
        numb = "45";
        if (input.trim().equals(numb)) {
            Output = "\u9102\u6e29\u514b";
        }
        numb = "46";
        if (input.trim().equals(numb)) {
            Output = "\u5fb7\u6602";
        }
        numb = "47";
        if (input.trim().equals(numb)) {
            Output = "\u4fdd\u5b89";
        }
        numb = "48";
        if (input.trim().equals(numb)) {
            Output = "\u88d5\u56fa";
        }
        numb = "49";
        if (input.trim().equals(numb)) {
            Output = "\u4eac";
        }
        numb = "50";
        if (input.trim().equals(numb)) {
            Output = "\u5854\u5854\u5c14";
        }
        numb = "51";
        if (input.trim().equals(numb)) {
            Output = "\u72ec\u9f99";
        }
        numb = "52";
        if (input.trim().equals(numb)) {
            Output = "\u9102\u4f26\u6625";
        }
        numb = "53";
        if (input.trim().equals(numb)) {
            Output = "\u8d6b\u54f2";
        }
        numb = "54";
        if (input.trim().equals(numb)) {
            Output = "\u95e8\u5df4";
        }
        numb = "55";
        if (input.trim().equals(numb)) {
            Output = "\u73de\u5df4";
        }
        numb = "56";
        if (input.trim().equals(numb)) {
            Output = "\u57fa\u8bfa";
        }
        numb = "57";
        if (input.trim().equals(numb)) {
            Output = "\u5176\u5b83";
        }
        return Output;
    }

    public Bitmap Bytes2Bimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
        }
        return null;
    }

    public static int getSexint(String input) {
        int Output = 0;
        String numb = "0";
        if (input.trim().equals(numb)) {
            Output = 0;
        }
        numb = "1";
        if (input.trim().equals(numb)) {
            Output = 1;
        }
        numb = "2";
        if (input.trim().equals(numb)) {
            Output = 2;
        }
        numb = "9";
        if (input.trim().equals(numb)) {
            Output = 9;
        }
        return Output;
    }

    public static int getMinZuint(String input) {
        int Output = 0;
        String numb = "00";
        if (input.trim().equals(numb)) {
            Output = 0;
        }
        numb = "01";
        if (input.trim().equals(numb)) {
            Output = 1;
        }
        numb = "02";
        if (input.trim().equals(numb)) {
            Output = 2;
        }
        numb = "03";
        if (input.trim().equals(numb)) {
            Output = 3;
        }
        numb = "04";
        if (input.trim().equals(numb)) {
            Output = 4;
        }
        numb = "05";
        if (input.trim().equals(numb)) {
            Output = 5;
        }
        numb = "06";
        if (input.trim().equals(numb)) {
            Output = 6;
        }
        numb = "07";
        if (input.trim().equals(numb)) {
            Output = 7;
        }
        numb = "08";
        if (input.trim().equals(numb)) {
            Output = 8;
        }
        numb = "09";
        if (input.trim().equals(numb)) {
            Output = 9;
        }
        numb = "10";
        if (input.trim().equals(numb)) {
            Output = 10;
        }
        numb = "11";
        if (input.trim().equals(numb)) {
            Output = 11;
        }
        numb = "12";
        if (input.trim().equals(numb)) {
            Output = 12;
        }
        numb = "13";
        if (input.trim().equals(numb)) {
            Output = 13;
        }
        numb = "14";
        if (input.trim().equals(numb)) {
            Output = 14;
        }
        numb = "15";
        if (input.trim().equals(numb)) {
            Output = 15;
        }
        numb = "16";
        if (input.trim().equals(numb)) {
            Output = 16;
        }
        numb = "17";
        if (input.trim().equals(numb)) {
            Output = 17;
        }
        numb = "18";
        if (input.trim().equals(numb)) {
            Output = 18;
        }
        numb = "19";
        if (input.trim().equals(numb)) {
            Output = 19;
        }
        numb = "20";
        if (input.trim().equals(numb)) {
            Output = 20;
        }
        numb = "21";
        if (input.trim().equals(numb)) {
            Output = 21;
        }
        numb = "22";
        if (input.trim().equals(numb)) {
            Output = 22;
        }
        numb = "23";
        if (input.trim().equals(numb)) {
            Output = 23;
        }
        numb = "24";
        if (input.trim().equals(numb)) {
            Output = 24;
        }
        numb = "25";
        if (input.trim().equals(numb)) {
            Output = 25;
        }
        numb = "26";
        if (input.trim().equals(numb)) {
            Output = 26;
        }
        numb = "27";
        if (input.trim().equals(numb)) {
            Output = 27;
        }
        numb = "28";
        if (input.trim().equals(numb)) {
            Output = 28;
        }
        numb = "29";
        if (input.trim().equals(numb)) {
            Output = 29;
        }
        numb = "30";
        if (input.trim().equals(numb)) {
            Output = 30;
        }
        numb = "31";
        if (input.trim().equals(numb)) {
            Output = 31;
        }
        numb = "32";
        if (input.trim().equals(numb)) {
            Output = 32;
        }
        numb = "33";
        if (input.trim().equals(numb)) {
            Output = 33;
        }
        numb = "34";
        if (input.trim().equals(numb)) {
            Output = 34;
        }
        numb = "35";
        if (input.trim().equals(numb)) {
            Output = 35;
        }
        numb = "36";
        if (input.trim().equals(numb)) {
            Output = 36;
        }
        numb = "37";
        if (input.trim().equals(numb)) {
            Output = 37;
        }
        numb = "38";
        if (input.trim().equals(numb)) {
            Output = 38;
        }
        numb = "39";
        if (input.trim().equals(numb)) {
            Output = 39;
        }
        numb = "4-";
        if (input.trim().equals(numb)) {
            Output = 40;
        }
        numb = "41";
        if (input.trim().equals(numb)) {
            Output = 41;
        }
        numb = "42";
        if (input.trim().equals(numb)) {
            Output = 42;
        }
        numb = "43";
        if (input.trim().equals(numb)) {
            Output = 43;
        }
        numb = "44";
        if (input.trim().equals(numb)) {
            Output = 44;
        }
        numb = "45";
        if (input.trim().equals(numb)) {
            Output = 45;
        }
        numb = "46";
        if (input.trim().equals(numb)) {
            Output = 46;
        }
        numb = "47";
        if (input.trim().equals(numb)) {
            Output = 47;
        }
        numb = "48";
        if (input.trim().equals(numb)) {
            Output = 48;
        }
        numb = "49";
        if (input.trim().equals(numb)) {
            Output = 49;
        }
        numb = "50";
        if (input.trim().equals(numb)) {
            Output = 50;
        }
        numb = "51";
        if (input.trim().equals(numb)) {
            Output = 51;
        }
        numb = "52";
        if (input.trim().equals(numb)) {
            Output = 52;
        }
        numb = "53";
        if (input.trim().equals(numb)) {
            Output = 53;
        }
        numb = "54";
        if (input.trim().equals(numb)) {
            Output = 54;
        }
        numb = "55";
        if (input.trim().equals(numb)) {
            Output = 55;
        }
        numb = "56";
        if (input.trim().equals(numb)) {
            Output = 56;
        }
        numb = "57";
        if (input.trim().equals(numb)) {
            Output = 57;
        }
        return Output;
    }

    public void writeprocess(String sb) {
        if (this.processflag == 0) {
            return;
        }
        ++this.processline;
        Message msg = new Message();
        msg.what = 20000002;
        if (this.processline < 99) {
            int progress_value = this.processline;
            msg.arg1 = this.processline;
            msg.obj = progress_value;
            this.mHandler.sendMessage(msg);
        }
    }

    public void writeEndprocess() {
        if (this.processflag == 0) {
            return;
        }
        Message msg = new Message();
        msg.what = 20000002;
        msg.arg1 = 100;
        int progress_value = 100;
        msg.obj = progress_value;
        this.mHandler.sendMessage(msg);
    }

    public void writeFile(String sb) {
        if (this.logflag == 1) {
            FileWriter fw = null;
            BufferedWriter bw = null;
            String datetime = "";
            try {
                SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS");
                datetime = tempDate.format(new Date()).toString();
                fw = new FileWriter("/sdcard/yishu/yishu.txt", true);
                bw = new BufferedWriter(fw);
                String myreadline = String.valueOf(datetime) + "[]" + sb;
                bw.write(String.valueOf(myreadline) + "\n");
                bw.newLine();
                bw.flush();
                bw.close();
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String printHexString(byte[] b) {
        String bstr = "";
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            bstr = String.valueOf(bstr) + " " + hex.toUpperCase();
            ++i;
        }
        return bstr;
    }

    public static String printHexStringDN(byte[] b, int len) {
        String bstr = "";
        int i = 0;
        while (i < len) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            bstr = i == 0 ? String.valueOf(bstr) + hex.toUpperCase() : String.valueOf(bstr) + " " + hex.toUpperCase();
            ++i;
        }
        return bstr;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || c == '\u00b7' || c == '.' || Character.isLetter(c) || c == '-' || c == '\u2014' || c == '?' || c == '\uff1f' || c == '(' || c == ')' || c == '\uff08' || c == '\uff09' || c == '[' || c == ']' || c == '{' || c == '}' || c == '\u3010' || c == '\u3011' || c == '|' || c == '+' || c == '~' || c == '!' || c == '\uff01' || c == '*' || c == '#' || c == '%' || c == '@' || c == '$' || c == '^' || c == '`' || c == '=' || c == ':' || c == '\uff1a' || c == '/';
    }

    public boolean isChineseLP(int seq, byte[] wbytes) {
        if (seq * 2 >= wbytes.length) {
            return false;
        }
        if (wbytes[seq * 2 - 2] == 32 && wbytes[seq * 2 - 1] == 0) {
            return false;
        }
        if (wbytes[seq * 2 - 2] == 0 && wbytes[seq * 2 - 1] == 0) {
            return false;
        }
        if (seq * 2 < wbytes.length) {
            byte[] unknownbytes = new byte[2];
            byte[] knownbytes = new byte[10];
            unknownbytes[0] = wbytes[seq * 2 - 2];
            unknownbytes[1] = wbytes[seq * 2 - 1];
            int gwresult = 0;
            if (!gwresult) {
                return false;
            }
            String rightstr = "";
            int i = 0;
            while (i < gwresult) {
                try {
                    rightstr = new String(knownbytes, "UnicodeLittleUnmarked");
                    this.rightchar = rightstr.charAt(i);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (NFCardReader.isChinese(this.rightchar)) break;
                ++i;
            }
            return true;
        }
        return false;
    }

    public void setwordsport(int wordsportin) {
        wordsport = wordsportin;
    }

    public void setwordsip(String wordsipin) {
        wordsip = wordsipin;
        wordsipsetflag = 1;
    }

    public void setwordstest(int wordstestin) {
        wordstest = wordstestin;
    }

    public static boolean isNumber(char c) {
        return Character.isLetterOrDigit(c) | c == '.' | c == '\u00b7' | c == '-';
    }

    public static class ClsUtils {
        public static boolean createBond(Class<? extends BluetoothDevice> btClass, BluetoothDevice btDevice) throws Exception {
            Method createBondMethod = btClass.getMethod("createBond", new Class[0]);
            Boolean returnValue = (Boolean)createBondMethod.invoke((Object)btDevice, new Object[0]);
            return returnValue;
        }

        public boolean removeBond(Class<?> btClass, BluetoothDevice btDevice) throws Exception {
            Method removeBondMethod = btClass.getMethod("removeBond", new Class[0]);
            Boolean returnValue = (Boolean)removeBondMethod.invoke((Object)btDevice, new Object[0]);
            return returnValue;
        }

        public boolean setPin(Class btClass, BluetoothDevice btDevice, String str) throws Exception {
            try {
                Method removeBondMethod = btClass.getDeclaredMethod("setPin", byte[].class);
                Boolean returnValue = (Boolean)removeBondMethod.invoke((Object)btDevice, new Object[]{str.getBytes()});
                Log.e((String)"returnValue", (String)("" + returnValue));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        public boolean cancelPairingUserInput(Class btClass, BluetoothDevice device) throws Exception {
            Method createBondMethod = btClass.getMethod("cancelPairingUserInput", new Class[0]);
            Boolean returnValue = (Boolean)createBondMethod.invoke((Object)device, new Object[0]);
            return returnValue;
        }

        public boolean cancelBondProcess(Class btClass, BluetoothDevice device) throws Exception {
            Method createBondMethod = btClass.getMethod("cancelBondProcess", new Class[0]);
            Boolean returnValue = (Boolean)createBondMethod.invoke((Object)device, new Object[0]);
            return returnValue;
        }

        public void printAllInform(Class<?> clsShow) {
            try {
                Method[] hideMethod = clsShow.getMethods();
                int i = 0;
                while (i < hideMethod.length) {
                    Log.e((String)"method name", (String)(String.valueOf(hideMethod[i].getName()) + ";and the i is:" + i));
                    ++i;
                }
                Field[] allFields = clsShow.getFields();
                i = 0;
                while (i < allFields.length) {
                    Log.e((String)"Field name", (String)allFields[i].getName());
                    ++i;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

