/*
 * Decompiled with CFR 0.152.
 */
package com.aircert.CommonActivity;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.aircert.util.ActivityController;
import com.xdja.aircert.common.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class ToolBarActivity
extends FragmentActivity {
    private FrameLayout mContainer;
    protected View top_layout;
    private View bg;
    protected TextView left_title_tv;
    protected ImageView leftBtn;
    protected ImageView rightBtn;
    public static final String OTHERS = "others";
    public static final String FACE_IMG = "faceImg";
    public static final String IDENTIFY_INFO = "identify_info";
    public static final String ID_CardInfo = "IDCardInfo";
    protected Context context;

    protected boolean hasActionBar() {
        return true;
    }

    public void setContentView(int layoutResID) {
        if (this.hasActionBar()) {
            View root = this.getLayoutInflater().inflate(layoutResID, null);
            int height = this.getResources().getDimensionPixelOffset(R.dimen.toolbar_height);
            int statusBarHeight = this.getResources().getDimensionPixelOffset(R.dimen.statusbar_height);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            lp.topMargin = height + statusBarHeight;
            root.setBackgroundColor(0);
            this.mContainer.addView(root, (ViewGroup.LayoutParams)lp);
            super.setContentView((View)this.mContainer);
        } else {
            super.setContentView(layoutResID);
        }
        if (this.isOCRActivity()) {
            ActivityController.getInstance().addOcrActivity(this);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this;
        if (this.hasActionBar()) {
            this.mContainer = new FrameLayout((Context)this);
            this.mContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.mContainer.setBackgroundColor(0);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.bg = this.getLayoutInflater().inflate(R.layout.bg_layout, null);
            this.mContainer.addView(this.bg, (ViewGroup.LayoutParams)lp);
            this.top_layout = this.getLayoutInflater().inflate(R.layout.top_layout, null);
            this.initView(this.top_layout);
            int height = this.getResources().getDimensionPixelOffset(R.dimen.toolbar_height);
            int statusBarHeight = this.getResources().getDimensionPixelOffset(R.dimen.statusbar_height);
            lp = new FrameLayout.LayoutParams(-1, height);
            lp.topMargin = statusBarHeight;
            this.top_layout.setBackgroundColor(0);
            this.mContainer.addView(this.top_layout, (ViewGroup.LayoutParams)lp);
        }
    }

    public String getTopActivity(Activity context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningTaskInfos = manager.getRunningTasks(1);
        if (runningTaskInfos != null) {
            return ((ActivityManager.RunningTaskInfo)runningTaskInfos.get((int)0)).topActivity.toString();
        }
        return null;
    }

    private void initView(View view) {
        this.leftBtn = (ImageView)view.findViewById(R.id.title_left_btn);
        this.left_title_tv = (TextView)view.findViewById(R.id.left_title_tv);
        this.rightBtn = (ImageView)view.findViewById(R.id.title_right_btn);
        this.initTopView();
    }

    protected void initTopView() {
        switch (this.getToolbarType()) {
            case 0: {
                this.leftBtn.setVisibility(0);
                this.leftBtn.setImageResource(R.drawable.icon_back);
                this.leftBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ToolBarActivity.this.onBackPressed();
                    }
                });
                break;
            }
            case 1: {
                this.leftBtn.setVisibility(8);
                break;
            }
        }
        this.top_layout.setBackgroundColor(this.getResources().getColor(R.color.navigator));
        if (this.getTitleRes() != -1) {
            this.left_title_tv.setText(this.getTitleRes());
        }
    }

    protected void setTitleRes(int title) {
        this.left_title_tv.setText(title);
    }

    @StringRes
    protected int getTitleRes() {
        return R.string.title;
    }

    protected int getToolbarType() {
        return 0;
    }

    protected void setToolbarRightBtn(int drewableId, View.OnClickListener listener) {
        this.rightBtn.setVisibility(0);
        if (drewableId != 0) {
            this.rightBtn.setImageDrawable(ContextCompat.getDrawable((Context)this.getApplicationContext(), (int)drewableId));
        }
        if (listener != null) {
            this.rightBtn.setOnClickListener(listener);
        }
    }

    protected boolean isOCRActivity() {
        return false;
    }

    public void onBackPressed() {
        if (this.isOCRActivity()) {
            ActivityController.getInstance().removeOcrActivity(this);
        } else {
            this.finish();
            this.overridePendingTransition(R.anim.right_in, R.anim.right_out);
        }
    }

    protected void setLeftBtnListener(View.OnClickListener onClickListener) {
        this.leftBtn.setOnClickListener(onClickListener);
    }

    public static class ToolBarDef {
        public static final int NAVIGATE_BACK = 0;
        public static final int NAVIGATE_DEFAULT = 1;
        public static final int NAVIGATE_OTHER = 2;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NavigateType {
        }
    }
}

