package com.aircert.CommonActivity;


import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntDef;
import android.support.annotation.StringRes;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.aircert.common.R;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;


public class ToolBarActivity extends FragmentActivity {

    private FrameLayout mContainer;
    protected View top_layout;
    private View bg;
    protected TextView left_title_tv;

    protected ImageView leftBtn;

    protected TextView rightBtn;

    public static final String OTHERS = "others"; //其他需要传递的Bundle的key值

    public static final String FACE_IMG = "faceImg";
    public static final String IDENTIFY_INFO = "identify_info"; //传过来身份信息key
    public static final String ID_CardInfo = "IDCardInfo";

    protected Context context;


    protected boolean hasActionBar() {
        return true;
    }

    @Override
    public void setContentView(int layoutResID) {
        if (hasActionBar()) {
            View root = getLayoutInflater().inflate(layoutResID, null);
            int height = getResources().getDimensionPixelOffset(R.dimen.toolbar_height);
            int statusBarHeight = getResources().getDimensionPixelOffset(R.dimen.statusbar_height);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
            lp.topMargin = height + statusBarHeight;

            root.setBackgroundColor(Color.TRANSPARENT);
            mContainer.addView(root, lp);
            super.setContentView(mContainer);
        } else {
            super.setContentView(layoutResID);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        context = this;
        if (hasActionBar()) {

            mContainer = new FrameLayout(this);
            mContainer.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.FILL_PARENT,
                    FrameLayout.LayoutParams.MATCH_PARENT));
            mContainer.setBackgroundColor(Color.TRANSPARENT);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT,
                    FrameLayout.LayoutParams.MATCH_PARENT);
            bg = getLayoutInflater().inflate(R.layout.bg_layout, null);
            mContainer.addView(bg, lp);

            top_layout = getLayoutInflater().inflate(R.layout.top_layout, null);

            initView(top_layout);
            int height = getResources().getDimensionPixelOffset(R.dimen.toolbar_height);//R.dimen.toolbar_height
            int statusBarHeight = getResources().getDimensionPixelOffset(R.dimen.statusbar_height);
            lp = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, height);
            lp.topMargin = statusBarHeight;
            top_layout.setBackgroundColor(Color.TRANSPARENT);

            mContainer.addView(top_layout, lp);
        }
    }

    public void hideBG() {
        bg.setVisibility(View.GONE);
    }

    public String getTopActivity(Activity context) {
        ActivityManager manager = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> runningTaskInfos = manager.getRunningTasks(1);

        if (runningTaskInfos != null) {
            return (runningTaskInfos.get(0).topActivity).toString();
        } else {
            return null;
        }
    }


    private void initView(View view) {
        leftBtn = (ImageView) view.findViewById(R.id.title_left_btn);
        left_title_tv = (TextView) view.findViewById(R.id.left_title_tv);
        rightBtn = (TextView) view.findViewById(R.id.title_right_btn);


        initTopView();
    }


    protected void initTopView() {
        switch (getToolbarType()) {
            case ToolBarDef.NAVIGATE_BACK:
                leftBtn.setVisibility(View.VISIBLE);
                leftBtn.setImageResource(R.drawable.icon_back);
                leftBtn.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onBackPressed();

                    }
                });

                left_title_tv.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        onBackPressed();
                    }
                });

                break;

            case ToolBarDef.NAVIGATE_DEFAULT:
                leftBtn.setVisibility(View.GONE);
                break;
            case ToolBarDef.NAVIGATE_OTHER:
            default:
                break;
        }
        top_layout.setBackgroundColor(getResources().getColor(R.color.navigator));
        if (getTitleRes() != -1) {
            left_title_tv.setText(getTitleRes());
        }
    }


    protected void setTitleRes(int title) {
        left_title_tv.setText(title);
    }

    /**
     * 设置显示Title
     *
     * @return
     */
    @StringRes
    protected int getTitleRes() {
        return R.string.cert_creation_title;
    }

    @ToolBarDef.NavigateType
    protected int getToolbarType() {
        return ToolBarDef.NAVIGATE_BACK;
    }

    public static class ToolBarDef {

        //导航栏显示为后退
        public static final int NAVIGATE_BACK = 0;

        //默认导航栏
        public static final int NAVIGATE_DEFAULT = 1;

        public static final int NAVIGATE_OTHER = 2;

        @IntDef({NAVIGATE_BACK, NAVIGATE_DEFAULT, NAVIGATE_OTHER})
        @Retention(RetentionPolicy.SOURCE)
        public @interface NavigateType {
        }

    }

    protected void setRightText(@StringRes int resId, View.OnClickListener listener) {
        rightBtn.setVisibility(View.VISIBLE);

        rightBtn.setText(resId);

        if (listener != null) {
            rightBtn.setOnClickListener(listener);
        }
    }

    protected void setRightImage(@DrawableRes int drawableId, View.OnClickListener listener) {

        rightBtn.setVisibility(View.VISIBLE);

        if (drawableId != 0) {

            Drawable drawable = context.getResources().getDrawable(drawableId);

            drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());//必须设置图片大小，否则不显示

            rightBtn.setCompoundDrawables(drawable, null, null, null);

        }
        if (listener != null) {
            rightBtn.setOnClickListener(listener);
        }
    }

    /**
     * 是否是身份认证相关页面,如果是将其添加于身份认证页面栈中，方便统一管理
     *
     * @return
     */
    protected boolean isOCRActivity() {
        return false;
    }


    @Override
    public void onBackPressed() {
        overridePendingTransition(R.anim.right_in, R.anim.right_out);
        finish();

    }

    /**
     * 设置左侧按钮点击事件
     *
     * @param onClickListener
     */
    protected void setLeftBtnListener(View.OnClickListener onClickListener) {
        leftBtn.setOnClickListener(onClickListener);
    }


}
