package com.aircert;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;

import com.aircert.listener.OnPermissionListener;
import com.aircert.listener.RationaleListener;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by xwy on 2017/8/3.
 */

public class SPermission {

    private  SPermission sPermission = null;
    /**
     * 工作模式有两种：
     * 1.在需要请求的地方只请求一次，随后直接处理
     * 2.在onResume()设置请求，每次页面出现的时候都会进行请求
     */

    public static final int CHECK_ONCE = 1;
    public static final int CHECK_ALWAYS = 2;

    private int MOUDLE = 1;

    private int mRequestCode = -1;
    //权限请求回调结果
    private OnPermissionListener mOnPermissionListener;

    private RationaleListener rationaleListener;
    private Context context;
    private String[] permissions;

    //本次请求是否需要展示请求框
    private boolean isActive = true;
    //是否有rationaleDialog在显示
    private boolean isDialogShow = false;

    @TargetApi(Build.VERSION_CODES.M)
    public void requestPermissionsAgain() {
        if (context instanceof Activity) {
            ((Activity) context).requestPermissions(permissions, mRequestCode);
        } else {
            throw new IllegalArgumentException("Context must be an Activity");
        }
    }

    @TargetApi(Build.VERSION_CODES.M)
    public void requestPermissions() {

        //1.版本小于23，直接返回成功
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            callbackSucceed();
            return;
        }
        //2、检查是否有rationaleListener，如果有则处理
        if (rationaleListener != null) {
            boolean rationale = false;
            String p = null;
            for (String permission : permissions) {
                rationale = ((Activity) context).shouldShowRequestPermissionRationale(permission);

                if (rationale) {
                    p = permission;
                    break;
                }
            }
            if (isDialogShow) {
                return;
            }
            if (p != null && isActive) {
                rationaleListener.onRationaleResult(p);
                setDialogShow(true);
                rationaleListener = null;
                return;
            }
        }
        //3.判断是否是请求的时候在onResume()中的回调，如果是则不再进行请求
        if (!isActive) return;
        String[] deniedPermissions = getDeniedPermissions(context, permissions);
        if (deniedPermissions.length > 0 && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            requestPermissionsAgain();
        } else {
            if (mOnPermissionListener != null) mOnPermissionListener.onPermissionGranted();
        }
    }

    /**
     * 请求权限结果，对应Activity中onRequestPermissionsResult()方法。
     */
    public void onRequestPermissionsResult(int requestCode,
                                                  @NonNull String[] permissions, int[] grantResults) {
        if (sPermission != null)
            sPermission.onRequestPermissionsResult(requestCode, permissions);
    }

    /**
     * 打开下次请求时候弹出系统请求弹窗的开关
     */
    public void activeSPermission() {
        if (!isDialogShow) {
            setActive(true);
        }
    }

    /**
     * 真正的处理请求权限结果。
     */
    private void onRequestPermissionsResult(int requestCode,
                                            @NonNull String[] permissions) {
        if (mRequestCode != -1 && requestCode == mRequestCode) {

            if (mOnPermissionListener != null) {

                String[] deniedPermissions = getDeniedPermissions(context, permissions);
                if (deniedPermissions.length > 0) {
                    boolean alwaysDenied = hasAlwaysDeniedPermission(context, permissions);
                    if (alwaysDenied) {
                        //请求被永远拒绝
                        if (MOUDLE == CHECK_ALWAYS) {
                            isActive = false;
                        }
                        mOnPermissionListener.onPermissionDeniedAlways(deniedPermissions);
                        return;
                    }
                    //请求被拒绝
                    if (MOUDLE == CHECK_ALWAYS) {
                        isActive = false;
                    }
                    mOnPermissionListener.onPermissionDenied(deniedPermissions);
                } else {
                    //请求通过
                    mOnPermissionListener.onPermissionGranted();
                }
            }
        }
    }

    /**
     * Build.VERSION.SDK_INT < Build.VERSION_CODES.M
     * 直接返回成功
     */
    private void callbackSucceed() {
        if (mOnPermissionListener != null) {
            mOnPermissionListener.onPermissionGranted();
        }
    }

    /**
     * 获取请求权限中需要授权的权限
     */
    private String[] getDeniedPermissions(@NonNull Context context, @NonNull String[] permissions) {
        List<String> deniedPermissions = new ArrayList<>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(context, permission) == PackageManager.PERMISSION_DENIED) {
                //此时在系统检查没有此权限
                deniedPermissions.add(permission);
            }
        }
        return deniedPermissions.toArray(new String[deniedPermissions.size()]);
    }

    /**
     * 是否彻底拒绝了某项权限
     */
    private boolean hasAlwaysDeniedPermission(@NonNull Context context, @NonNull String... deniedPermissions) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) return false;
        boolean rationale;
        for (String permission : deniedPermissions) {
            rationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity) context, permission);
            if (!rationale) return true;
        }
        return false;
    }


    private void setActive(boolean active) {
        isActive = active;
    }

    public void setDialogShow(boolean dialogShow) {
        isDialogShow = dialogShow;
    }

    public  SPermission getsPermission() {
        return sPermission;
    }

    public SPermission setmOnPermissionListener(OnPermissionListener mOnPermissionListener) {
        this.mOnPermissionListener = mOnPermissionListener;
        return this;
    }

    public SPermission setRationaleListener(RationaleListener rationaleListener) {
        this.rationaleListener = rationaleListener;
        return this;
    }

    public SPermission setmRequestCode(int mRequestCode) {
        this.mRequestCode = mRequestCode;
        return this;
    }

    public SPermission setPermissions(String[] permissions) {
        this.permissions = permissions;
        return this;
    }

    public SPermission setMOUDLE(int MOUDLE) {
        if (MOUDLE != CHECK_ONCE && MOUDLE != CHECK_ALWAYS){
            throw new IllegalArgumentException("Invalid moudle");
        }
        this.MOUDLE = MOUDLE;
        return this;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public SPermission(Context context) {
        this.context = context;
    }

    public void setsPermission(SPermission sPermission) {
        this.sPermission = sPermission;

    }

    //    public static SPermission with(@NonNull Context context) {
//        if (sPermission != null) {
//            sPermission.setContext(context);
//            return sPermission;
//        }
//        sPermission = new SPermission(context);
//        return sPermission;
//    }
}
