package com.aircert.util;

import android.content.Context;

import com.xdja.aircert.common.R;

import java.util.List;

/**
 * Created by zjc on 2019/1/26 0026.
 */

public class HTMLText {

    /**
     * @param context
     * @param permission
     * @return
     */
    public static final String formatPermissionText(Context context, List<String> permission) {

        StringBuffer sb = new StringBuffer();

        // TODO: 2019/1/26 0026 写了个类叫HTMLText，之后方法里的代码移过去

        sb.append("<font color='");
        sb.append(context.getResources().getColor(R.color.dialog_content_font_color));
        sb.append("'>");


        sb.append(context.getString(R.string.verify_permission_content));
        sb.append("</font>");

        sb.append("<br>");
        sb.append("<br>");

        for (String str : permission) {

            if (str == null) {
                continue;
            }

            sb.append(formatSinglePermission(context, str));

            if (!str.equals(permission.get(permission.size() - 1))) {
                // 现在两个权限之间的间距是用换行实现的
                // 最后一个权限后不用换行，否则会下边距过大
                sb.append("<br>");
                sb.append("<br>");
            }

        }

        return sb.toString();

    }

    /**
     * @param context
     * @param permissionText
     * @return
     */
    private static String formatSinglePermission(Context context, String permissionText) {

        StringBuilder sb = new StringBuilder();

        sb.append("<font color='");
        sb.append(context.getResources().getColor(R.color.dialog_title_font_color));
        sb.append("'>");

        sb.append(permissionText);

        sb.append("</font>");

        return sb.toString();

    }


}
