package com.aircert;

import android.app.Activity;
import android.content.Context;

import java.util.ArrayList;
import java.util.List;

public class ActivityStackManager {

    private static ActivityStackManager instance;

    public static ActivityStackManager getInstance() {
        if (instance == null)
            instance = new ActivityStackManager();
        return instance;
    }

    private List<Activity> stack = new ArrayList<>();


    public void add(Activity activity) {
        stack.add(activity);
    }

    public void remove(Activity activity) {
        stack.remove(activity);
    }

    public void removeAll() {
        for (Activity activity : stack) {
            if (!activity.isFinishing()) {
                activity.finish();
            }
        }
        stack.clear();
    }

    /**
     * 返回当前应用内栈顶的activity
     *
     * @return
     */
    public Context getTopContext() {
        if (stack.size() <= 0) return null;
        return stack.get(0);
    }

    /**
     * 得到MainActivity
     *
     * @return
     */
    public List<Activity> getActviityContext() {
        return stack;
    }
}
