package com.aircert;

import com.squareup.otto.Bus;
import com.squareup.otto.ThreadEnforcer;

/**
 * Created by zjc on 2016/9/26 0026.
 */
public class BusProvider {

    public static final Bus mainBus = new Bus(ThreadEnforcer.ANY);

    public static Bus getMainProvider() {
        return mainBus;
    }

    public static void register(Object object) {
        getMainProvider().register(object);
    }

    public static void unRegister(Object object) {
        getMainProvider().unregister(object);
    }

    /**
     * 从封装的角度而言，是可以直接调用post的
     * 但是因为Otto的插件可以跳转到Otto接收的地方
     * 所以BusProvider.getMainProvider().post(new Object());
     * 的方式看起来可能更方便
     *
     * @param object
     */
    public static void post(Object object) {
        getMainProvider().post(object);
    }


}
