package com.aircert;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;

import com.aircert.util.LogcatUtil;
import com.xdja.log.LogModule;
import com.xdja.log.XdjaLog;

import java.io.File;

/**
 * 用户抓取程序运行logcat，并输出到文件
 * Created by xingjianqiang on 2018/12/1.
 */

public class LogcatService extends Service{

    private static final String THIS_FILE = "LogcatService";
    private boolean stop = false;

    private int maxFileCount = 4;
//    private long maxFileSize = 128 * 1024 * 1024;
    private long maxFileSize = 32*1024L*1024L;
    private static final String BACKUP_PREFIX = "log_backup_";

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void backupLogFile(File logFile) {
        String logPath = LogcatUtil.getFilePath();
        if (!new File(logPath).exists()) {
            XdjaLog.e(THIS_FILE, "Error!! Log file path not exists");
            return;
        }
        int index;
        for (index=0;index<maxFileCount;index++) {
            String backupName = logPath + BACKUP_PREFIX + index + ".log";
            File file = new File(backupName);
            if (!file.exists()) {
                XdjaLog.d(THIS_FILE, "Backup file " + logFile.getAbsolutePath() + "  to  " + backupName);
                logFile.renameTo(file);
                return;
            }
        }

        XdjaLog.d(THIS_FILE, "Backup file is full. Delete first and rename current log file");
        String firstBackupName = logPath + BACKUP_PREFIX + "0.log";
        File firtFile = new File(firstBackupName);
        firtFile.delete();

        for (index=1;index<maxFileCount;index++) {
            String backupName = logPath + BACKUP_PREFIX + index + ".log";
            File file = new File(backupName);
            file.renameTo(new File(logPath + BACKUP_PREFIX + (index-1) + ".log"));
        }

        // backup current file
        String currentBackupName = logPath + BACKUP_PREFIX + (maxFileCount-1) + ".log";
        logFile.renameTo(new File(currentBackupName));

    }

    @Override
    public void onCreate() {
        // 启动记录logcat的线程
        LogcatUtil.setFilePath(LogModule.getRootPath() + File.separator + "logcat" + File.separator);
        LogcatUtil.cleanHistory();
        boolean success = LogcatUtil.startCapture();

        if (!success) {
            XdjaLog.e(THIS_FILE, "Error to start capture logcat!");
        } else {
            // 启动监听线程，因为子进程会被系统回收所以需要监听
            new Thread(new Runnable() {
                @Override
                public void run() {
                    while(!stop) {
                        // check file size
                        File logFile = LogcatUtil.getLogFile();
                        if (logFile.length() >= maxFileSize) {
                            LogcatUtil.stopCapture();
                            XdjaLog.d(THIS_FILE, "Log file size exceed! Backup file");
                            backupLogFile(logFile);


                            LogcatUtil.startCapture();
                        }


                        Process process = LogcatUtil.getProcess();

                        boolean isAlive = false;
                        try {
                            int exitValue = process.exitValue();
                            if (exitValue != 0) {
                                isAlive = false;
                            }
                        } catch (IllegalThreadStateException e) {
//                            e.printStackTrace();
                            isAlive = true;
                        }

                        if (!isAlive) {
                            XdjaLog.e(THIS_FILE, "Logcat thread died!!!");
                            LogcatUtil.resumeCapture();
                        }

                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }

                    }

                    XdjaLog.d(THIS_FILE, "Logcat thread normal stop!!!");
                }
            }).start();
        }
        super.onCreate();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        // 停止日志线程
        stop = true;
        LogcatUtil.stopCapture();
        super.onDestroy();
    }
}
