package com.aircert.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.Html;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.xdja.aircert.common.R;


/**
 * Created by guoyaxin on 2016/8/11.
 */
public class BindIdentifyDialog extends Dialog {


    TextView tv_title;

    TextView tv_content;


    EditText et_content;

    TextView pin_tips;

    Button btn_negative;

    Button btn_positive;


    private String message;
    private String title;
    private String positiveButtonText;
    private String negativeButtonText;
    private Context context;
    private ClickListenerInterface clickListenerInterface;


    public final static int DEFAULT_MODEL = 1;
    public final static int MID_MODEL = 2;
    public final static int PIN_MODEL = 3;

    public void setModel(int model) {
        this.model = model;
    }

    private int model = DEFAULT_MODEL;

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessage(@StringRes int message) {
        this.message = context.getString(message);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitle(@StringRes int title) {
        this.title = context.getString(title);
    }

    public void setPositiveButtonText(String positiveButtonText) {
        this.positiveButtonText = positiveButtonText;
    }

    public void setNegativeButtonText(String negativeButtonText) {
        this.negativeButtonText = negativeButtonText;
    }

    public void setPositiveButtonText(@StringRes int positiveButtonText) {
        this.positiveButtonText = context.getString(positiveButtonText);
    }

    public void setNegativeButtonText(@StringRes int negativeButtonText) {
        this.negativeButtonText = context.getString(negativeButtonText);
    }


    public BindIdentifyDialog(Context context) {

        super(context, R.style.Theme_AppCompat_Dialog);

        this.context = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

        if (model == MID_MODEL) {
            // 权限弹窗、证书到期更新弹窗等 1.7.3提示
            setContentView(R.layout.dialog_bind_identify_middle);
        } else if (model == DEFAULT_MODEL) {
            //
            setContentView(R.layout.dialog_bind_identify);
        } else if (model == PIN_MODEL) {
            // PIN码弹窗 1.7.2弹窗 1.7.1弹窗
            setContentView(R.layout.pin_dialog_layout);
        }

        tv_title = (TextView) findViewById(R.id.tv_title);

        tv_content = (TextView) findViewById(R.id.tv_content);

        btn_negative = (Button) findViewById(R.id.btn_negative);

        btn_positive = (Button) findViewById(R.id.btn_positive);

        tv_title.setText(title);

        // 在1.9.1授权弹窗1中
        // 需要换行操作，但是使用5dp的行间距会和换行效果叠加导致实际效果不佳
        // 因此设置行间距为0（默认不设置是0），1倍行高（默认是1，不能设置0）
        if (android.text.TextUtils.isEmpty(message) && tv_content != null) {
            if (message.contains("<br>")) {
                tv_content.setLineSpacing(0, 1);
            }
        }


        if (tv_content != null) {
            tv_content.setText(Html.fromHtml(message));
        }


        et_content = (EditText) findViewById(R.id.et_content);
        if (et_content != null) {
            pin_tips = (TextView) findViewById(R.id.tv_pin_code_tip);
        }


        btn_negative.setText(negativeButtonText);
        btn_positive.setText(positiveButtonText);

        btn_negative.setOnClickListener(new clickListener());
        btn_positive.setOnClickListener(new clickListener());


    }


    public String getPinCode() {
        return et_content.getText().toString();
    }

    public void clearPin() {
        if (et_content != null) et_content.setText("");
        if (pin_tips != null) pin_tips.setText("");
    }

    public void showPinTips(String tips) {
        pin_tips.setText(tips);
        pin_tips.setVisibility(View.VISIBLE);
    }


    public interface ClickListenerInterface {

        void doConfirm();

        void doCancel();
    }

    public void setClickListener(ClickListenerInterface clickListener) {
        this.clickListenerInterface = clickListener;
    }


    private class clickListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            int id = v.getId();
            if (id == R.id.btn_negative) {
                clickListenerInterface.doCancel();

            } else if (id == R.id.btn_positive) {
                clickListenerInterface.doConfirm();

            }
        }
    }

}
