package com.aircert.dialog;

/**
 * Created by Administrator on 2019/1/30 0030.
 */

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Settings;
import android.support.annotation.IntDef;

import com.xdja.aircert.common.R;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Created by zjc on 2019/1/30 0030.
 */

public class SinglePermissionDialog {

    public static final int PERMISSION_PHONE = 0;

    public static final int PERMISSION_STORAGE_TAKE_PHOTO = 1;

    public static final int PERMISSION_TAKE_PHOTO = 2;

    int permission;

    BindIdentifyDialog dialog;

    OnClickListener listener;

    public interface OnClickListener {

        void onPositive();

    }

    @IntDef({PERMISSION_PHONE, PERMISSION_STORAGE_TAKE_PHOTO, PERMISSION_TAKE_PHOTO})
    @Retention(RetentionPolicy.SOURCE)
    public @interface PermissionType {
    }


    public SinglePermissionDialog setListener(OnClickListener listener) {
        this.listener = listener;
        return this;
    }

    public BindIdentifyDialog build(final Context context, String message) {
        this.permission = permission;

        dialog = new BindIdentifyDialog(context);

        dialog.setTitle(R.string.verify_permission_title);

        // 理想状况下getPermissionMessage是不会返回0的
        dialog.setMessage(message);
        dialog.setModel(BindIdentifyDialog.MID_MODEL);
        dialog.setNegativeButtonText(R.string.refuse);
        dialog.setPositiveButtonText(R.string.acu_can_not_open_power_right_button);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        dialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {
                dialog.dismiss();
                if (listener != null) {
                    listener.onPositive();
                } else {
                    gotoSetting(context);
                }
            }

            @Override
            public void doCancel() {
                dialog.dismiss();
            }
        });

        return dialog;
    }

    public BindIdentifyDialog build(final Context context, @PermissionType int permission) {

        return build(context, context.getString(R.string.permission_content, context.getString(getPermissionMessage(permission))));

    }

    public void show() {
        dialog.show();
    }

    private int getPermissionMessage(int permission) {
        if (permission == PERMISSION_PHONE) {
            return R.string.permission_phone;
        } else if (permission == PERMISSION_STORAGE_TAKE_PHOTO) {
            return R.string.permission_storage_take_photo;
        } else if (permission == PERMISSION_TAKE_PHOTO) {
            return R.string.permission_take_photo;
        } else {
            return 0;
        }
    }

    /**
     * 跳转到设置权限页面
     */
    private void gotoSetting(Context context) {
        Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts("package", context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }


}

